/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.jp1.convertors.CalendarConvertor;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JP1CalendarsConvertor {
    private final Map<Integer, JP1Calendar> groupToCalendarMap = new HashMap<Integer, JP1Calendar>();
    private final List<CtmCalendar> regularCalendars = new ArrayList<CtmCalendar>();
    private final CalendarConvertor calendarGetter = new CalendarConvertor();
    private static final Map<String, Integer> MONTH_MAP = new HashMap<String, Integer>();
    private final Pattern regCalendarPattern = Pattern.compile("(?<month>\\D+)\\s(?<year>\\d+)\\s(\\D+)\\s(\\D+)\\s(\\d+)\\s(\\d+)\\s(?<days>.*)", 2);

    public void addCalendar(Integer id, List<Pair<String, String>> attributes) {
        Attributes attributesObj = new Attributes(attributes);
        if (attributesObj.findFirstValue("op").isPresent() || attributesObj.findFirstValue("cl").isPresent()) {
            JP1Calendar calendar = this.calendarGetter.getCalendar(id, attributes);
            this.groupToCalendarMap.put(id, calendar);
        }
    }

    public void addRegularCalendar(String name, String content) {
        String[] rows;
        CtmCalendar cal = new CtmCalendar(name, Params.instance().getDatacenterName());
        for (String row : rows = content.split("\n")) {
            Matcher matcher = this.regCalendarPattern.matcher(row.trim());
            if (!matcher.find()) continue;
            int year = Integer.parseInt(matcher.group("year").trim());
            int month = MONTH_MAP.get(matcher.group("month").trim().toUpperCase());
            String days = matcher.group("days").replaceAll(" ", "");
            for (int i = 0; i < 31; ++i) {
                if (days.length() <= i || 'o' != days.charAt(i)) continue;
                cal.addDay(year, month, i + 1);
            }
        }
        this.regularCalendars.add(cal);
    }

    public String getCalendarNameByGroupId(Integer id, boolean open) {
        String retName = "NOT FOUND";
        if (this.groupToCalendarMap.containsKey(id)) {
            retName = (open ? this.groupToCalendarMap.get(id).getOpenCalendar() : this.groupToCalendarMap.get(id).getClosedCalendar()).getName();
        }
        return retName;
    }

    public String getOpenCalendarNameByGroupId(Integer id) {
        return this.getCalendarNameByGroupId(id, true);
    }

    public String getCloseCalendarNameByGroupId(Integer id) {
        return this.getCalendarNameByGroupId(id, false);
    }

    public Optional<JP1Calendar> getCalendarByGroupId(Integer id) {
        if (this.groupToCalendarMap.containsKey(id)) {
            return Optional.of(this.groupToCalendarMap.get(id));
        }
        return Optional.empty();
    }

    public void writeCalendars() {
        try (DefCalFile writer = DefCalFile.createDefCalFile();){
            for (JP1Calendar cal2 : this.groupToCalendarMap.values()) {
                writer.write(cal2.getOpenCalendar(), false);
                writer.write(cal2.getClosedCalendar(), false);
            }
            this.regularCalendars.forEach(cal -> {
                writer.write(cal, false);
                writer.writeRBC(this.makeRbcFromRegular((CtmCalendar)cal));
            });
        }
        catch (IOException e) {
            ConversionLogger.getLogger().severe("Failed to open calendar file <" + String.valueOf(GlobalFunctions.getTempCalendarFilePath()) + "> for writing.");
        }
    }

    private Properties makeRbcFromRegular(CtmCalendar cal) {
        Properties rbc = new Properties();
        rbc.setProperty("NAME", cal.getName());
        rbc.put("DAYS_AND_OR", "O");
        rbc.setProperty("DAYSCAL", cal.getName());
        return rbc;
    }

    static {
        MONTH_MAP.put("JAN", 1);
        MONTH_MAP.put("FEB", 2);
        MONTH_MAP.put("MAR", 3);
        MONTH_MAP.put("APR", 4);
        MONTH_MAP.put("MAY", 5);
        MONTH_MAP.put("JUN", 6);
        MONTH_MAP.put("JUL", 7);
        MONTH_MAP.put("AUG", 8);
        MONTH_MAP.put("SEP", 9);
        MONTH_MAP.put("OCT", 10);
        MONTH_MAP.put("NOV", 11);
        MONTH_MAP.put("DEC", 12);
    }
}

