/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependecyFinder {
    private final DataObject dataobject;
    private final String value;
    private final int entityId;
    private String jobAName;
    private String relationType;
    private String jobBName;

    public String getJobAName() {
        return this.jobAName;
    }

    public String getJobBName() {
        return this.jobBName;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public DependecyFinder(DataObject dataobject, int entityId, String arValue) {
        this.dataobject = dataobject;
        this.entityId = entityId;
        this.value = arValue;
        this.parseArValue();
    }

    private void parseArValue() {
        String pattern = "\\(f=(.*?),\\s*t=(.*?),(.*?)\\)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.value);
        m.find();
        try {
            this.jobAName = m.group(1).trim();
            this.jobBName = m.group(2).trim();
            this.relationType = m.group(3).trim();
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public Integer getJobAId() {
        List childrenIds = this.dataobject.getChildrenIds(this.entityId, "UNIT_NAME", this.jobAName);
        if (childrenIds == null || childrenIds.isEmpty()) {
            ConversionLogger.getLogger().info(() -> "No job by name: " + this.jobAName + " found in the data.");
            return null;
        }
        return (Integer)childrenIds.get(0);
    }

    public Integer getJobBId() {
        List childrenIds = this.dataobject.getChildrenIds(this.entityId, "UNIT_NAME", this.jobBName);
        if (childrenIds == null || childrenIds.isEmpty()) {
            ConversionLogger.getLogger().info(() -> "No job by name: " + this.jobBName + " found in the data.");
            return null;
        }
        return (Integer)childrenIds.get(0);
    }
}

