/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.actions;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.utils.Pair;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StartTimeStAction {
    private static final Pattern ST_PATTERN = Pattern.compile(".*?((?<ruleNumber>\\d+)\\s*?,\\s*)?(?<relativeSign>[+]?)(?<hours>\\d{2}):(?<minutes>\\d{2}).*?");
    private static final String HH = "hours";
    private static final String MM = "minutes";
    private static final String START_TIME_RELATIVE_SIGN = "relativeSign";

    public void act(WorkspaceEntity folder, List<String> stValues, String rawBaseTime) {
        String timeSequence;
        HashSet<String> uniqValues = StartTimeStAction.getUniqueSTValues(stValues);
        TimeFrom baseTime = StartTimeStAction.formatStt(rawBaseTime);
        if (uniqValues.size() == 1) {
            TimeFrom timeFrom = (TimeFrom)this.convertStToTimeFrom(stValues.getFirst(), folder).getValue();
            String absoluteTimeFrom = timeFrom.join(baseTime).toString();
            folder.addAttribute("TIMEFROM", absoluteTimeFrom);
            if (timeFrom.isOverflow()) {
                folder.addMessage("WRN17011", new String[]{folder.getName(), stValues.getFirst(), rawBaseTime, absoluteTimeFrom});
            }
        } else if (!uniqValues.isEmpty() && !(timeSequence = this.convertToSpecificTimes(uniqValues, baseTime, folder)).isEmpty()) {
            folder.addAttributes(GlobalFunctions.attributesCyclicSpecificSequence((String)this.convertToSpecificTimes(uniqValues, baseTime, folder)));
        }
    }

    private static HashSet<String> getUniqueSTValues(List<String> stValues) {
        Function<String, String> removeIndex = st -> {
            Matcher stMatcher = ST_PATTERN.matcher((CharSequence)st);
            if (stMatcher.find()) {
                String hour = stMatcher.group(HH);
                String minutes = stMatcher.group(MM);
                String sign = stMatcher.group(START_TIME_RELATIVE_SIGN);
                return sign + hour + ":" + minutes;
            }
            return st;
        };
        Collection distinctStValuesWithoutIndex = stValues.stream().collect(Collectors.toMap(removeIndex, Function.identity(), (l, r) -> l)).values();
        return new HashSet<String>(distinctStValuesWithoutIndex);
    }

    private String convertToSpecificTimes(Set<String> stValues, TimeFrom baseTime, WorkspaceEntity entity) {
        return stValues.stream().map(st -> this.convertStToTimeFrom((String)st, entity)).sorted(Comparator.comparing(Pair::getKey)).map(Pair::getValue).map(st -> st.join(baseTime)).map(TimeFrom::toString).filter(x -> !x.isBlank()).collect(Collectors.joining(","));
    }

    private Pair<Integer, TimeFrom> convertStToTimeFrom(String stString, WorkspaceEntity entity) {
        Matcher stMatcher = ST_PATTERN.matcher(stString);
        if (stMatcher.find()) {
            String hour = stMatcher.group(HH);
            String minutes = stMatcher.group(MM);
            Optional<String> ruleNumber = Optional.ofNullable(stMatcher.group("ruleNumber"));
            String sign = stMatcher.group(START_TIME_RELATIVE_SIGN);
            if (Integer.parseInt(hour) > 23) {
                entity.addMessage("WRN17012", new String[]{stString});
            } else if (ruleNumber.isPresent()) {
                return Pair.of((Object)Integer.parseInt(ruleNumber.get()), (Object)new TimeFrom(hour, minutes, sign));
            }
        }
        return Pair.of((Object)0, (Object)TimeFrom.empty);
    }

    public static TimeFrom formatStt(String sttValueString) {
        Matcher stMatcher = ST_PATTERN.matcher(sttValueString);
        if (stMatcher.find()) {
            String hour = stMatcher.group(HH);
            String minutes = stMatcher.group(MM);
            String relativeSign = stMatcher.group(START_TIME_RELATIVE_SIGN);
            return new TimeFrom(hour, minutes, relativeSign);
        }
        return TimeFrom.empty;
    }

    public static class TimeFrom {
        public static final TimeFrom empty = new EmptyTimeFrom();
        private final String hour;
        private final String minute;
        private final boolean hasSign;
        private boolean isOverflow = false;

        public TimeFrom(String hour, String minute, String sign) {
            this.hour = hour;
            this.minute = minute;
            this.hasSign = TimeFrom.isHasSign(sign);
        }

        private static boolean isHasSign(String sign) {
            return Optional.ofNullable(sign).filter(s -> s.equals("+")).isPresent();
        }

        public TimeFrom(String hour, String minute) {
            this(hour, minute, null);
        }

        public String toString() {
            return this.hour + this.minute;
        }

        public int getHour() {
            return GlobalFunctions.isNumber((String)this.hour) ? Integer.parseInt(this.hour) : 0;
        }

        public int getMinute() {
            return GlobalFunctions.isNumber((String)this.minute) ? Integer.parseInt(this.minute) : 0;
        }

        public boolean hasSign() {
            return this.hasSign;
        }

        public boolean isEmpty() {
            return this == empty;
        }

        public TimeFrom join(TimeFrom that) {
            if (!this.hasSign || that.isEmpty() || this.isEmpty()) {
                return this;
            }
            Duration thisTime = Duration.ofHours(this.getHour()).plus(Duration.ofMinutes(this.getMinute()));
            Duration thatTime = Duration.ofHours(that.getHour()).plus(Duration.ofMinutes(that.getMinute()));
            Duration totalTime = thisTime.plus(thatTime);
            String totalHours = String.format("%02d", totalTime.toHoursPart());
            String totalMinutes = String.format("%02d", totalTime.toMinutesPart());
            if (totalTime.toDaysPart() > 0L) {
                this.isOverflow = true;
            }
            return new TimeFrom(totalHours, totalMinutes);
        }

        public boolean isOverflow() {
            return this.isOverflow;
        }

        private static class EmptyTimeFrom
        extends TimeFrom {
            public EmptyTimeFrom() {
                super("", "");
            }

            @Override
            public TimeFrom join(TimeFrom that) {
                return this;
            }
        }
    }
}

