/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.actions;

import com.bmc.ctmconvert.JP1GlobalFunctions;
import com.bmc.ctmconvert.JP1Globals;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.actions.Action;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ScriptScAction
implements Action {
    private DataObject dataObject;
    private int id;
    private WorkspaceEntity job;

    public ScriptScAction(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    @Override
    public void act(int id, WorkspaceEntity job) {
        this.id = id;
        this.job = job;
        List attributes = this.dataObject.getAttributes(Integer.valueOf(this.id));
        for (Pair pair : attributes) {
            if (!((String)pair.getKey()).equals("sc")) continue;
            this.messageIfContainsJP1Command((String)pair.getValue());
            String value = JP1GlobalFunctions.replaceAllHashSign((String)pair.getValue());
            value = this.stripAllDoubleQuotes(value);
            Path path = Paths.get(value, new String[0]);
            this.setScriptAttr(attributes, path);
            break;
        }
    }

    private String stripAllDoubleQuotes(String value) {
        return value.replace("\"", "");
    }

    private void messageIfCommandIsToLong(String value) {
        if (!FieldValidation.instance().validate("CMDLINE", value).booleanValue()) {
            this.job.addMessage("WRN1005", new String[]{this.job.getName(), Integer.toString(value.length()), Integer.toString(512)});
        }
    }

    private void setScriptAttr(List<Pair<String, String>> attributes, Path path) {
        String memLib = this.returnEmptyIfNull(path.getParent());
        if (memLib == null || memLib.isEmpty()) {
            for (Pair<String, String> pair : attributes) {
                if (!((String)pair.getKey()).equalsIgnoreCase("wkp")) continue;
                memLib = (String)pair.getValue();
                break;
            }
        }
        if (memLib == null || memLib.isEmpty()) {
            this.job.addAttribute("TASKTYPE", "Command");
            String command = this.returnEmptyIfNull(path.getFileName());
            command = this.addParamsToCommand(command);
            command = JP1GlobalFunctions.replaceAllHashSign(command);
            this.messageIfCommandIsToLong(command);
            this.job.addAttribute("CMDLINE", command);
        } else {
            this.job.addAttribute("TASKTYPE", "Job");
            FieldValidation.instance().validateAndReportMessages("MEMLIB", memLib, this.job);
            this.job.addAttribute("MEMLIB", memLib);
            String memName = this.returnEmptyIfNull(path.getFileName());
            FieldValidation.instance().validateAndReportMessages("MEMNAME", memName, this.job);
            this.job.addAttribute("MEMNAME", memName);
        }
    }

    private String addParamsToCommand(String command) {
        Set autoEditKey = this.job.getAutoEditsList().keySet();
        for (String key : autoEditKey) {
            command = (String)command + " " + key;
        }
        return command;
    }

    public String returnEmptyIfNull(Path param) {
        return Optional.ofNullable(param).map(Path::toString).orElse("");
    }

    private void messageIfContainsJP1Command(String value) {
        for (String JP1Command : JP1Globals.listOfJP1Commands) {
            if (!value.trim().contains(JP1Command.trim())) continue;
            this.job.addMessage("WRN17001", new String[]{this.job.getName(), value});
            break;
        }
    }
}

