/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.actions;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.file_watcher.FileWatcherWrapper;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.actions.Action;
import com.bmc.ctmconvert.utils.Pair;
import java.util.List;
import java.util.Optional;

public class FileWatcherFlwjAction
implements Action {
    public static final String FILE_WATCHER_FILE_PATH = "flwf";
    public static final String FILE_WATCHER_INTERVAL_IN_SECONDS = "flwi";
    public static final String FILE_WATCHER_TYPE = "flwc";
    private final DataObject dataObject;
    private final SchedEntity entity;
    private List<Pair<String, String>> jp1Attributes;
    FileWatcherWrapper wrapper;

    public FileWatcherFlwjAction(DataObject dataObject, WorkspaceEntity job) {
        this.dataObject = dataObject;
        this.entity = new JobAdapterToSchedEntity(job);
        this.wrapper = new FileWatcherWrapper(this.entity);
    }

    @Override
    public void act(int id, WorkspaceEntity job) {
        this.jp1Attributes = this.dataObject.getAttributes(Integer.valueOf(id));
        this.entity.addAttribute("TASKTYPE", "Job");
        this.wrapper.convert().setPath(this.getPath());
        this.getType().ifPresent(arg_0 -> ((FileWatcherWrapper)this.wrapper).setType(arg_0));
        this.getIntervalInSeconds().ifPresent(arg_0 -> ((FileWatcherWrapper)this.wrapper).setSearchInterval(arg_0));
    }

    private Optional<Integer> getIntervalInSeconds() {
        Optional<String> interval = this.getAttribute(FILE_WATCHER_INTERVAL_IN_SECONDS);
        return interval.filter(GlobalFunctions::isNumber).map(Integer::parseInt);
    }

    private String getPath() {
        Optional<String> fileToWatch = this.getAttribute(FILE_WATCHER_FILE_PATH);
        return fileToWatch.orElse("");
    }

    private Optional<String> getAttribute(String attribute) {
        return this.jp1Attributes.stream().filter(it -> ((String)it.getKey()).equals(attribute)).map(Pair::getValue).findFirst();
    }

    private Optional<FileWatcherWrapper.Type> getType() {
        return this.getAttribute(FILE_WATCHER_TYPE).flatMap(type -> {
            String lowerCaseType = type.toLowerCase();
            if (lowerCaseType.contains("c") || lowerCaseType.contains("m")) {
                return Optional.of(FileWatcherWrapper.Type.CREATE);
            }
            if (lowerCaseType.contains("d")) {
                return Optional.of(FileWatcherWrapper.Type.DELETE);
            }
            return Optional.empty();
        });
    }

    private static class JobAdapterToSchedEntity
    extends DefaultSchedEntity {
        private final WorkspaceEntity job;

        private JobAdapterToSchedEntity(WorkspaceEntity job) {
            super(job.getName(), SchedEntity.TYPE.JOB);
            this.job = job;
        }

        public void addAutoEdits(String key, String value) {
            this.job.addAutoEdit(key, value);
        }

        public void addAttribute(String key, String value) {
            this.job.addAttribute(key, value);
        }
    }
}

