/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.actions;

import com.bmc.ctmconvert.JP1GlobalFunctions;
import com.bmc.ctmconvert.JP1Globals;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.actions.Action;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandTeAction
implements Action {
    private final DataObject dataObject;
    private int id;
    private WorkspaceEntity job;

    public CommandTeAction(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    @Override
    public void act(int id, WorkspaceEntity job) {
        this.id = id;
        this.job = job;
        List attributes = this.dataObject.getAttributes(Integer.valueOf(this.id));
        for (Pair pair : attributes) {
            if (!((String)pair.getKey()).equals("te")) continue;
            this.job.addAttribute("TASKTYPE", "Command");
            this.job.addAttribute("CMDLINE", this.manageValue((String)pair.getValue()));
            break;
        }
    }

    public void act(int id, String cmd, WorkspaceEntity job) {
        this.id = id;
        this.job = job;
        this.job.addAttribute("TASKTYPE", "Command");
        this.job.addAttribute("CMDLINE", this.manageValue(cmd));
    }

    private String manageValue(String value) {
        value = this.addParamsToCommand(value);
        for (String JP1Command : JP1Globals.listOfJP1Commands) {
            if (!value.trim().contains(JP1Command.trim())) continue;
            this.job.addMessage("WRN17001", new String[]{this.job.getName(), value});
            break;
        }
        value = JP1GlobalFunctions.replaceAllHashSign(value);
        this.messageIfCommandIsToLong(value);
        return value;
    }

    private String addParamsToCommand(String value) {
        LinkedHashMap autoEditList = this.job.getAutoEditsList();
        Pattern regex = Pattern.compile(".*?(\\$\\d+)");
        Matcher regexMatcher = regex.matcher(value);
        int i = 1;
        while (regexMatcher.find()) {
            if (autoEditList.containsKey("%%PARM" + i) && value.contains("$" + i)) {
                value = value.replace("$" + i, "%%PARM" + i);
            }
            ++i;
        }
        return value;
    }

    private void messageIfCommandIsToLong(String value) {
        if (!FieldValidation.instance().validate("CMDLINE", value).booleanValue()) {
            this.job.addMessage("WRN1005", new String[]{this.job.getName(), Integer.toString(value.length()), Integer.toString(512)});
        }
    }
}

