/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Jp1GeneralSourceDefinitions;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.dataimport.DirectoryImporter;
import com.bmc.ctmconvert.dataimport.DynamicDataImportPanel;
import com.bmc.ctmconvert.dataimport.EntriesImporter;
import com.bmc.ctmconvert.dataimport.FilesImporter;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.dataimport.fileimporter.FIleImporter;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.jp1.assesmentReport.Jp1AssessmentReport;
import com.bmc.ctmconvert.jp1.dataImport.CliImporterJP1;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AppData
implements VendorData {
    public String getName() {
        return "JP1";
    }

    public String getDisplayName() {
        return "JP1 Automatic Job Scheduler";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return new DynamicDataImportPanel((EntriesImporter)new Jp1Importer(this.getImportEntries()), "LOAD_DATA_JP1");
    }

    public CliImporter getCLIImporter() {
        ImportEntryList entries = this.getImportEntries();
        FilesImporter filesImporter = new FilesImporter(entries);
        return new CliImporterJP1(filesImporter);
    }

    public BasePanel getAssessmentReport(String path) {
        return new Jp1AssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, "");
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
        return new Jp1GeneralSourceDefinitions();
    }

    public InputStream getRulesResourceFile() {
        return AppData.class.getResourceAsStream("/rules.xml");
    }

    private static final class Jp1Importer
    extends EntriesImporter {
        public Jp1Importer(ImportEntryList entries) {
            super(entries);
        }

        public Progressable.ProgressStatus performImport() {
            for (ImportEntry importEntry : this.entries) {
                DirectoryImporter importer;
                Path dataDirectory = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
                if (importEntry.getType() == ImporterType.Directory) {
                    importer = new DirectoryImporter(importEntry, dataDirectory);
                    importer.addProgressListener(x$0 -> this.fireProgressEvent(x$0));
                    importer.run();
                    continue;
                }
                if (importEntry.getType() != ImporterType.File) continue;
                importer = new FIleImporter(importEntry, dataDirectory);
                importer.addProgressListener(x$0 -> this.fireProgressEvent(x$0));
                importer.run();
            }
            return this.getStatus();
        }
    }
}

