/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.EntityMapper;
import com.bmc.ctmconvert.InputFilesExtractor;
import com.bmc.ctmconvert.InputStreamNamePair;
import com.bmc.ctmconvert.RuleCompilationTester;
import com.bmc.ctmconvert.SelfConversionDataParser;
import com.bmc.ctmconvert.builderutils.BuilderUtils;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import com.bmc.ctmconvert.common.exceptions.ConversionRuntimeException;
import com.bmc.ctmconvert.exception.ScriptRuleException;
import com.bmc.ctmconvert.getter.CtmEntityMapper;
import com.bmc.ctmconvert.rule.ScriptRule;
import com.bmc.ctmconvert.tester.RuleTesterFactory;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestRuleServlet
extends HttpServlet {
    private static final long serialVersionUID = -4920753140365311977L;
    private JSONObject responseJson;
    private SelfConversionDataParser dataParser;
    private RuleCompilationTester ruleCompilationTester;
    private JSONArray rulesArray = new JSONArray();
    private JSONObject requestJson;
    private InputFilesExtractor inputFilesExtractor;

    public TestRuleServlet() {
        this(new BuilderUtils(FileSystems.getDefault())::parseInputData, new InputFilesExtractor(FileSystems.getDefault()));
    }

    public TestRuleServlet(SelfConversionDataParser dataParser, InputFilesExtractor inputFilesExtractor) {
        this(dataParser, new RuleCompilationTester(), inputFilesExtractor);
    }

    public TestRuleServlet(SelfConversionDataParser dataParser, RuleCompilationTester ruleCompilationTester, InputFilesExtractor inputFilesExtractor) {
        this.dataParser = dataParser;
        this.ruleCompilationTester = ruleCompilationTester;
        this.inputFilesExtractor = inputFilesExtractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.responseJson = new JSONObject();
        try {
            this.responseJson.put("status", (Object)"failure");
            this.requestJson = BuilderUtils.toJson(request);
            this.rulesArray = this.requestJson.getJSONArray("rules");
            this.ruleCompilationTester.testRulesCompilation(this.rulesArray);
            String projectName = this.requestJson.getString("projectName");
            JSONArray inputDataArray = this.inputFilesExtractor.extractFullPath(projectName);
            List<InputStreamNamePair> inputData = this.dataParser.parse(inputDataArray);
            EntityMapper.init();
            Context.setInputData(inputData);
            this.testRule();
            this.responseJson.put("status", (Object)"success");
        }
        catch (JSONException e) {
            this.responseJson.put("reason", (Object)("failed to read rule JSON - " + e.getMessage()));
        }
        catch (ConversionException | ConversionRuntimeException | ScriptRuleException e) {
            this.responseJson.put("reason", (Object)e.getMessage());
        }
        finally {
            Context.reset();
            response.getWriter().println(this.responseJson.toString());
        }
    }

    private void testRule() throws ConversionException, IOException {
        this.rulesArray.forEach(singleRule -> {
            String inputScript = ((JSONObject)singleRule).getJSONObject("rulesData").getString("script");
            ScriptRule scriptRule = new ScriptRule(inputScript, new CtmEntityMapper());
            scriptRule.activate(null);
        });
        try {
            new RuleTesterFactory(this.responseJson, this.requestJson).createTesterFor().test();
        }
        catch (ConversionException e) {
            throw new ConversionRuntimeException(e.getMessage());
        }
    }
}

