/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.InputFilesExtractor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SelfConversionRepositoryManager {
    static final String PROJECT_DIR_NAME = "projects";
    static final String PROJECT_JSON_DATA_FILENAME = "projectData.json";
    private static final String JSON_EXTENSION = ".json";
    final FileSystem fileSystem;
    private static SelfConversionRepositoryManager singleInstance = null;
    static final String PROJECT_NAME_JSON_PROPERTY = "projectName";
    static final String SOURCE_VENDOR_JSON_PROPERTY = "projectSourceVendorName";
    static final String PROJECT_DESCRIPTION_JSON_PROPERTY = "projectDescription";
    public static final String RULES_DIR_NAME = "rules";
    private String projectDirPathPrefixString = Globs.SELF_COVERSION_REPO_DIR + Globs.DIRSEP;
    private final Set<String> uniqueFileName;

    public SelfConversionRepositoryManager() {
        this(FileSystems.getDefault());
    }

    public SelfConversionRepositoryManager(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.uniqueFileName = new HashSet<String>();
    }

    public static SelfConversionRepositoryManager getRepositoryManager() {
        if (singleInstance == null) {
            singleInstance = new SelfConversionRepositoryManager();
        }
        return singleInstance;
    }

    public void createProjectAndSaveToDisk(JSONObject projectDataJsonObject, JSONArray projectDataFilesPathArray) throws ConversionException {
        try {
            String projectName = projectDataJsonObject.getString(PROJECT_NAME_JSON_PROPERTY);
            Path projectDirPath = this.getProjectDirPathWithProjectNameSuffix(projectName);
            this.createDirectoryIfNotExists(projectDirPath);
            this.writeDataFilesToDiskAndGetUpdateDataFilesArray(projectDirPath, projectDataFilesPathArray);
            Path projectDataJsonFilePath = this.getProjectDataJsonFilePath(projectDirPath);
            this.writeJsonObjectToPath(projectDataJsonFilePath, projectDataJsonObject);
        }
        catch (IOException | InvalidPathException | JSONException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new ConversionException("failed to create new project -\r\n" + e.getMessage());
        }
    }

    public void editProject(String originalProjectName, JSONObject newProjectDataJsonObject) throws ConversionException {
        try {
            boolean isProjectNameChanged;
            Path originalProjectDirPath = this.getProjectDirPathWithProjectNameSuffix(originalProjectName);
            String newProjectName = newProjectDataJsonObject.getString(PROJECT_NAME_JSON_PROPERTY);
            Path newProjectDirPath = this.getProjectDirPathWithProjectNameSuffix(newProjectName);
            boolean bl = isProjectNameChanged = !originalProjectName.equals(newProjectName);
            if (isProjectNameChanged) {
                InputFilesExtractor inputExtractor = new InputFilesExtractor(this.fileSystem);
                JSONArray projectDataFilesPathArray = inputExtractor.extractFullPath(originalProjectName);
                JSONArray newProjectDataFilesPathArray = new JSONArray();
                projectDataFilesPathArray.forEach(arrayItem -> {
                    String pathString = arrayItem.toString();
                    pathString = pathString.replace(originalProjectDirPath.toString(), newProjectDirPath.toString());
                    newProjectDataFilesPathArray.put((Object)pathString);
                });
                Files.move(originalProjectDirPath, newProjectDirPath, StandardCopyOption.REPLACE_EXISTING);
            }
            Path projectDataJsonFilePath = this.getProjectDataJsonFilePath(newProjectDirPath);
            this.writeJsonObjectToPath(projectDataJsonFilePath, newProjectDataJsonObject);
        }
        catch (IOException | JSONException e) {
            ExceptionHandler.writeToExceptionFile((String)("failed to edit project - \r\n" + String.valueOf(e)));
            throw new ConversionException("failed to edit project - " + e.getMessage());
        }
    }

    public void updateProject(JSONObject updatedProjectDataJsonObject) throws IOException {
        String projectName = updatedProjectDataJsonObject.getString(PROJECT_NAME_JSON_PROPERTY);
        Path projectDirPath = this.getProjectDirPathWithProjectNameSuffix(projectName);
        Path projectDataJsonFilePath = this.getProjectDataJsonFilePath(projectDirPath);
        this.writeJsonObjectToPath(projectDataJsonFilePath, updatedProjectDataJsonObject);
    }

    public void writeDataFilesToDiskAndGetUpdateDataFilesArray(Path projectDirPath, JSONArray projectDataFilesPathArray) throws IOException, ConversionException {
        final JSONArray newDataFilesJsonArray = new JSONArray();
        final Path projectDataDirPath = this.fileSystem.getPath(projectDirPath.toString() + Globs.DIRSEP + "data", new String[0]);
        this.createDirectoryIfNotExists(projectDataDirPath);
        for (Object filePath : projectDataFilesPathArray) {
            Path filePathObject;
            String filePathString = filePath.toString();
            if (this.isRelativePath(filePathString)) {
                filePathString = this.replaceRelativePathWithFullPath(filePathString);
            }
            if (Files.isDirectory(filePathObject = this.fileSystem.getPath(filePathString, new String[0]), new LinkOption[0])) {
                Files.walkFileTree(filePathObject, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path sourceDataFilePath, BasicFileAttributes attrs) throws IOException {
                        if (SelfConversionRepositoryManager.this.hasXmlExtension(sourceDataFilePath)) {
                            Path targetDataFilePath = SelfConversionRepositoryManager.this.getDataFileCopyTargetPath(projectDataDirPath, sourceDataFilePath);
                            Files.copy(sourceDataFilePath, targetDataFilePath, StandardCopyOption.REPLACE_EXISTING);
                            newDataFilesJsonArray.put((Object)targetDataFilePath.toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            this.copySingleFile(newDataFilesJsonArray, projectDataDirPath, filePathString);
        }
    }

    private void copySingleFile(JSONArray newDataFilesJsonArray, Path projectDataDirPath, String filePathString) throws IOException {
        Path sourceDataFilePath = this.fileSystem.getPath(filePathString, new String[0]);
        Path targetDataFilePath = this.getDataFileCopyTargetPath(projectDataDirPath, sourceDataFilePath);
        Files.copy(sourceDataFilePath, targetDataFilePath, StandardCopyOption.REPLACE_EXISTING);
        newDataFilesJsonArray.put((Object)targetDataFilePath.toString());
    }

    private String replaceRelativePathWithFullPath(String filePathString) {
        int projectStringLocation = filePathString.indexOf(PROJECT_DIR_NAME);
        String rest = filePathString.substring(projectStringLocation + PROJECT_DIR_NAME.length());
        String replacement = this.getHomePathWithSuffix(PROJECT_DIR_NAME).toString();
        return replacement + rest;
    }

    private boolean isRelativePath(String filePathString) {
        return filePathString.startsWith("..");
    }

    private boolean hasXmlExtension(Path sourceDataFilePath) {
        Path fileName = sourceDataFilePath.getFileName();
        if (fileName != null) {
            return fileName.toString().toLowerCase().endsWith(".xml");
        }
        return false;
    }

    public Path getDataFileCopyTargetPath(Path projectDataDirPath, Path filePathString) {
        Predicate<String> isUniqueName = this.uniqueFileName::add;
        if (isUniqueName.test(filePathString.getFileName().toString())) {
            return projectDataDirPath.resolve(filePathString.getFileName());
        }
        String parentName = filePathString.getParent().getFileName().toString();
        String uniqueName = parentName + "_" + filePathString.getFileName().toString();
        return projectDataDirPath.resolve(uniqueName);
    }

    public void writeJsonObjectToPath(Path projectDataJsonFilePath, JSONObject projectDataJsonObject) throws IOException {
        projectDataJsonObject.remove("conversionResult");
        String json = this.jsonPrettyFormat(projectDataJsonObject);
        try (BufferedWriter writer = Files.newBufferedWriter(projectDataJsonFilePath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            writer.write(json);
        }
    }

    public void setProjectDirPathPrefixString(String projectDirPathPrefixString) {
        this.projectDirPathPrefixString = projectDirPathPrefixString;
    }

    Path getHomePathWithSuffix(String suffixToAppend) {
        String projectDirPathString = this.projectDirPathPrefixString + suffixToAppend;
        return this.fileSystem.getPath(projectDirPathString, new String[0]);
    }

    public Path getProjectDirPathWithProjectNameSuffix(String suffixToAppend) {
        Path homePathWithProjectsSuffix = this.getHomePathWithSuffix(PROJECT_DIR_NAME);
        return homePathWithProjectsSuffix.resolve(suffixToAppend);
    }

    public void createDirectoryIfNotExists(Path dirPath) throws IOException {
        boolean isProjectDirExists = Files.exists(dirPath, new LinkOption[0]);
        if (!isProjectDirExists) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
    }

    public Path getProjectDataJsonFilePath(Path projectDirPath) {
        return this.fileSystem.getPath(projectDirPath.toString() + Globs.DIRSEP + PROJECT_JSON_DATA_FILENAME, new String[0]);
    }

    public JSONObject readProjecData(Path projectDataJsonFilePath) throws IOException {
        try (Stream<String> lines = Files.lines(projectDataJsonFilePath);){
            String projectData = lines.collect(Collectors.joining());
            JSONObject jSONObject = new JSONObject(projectData);
            return jSONObject;
        }
    }

    public JSONArray getProjects() throws IOException {
        JSONArray projectsJsonArray = new JSONArray();
        Path projectsDir = this.fileSystem.getPath(Globs.SELF_COVERSION_REPO_DIR + Globs.DIRSEP + PROJECT_DIR_NAME, new String[0]);
        if (this.isDirectoryExists(projectsDir)) {
            try (Stream<Path> projectList = Files.list(projectsDir);){
                projectList.forEach(projectDirPath -> {
                    Path projectDataJsonFilePath;
                    if (Files.isDirectory(projectDirPath, new LinkOption[0]) && Files.exists(projectDataJsonFilePath = this.getProjectDataJsonFilePath((Path)projectDirPath), new LinkOption[0])) {
                        try {
                            projectsJsonArray.put((Object)this.readProjecData(projectDataJsonFilePath));
                        }
                        catch (IOException e) {
                            ExceptionHandler.writeToExceptionFile((Exception)e);
                        }
                    }
                });
            }
        }
        return projectsJsonArray;
    }

    public JSONObject getProjectByName(String projectName) throws IOException {
        JSONArray projects = this.getProjects();
        JSONObject ret = null;
        for (int i = 0; i < projects.length(); ++i) {
            JSONObject project = projects.getJSONObject(i);
            if (!project.get(PROJECT_NAME_JSON_PROPERTY).equals(projectName)) continue;
            ret = project;
        }
        return ret;
    }

    public void saveRule(JSONObject requestAsJsonObject) throws ConversionException {
        try {
            String rulesetName = this.getRulesetNameFromJsonObject(requestAsJsonObject);
            Path homePathWithRulesSuffix = this.getHomePathWithSuffix(RULES_DIR_NAME);
            this.createDirectoryIfNotExists(homePathWithRulesSuffix);
            this.writeJsonObjectToPath(homePathWithRulesSuffix.resolve(rulesetName + JSON_EXTENSION), requestAsJsonObject);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((String)("failed to save rules file - \r\n" + String.valueOf(e)));
            throw new ConversionException("failed to save rules file - " + e.getMessage());
        }
    }

    public String jsonPrettyFormat(JSONObject requestAsJsonObject) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object json = mapper.readValue(requestAsJsonObject.toString(), Object.class);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
    }

    private String getRulesetNameFromJsonObject(JSONObject requestAsJsonObject) {
        return requestAsJsonObject.getString("projectRuleSetName");
    }

    public JSONArray getRules() throws IOException {
        JSONArray rulesJsonArray = new JSONArray();
        Path rulesDir = this.fileSystem.getPath(Globs.SELF_COVERSION_REPO_DIR + Globs.DIRSEP + RULES_DIR_NAME, new String[0]);
        if (this.isDirectoryExists(rulesDir)) {
            try (Stream<Path> ruleslist = Files.list(rulesDir);){
                ruleslist.forEach(ruleFilePath -> {
                    if (!Files.isDirectory(ruleFilePath, new LinkOption[0]) && Files.exists(ruleFilePath, new LinkOption[0])) {
                        try {
                            rulesJsonArray.put((Object)this.readRuleData((Path)ruleFilePath));
                        }
                        catch (IOException e) {
                            ExceptionHandler.writeToExceptionFile((Exception)e);
                        }
                    }
                });
            }
        }
        return rulesJsonArray;
    }

    private boolean isDirectoryExists(Path rulesDir) {
        return Files.exists(rulesDir, new LinkOption[0]) && Files.isDirectory(rulesDir, new LinkOption[0]);
    }

    public JSONObject readRuleData(Path ruleDataJsonFilePath) throws IOException {
        String projectData = new String(Files.readAllBytes(ruleDataJsonFilePath));
        return new JSONObject(projectData);
    }

    public void deleteProjectByName(String projectNameJsonObject) throws ConversionException {
        try {
            Path projectsDir = this.getProjectDirPathWithProjectNameSuffix(projectNameJsonObject);
            GlobalFunctions.deleteDirectory((Path)projectsDir);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((String)("Fail to delete project - \r\n" + String.valueOf(e)));
            throw new ConversionException("Fail to delete project - " + e.getMessage());
        }
        catch (InvalidPathException e) {
            ExceptionHandler.writeToExceptionFile((String)("Unecpected Error - \r\n" + String.valueOf(e)));
            throw new ConversionException("Unecpected Error - " + e.getMessage());
        }
    }

    public void deleteRuleByName(String ruleName) throws ConversionException {
        try {
            Path homePathWithRulesSuffix = this.getHomePathWithSuffix(RULES_DIR_NAME).resolve(ruleName + JSON_EXTENSION);
            Files.delete(homePathWithRulesSuffix);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((String)("Fail to delete rule - \r\n" + String.valueOf(e)));
            throw new ConversionException("Fail to delete rule - " + e.getMessage());
        }
        catch (InvalidPathException e) {
            ExceptionHandler.writeToExceptionFile((String)("Unexpected Error - \r\n" + String.valueOf(e)));
            throw new ConversionException("Unexpected Error - " + e.getMessage());
        }
    }

    public void revertProjectFileStructure(String projectName) throws ConversionException {
        try {
            Path projectDirPath = this.getProjectDirPathWithProjectNameSuffix(projectName);
            GlobalFunctions.deleteDirectory((Path)projectDirPath);
        }
        catch (IOException | InvalidPathException e) {
            throw new ConversionException("failed to revert project creation of project - " + projectName + "\r\n" + e.getMessage());
        }
    }

    public void exportRuleByName(String ruleName, String exportPath) throws ConversionException {
        try {
            Path homePathWithRulesSuffix = this.getHomePathWithSuffix(RULES_DIR_NAME).resolve(ruleName + JSON_EXTENSION);
            Path exportPath1 = this.fileSystem.getPath(exportPath, new String[0]);
            Files.copy(homePathWithRulesSuffix, exportPath1, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((String)("Fail to export File - \r\n" + String.valueOf(e)));
            throw new ConversionException("Fail to export File - " + e.getMessage());
        }
        catch (InvalidPathException e) {
            ExceptionHandler.writeToExceptionFile((String)("Unexpected Error - \r\n" + String.valueOf(e)));
            throw new ConversionException("Unexpected Error - " + e.getMessage());
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void addFileToProject(String originalProjectName, JSONArray filesList, JSONObject responseJsonObject) throws IOException, ConversionException {
        Path projectPath = this.getProjectDirPathWithProjectNameSuffix(originalProjectName);
        Path projectDataPath = this.fileSystem.getPath(projectPath.toString() + Globs.DIRSEP + "data", new String[0]);
        ArrayList<String> validateFiles = new ArrayList<String>();
        ArrayList<String> nonValidateFiles = new ArrayList<String>();
        for (Object file : filesList) {
            String fileName = file.toString();
            Path newFilePath = this.fileSystem.getPath(fileName, new String[0]);
            if (this.isValidXml(newFilePath)) {
                Path targetDataFilePath = this.getDataFileCopyTargetPath(projectDataPath, newFilePath);
                Files.copy(newFilePath, targetDataFilePath, StandardCopyOption.REPLACE_EXISTING);
                validateFiles.add(fileName);
                continue;
            }
            nonValidateFiles.add(fileName);
        }
        this.writeToResponseJsonObject(validateFiles, nonValidateFiles, responseJsonObject);
    }

    private void writeToResponseJsonObject(List<String> validateFiles, List<String> nonValidateFiles, JSONObject responseJsonObject) throws ConversionException {
        responseJsonObject.put("validFiles", (Object)validateFiles.toArray());
        responseJsonObject.put("nonValidFiles", (Object)nonValidateFiles.toArray());
        if (!nonValidateFiles.isEmpty()) {
            throw new ConversionException("file format is not valid");
        }
    }

    private boolean isValidXml(Path filePath) {
        try (InputStream filePathStream = Files.newInputStream(filePath, new OpenOption[0]);){
            XmlLoader.from((InputStream)filePathStream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

