/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.InputStreamNamePair;
import com.bmc.ctmconvert.rule.RulesProvider;
import com.bmc.ctmconvert.rule.XmlRulesProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class RequestParser {
    private static final String XML_EXTENTION_REGEX = "regex:(?i).+\\.xml";
    private RulesProvider rulesProvider;
    private List<InputStreamNamePair> inputData = new ArrayList<InputStreamNamePair>();
    public final Predicate<? super Path> xmlFilenamePredicate = path -> {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(XML_EXTENTION_REGEX);
        return matcher.matches((Path)path);
    };
    private final FileSystem fs;

    public RequestParser(HttpServletRequest request) {
        this(request, FileSystems.getDefault());
    }

    public RequestParser(HttpServletRequest request, FileSystem fs) {
        this.fs = fs;
        this.parseRequest(request);
    }

    private void parseRequest(HttpServletRequest request) {
        try {
            ServletInputStream inputStream = request.getInputStream();
            ObjectMapper mapper = new ObjectMapper();
            RequestMessage content = (RequestMessage)mapper.readValue((InputStream)inputStream, RequestMessage.class);
            String ruleFile = content.getRuleFile();
            this.rulesProvider = this.createXmlRulesProvider(ruleFile);
            String inputDataPath = content.getDataPath();
            String inputDataFile = content.getDataFile();
            if (inputDataFile != null && !inputDataFile.isEmpty()) {
                this.inputData = this.getStreamFromString(inputDataFile);
            } else {
                this.inputData.addAll(this.getStreamsFromPath(inputDataPath));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<InputStreamNamePair> getStreamsFromPath(String inputDataPath) throws IOException {
        ArrayList<InputStreamNamePair> result = new ArrayList<InputStreamNamePair>();
        if (inputDataPath == null || inputDataPath.isEmpty()) {
            return result;
        }
        Path givenPath = this.fs.getPath(inputDataPath, new String[0]);
        if (Files.isDirectory(givenPath, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(givenPath);){
                paths.filter(this.xmlFilenamePredicate).forEach(path -> {
                    InputStream dataInputStream;
                    try {
                        dataInputStream = this.handleSingleFile((Path)path);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    result.add(new InputStreamNamePair(path.getFileName().toString(), dataInputStream));
                });
                return result;
            }
        } else {
            InputStream dataInputStream = null;
            if (!Files.exists(givenPath, new LinkOption[0])) throw new FileNotFoundException("File " + givenPath.toString() + " does not exist");
            if (!this.xmlFilenamePredicate.test(givenPath)) throw new IllegalArgumentException(givenPath.toString() + " is not a valid XML file with XML extension");
            dataInputStream = this.handleSingleFile(givenPath);
            result.add(new InputStreamNamePair(givenPath.getFileName().toString(), dataInputStream));
        }
        return result;
    }

    private InputStream handleSingleFile(Path givenPath) throws IOException {
        return new ByteArrayInputStream(Files.readAllBytes(givenPath));
    }

    public List<InputStreamNamePair> getInputData() {
        return this.inputData;
    }

    public RulesProvider getRulesProvider() {
        return this.rulesProvider;
    }

    protected List<InputStreamNamePair> getStreamFromString(String dataFile) {
        ArrayList<InputStreamNamePair> inputData = new ArrayList<InputStreamNamePair>();
        inputData.add(new InputStreamNamePair("name", new ByteArrayInputStream(dataFile.getBytes(StandardCharsets.UTF_8))));
        return inputData;
    }

    protected XmlRulesProvider createXmlRulesProvider(String ruleFile) {
        ByteArrayInputStream ruleStream = new ByteArrayInputStream(ruleFile.getBytes(StandardCharsets.UTF_8));
        return new XmlRulesProvider(ruleStream);
    }

    public static class RequestMessage {
        private String ruleFile;
        private String dataFile;
        private String dataPath;

        public String getRuleFile() {
            return this.ruleFile;
        }

        public void setRuleFile(String ruleFile) {
            this.ruleFile = ruleFile;
        }

        public String getDataPath() {
            return this.dataPath;
        }

        public void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public String getDataFile() {
            return this.dataFile;
        }

        public void setDataFile(String dataFile) {
            this.dataFile = dataFile;
        }
    }
}

