/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.InputFilesExtractor;
import com.bmc.ctmconvert.SelfConversionRepositoryManager;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProjectDuplicator {
    public FileSystem fileSystem;
    public String projectDirPathPrefixString;
    final SelfConversionRepositoryManager selfConversionRepositoryManager;

    public ProjectDuplicator(FileSystem fileSystem, SelfConversionRepositoryManager selfConversionRepositoryManager) {
        this.selfConversionRepositoryManager = selfConversionRepositoryManager;
        this.fileSystem = fileSystem;
    }

    public void duplicateProject(JSONObject requestObject) throws ConversionException {
        String sourceProjectName = requestObject.getString("sourceProjectName");
        String targetProjectName = requestObject.getString("targetProjectName");
        try {
            Path targetProjectDirPath = this.selfConversionRepositoryManager.getProjectDirPathWithProjectNameSuffix(targetProjectName);
            this.selfConversionRepositoryManager.createDirectoryIfNotExists(targetProjectDirPath);
            InputFilesExtractor inputFilesExtractor = new InputFilesExtractor(this.fileSystem);
            JSONArray iputDataArray = inputFilesExtractor.extractFullPath(sourceProjectName);
            this.selfConversionRepositoryManager.writeDataFilesToDiskAndGetUpdateDataFilesArray(targetProjectDirPath, iputDataArray);
            JSONObject targetProjectDataJson = this.updateProjectDataJsonFile(requestObject, targetProjectName, sourceProjectName);
            Path targetProjectDataJsonFilePath = this.selfConversionRepositoryManager.getProjectDataJsonFilePath(targetProjectDirPath);
            this.selfConversionRepositoryManager.writeJsonObjectToPath(targetProjectDataJsonFilePath, targetProjectDataJson);
        }
        catch (IOException e) {
            throw new ConversionException("failed to duplicate project -\r\n" + e.getMessage());
        }
    }

    JSONObject updateProjectDataJsonFile(JSONObject requestObject, String targetProjectName, String sourceProjectName) throws IOException {
        Path sourceProjectDirPath = this.selfConversionRepositoryManager.getProjectDirPathWithProjectNameSuffix(sourceProjectName);
        Path sourceProjectDataJsonFilePath = this.selfConversionRepositoryManager.getProjectDataJsonFilePath(sourceProjectDirPath);
        String projectData = new String(Files.readAllBytes(sourceProjectDataJsonFilePath));
        JSONObject projectDataJson = new JSONObject(projectData);
        projectDataJson.put("projectName", (Object)targetProjectName);
        projectDataJson.put("projectDescription", (Object)requestObject.getString("projectDescription"));
        projectDataJson.put("projectSourceVendorName", (Object)requestObject.getString("convertedFrom"));
        String date = requestObject.getString("projectDateCreated");
        projectDataJson.put("projectDateModified", (Object)date);
        projectDataJson.put("projectDateCreated", (Object)date);
        return projectDataJson;
    }
}

