/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImportRulesServlet
extends HttpServlet {
    private static final String GIT_HUB_URL = "https://github.com/controlm/self-conversion-api-community-solutions";

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        JSONObject responseJsonObject = new JSONObject();
        try {
            JSONArray rules = this.getRulesFromGitHub();
            responseJsonObject.put("rules", (Object)rules);
            responseJsonObject.put("status", (Object)"success");
            response.getWriter().println(responseJsonObject);
        }
        catch (Exception e) {
            responseJsonObject.put("status", (Object)"failure");
            response.getWriter().print("FATAL ERROR - " + String.valueOf(e));
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getRulesFromGitHub() throws GitAPIException, IOException {
        File gitDirectory = new File("GitHub-Repository");
        if (gitDirectory.exists()) {
            this.deleteDirectory(gitDirectory);
        }
        JSONArray rulesList = new JSONArray();
        try (Git ignore = this.cloneFromGitHub(gitDirectory);){
            List<Path> rules = this.getRulesFromGitDirectory(gitDirectory);
            for (Path rule : rules) {
                rulesList.put((Object)this.readRuleData(rule));
            }
        }
        finally {
            this.deleteDirectory(gitDirectory);
        }
        return rulesList;
    }

    private List<Path> getRulesFromGitDirectory(File gitDirectory) throws IOException {
        try (Stream<Path> rules = Files.find(gitDirectory.toPath(), 10, (f, attrs) -> this.isRule(f.toFile()), new FileVisitOption[0]);){
            List<Path> list = rules.collect(Collectors.toList());
            return list;
        }
    }

    private boolean isRule(File file) {
        String pattern = ".*(ConversionRules.json)$";
        String fileName = file.toString();
        Matcher matcher = Pattern.compile(pattern).matcher(fileName);
        return matcher.find();
    }

    private Git cloneFromGitHub(File gitDirectory) throws GitAPIException {
        return Git.cloneRepository().setURI(GIT_HUB_URL).setDirectory(gitDirectory).call();
    }

    private void deleteDirectory(File outPut) {
        GlobalFunctions.deleteDir((File)outPut);
    }

    private JSONObject readRuleData(Path ruleDataJsonFilePath) throws IOException {
        String projectData = new String(Files.readAllBytes(ruleDataJsonFilePath));
        return new JSONObject(projectData);
    }
}

