/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.Globs;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetSuppliedRulesListServlet
extends HttpServlet {
    public static final String CONVERION_RULES_FILES = "ConverionRulesFiles";
    public static final String SELF_CONVERSION = "SelfConversion";
    public static final String JSON_RULE_FILE_NAME = "name";
    private static final long serialVersionUID = 6305731597421785719L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Path pathRulesDir = this.getHomeDir().resolve(SELF_CONVERSION).resolve(CONVERION_RULES_FILES);
        Predicate<Path> xmlPredicate = file -> {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return false;
            }
            String fileName = file.getFileName().toString();
            boolean endsWithXml = fileName.toUpperCase().endsWith(".XML");
            return endsWithXml;
        };
        try (Stream<Path> paths = Files.list(pathRulesDir);){
            List rulesPaths = paths.filter(xmlPredicate).collect(Collectors.toList());
            Rules rules = new Rules();
            for (Path file2 : rulesPaths) {
                RuleJson ruleJson = this.getRulejson(file2);
                rules.addRule(ruleJson);
            }
            ObjectMapper mapper = new ObjectMapper();
            String jsonContent = mapper.writeValueAsString((Object)rules);
            response.setContentType("application/json");
            response.setStatus(200);
            PrintWriter writer = response.getWriter();
            writer.println(jsonContent);
        }
    }

    private RuleJson getRulejson(Path file) {
        RuleJson ruleJson = new RuleJson();
        String fileName = file.getFileName().toString();
        ruleJson.setName(fileName);
        String string = this.getRuleContent(file);
        ruleJson.setRuleContent(string);
        return ruleJson;
    }

    private String getRuleContent(Path file) {
        StringBuilder stringBuilder = new StringBuilder();
        try (Stream<String> ruleContent = Files.lines(file);){
            String ls = System.getProperty("line.separator");
            ruleContent.forEach(line -> {
                stringBuilder.append((String)line);
                stringBuilder.append(ls);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }

    protected Path getHomeDir() {
        return Paths.get(Globs.HOME_DIR, new String[0]);
    }

    public static class Rules {
        private List<RuleJson> suppliedRulesList = new ArrayList<RuleJson>();

        public List<RuleJson> getSuppliedRulesList() {
            return this.suppliedRulesList;
        }

        public void setSuppliedRulesList(List<RuleJson> suppliedRulesList) {
            this.suppliedRulesList = suppliedRulesList;
        }

        public void addRule(RuleJson ruleJson) {
            this.suppliedRulesList.add(ruleJson);
        }
    }

    public static class RuleJson {
        private String name;
        private String ruleContent;

        public String getRuleContent() {
            return this.ruleContent;
        }

        public void setRuleContent(String ruleContent) {
            this.ruleContent = ruleContent;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

