/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.InputFilesExtractor;
import com.bmc.ctmconvert.SelfConversionDataParser;
import com.bmc.ctmconvert.SelfConversionExecuter;
import com.bmc.ctmconvert.SelfConversionRepositoryManager;
import com.bmc.ctmconvert.builderutils.BuilderUtils;
import com.bmc.ctmconvert.builderutils.CalculateJobTypes;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.exceptions.ConversionRuntimeException;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.exception.ScriptRuleException;
import com.bmc.ctmconvert.rule.RulesParser;
import com.bmc.ctmconvert.services.settings.Feature;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.workspace.Workspace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DoNewConvertServlet
extends HttpServlet {
    private final SelfConversionRepositoryManager repositoryManager;
    private final SelfConversionDataParser dataParser;

    public DoNewConvertServlet() {
        this(SelfConversionRepositoryManager.getRepositoryManager(), new BuilderUtils(FileSystems.getDefault())::parseInputData);
    }

    public DoNewConvertServlet(SelfConversionRepositoryManager repositoryManager, SelfConversionDataParser dataParser) {
        this.repositoryManager = repositoryManager;
        this.dataParser = dataParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject jsonResponse = new JSONObject();
        this.initResponseJason(jsonResponse);
        try {
            ServletInputStream requestAsInputStream = request.getInputStream();
            String requestBodyJsonString = IOUtils.toString((InputStream)requestAsInputStream);
            JSONObject requestJsonObject = new JSONObject(requestBodyJsonString);
            String projectName = requestJsonObject.getString("projectName");
            InputFilesExtractor inputFilesExtractor = new InputFilesExtractor(this.repositoryManager.getFileSystem());
            JSONArray projectDataFilesPathArray = inputFilesExtractor.extractFullPath(projectName);
            String version = requestJsonObject.getString("projectTargetCTMVersion");
            String draftFormat = requestJsonObject.getString("draftFormat");
            SettingsTable.instance().setProperty((Feature)SettingsBooleanKeys.JSON_DRAFT_FORMAT, draftFormat.equals("json"));
            JSONArray rulesJsonArray = requestJsonObject.getJSONArray("rules");
            RulesParser rulesParser = new RulesParser(rulesJsonArray);
            Path resultDraftPath = this.getResultDraftPath(projectName);
            SelfConversionExecuter selfConversionExecution = new SelfConversionExecuter(this.dataParser);
            Workspace workspace = selfConversionExecution.executeConversion(projectDataFilesPathArray, rulesParser, resultDraftPath, version);
            DataAccumulator dataAccumulator = selfConversionExecution.getDataAccumulator();
            ByteArrayOutputStream outputXmlWriter = selfConversionExecution.getOutputXmlWriter();
            String outputXmlContent = outputXmlWriter.toString();
            this.setSuccessResponseJson(jsonResponse, dataAccumulator, resultDraftPath, workspace, outputXmlContent);
            response.getWriter().print(jsonResponse.toString());
        }
        catch (ConversionRuntimeException | ConvertorCancelClickException | ConvertorException | ScriptRuleException | IOException | JSONException e) {
            String message = Optional.ofNullable(e.getMessage()).orElse("");
            this.setFailResponseJson(jsonResponse, message);
            response.getWriter().print(jsonResponse.toString());
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (RuntimeException e) {
            String message = "Runtime Exception  -> Please contact BMC Support and add the Exception log resides under <Conversion Home>\\logs directory.\n" + ExceptionUtils.getStackTrace((Throwable)e);
            this.setFailResponseJson(jsonResponse, message);
            response.getWriter().print(jsonResponse.toString());
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        finally {
            Context.reset();
        }
    }

    private void setFailResponseJson(JSONObject jsonResponse, String message) {
        jsonResponse.put("status", (Object)"fail");
        jsonResponse.put("message", (Object)message);
    }

    private void setSuccessResponseJson(JSONObject jsonResponse, DataAccumulator dataAccumulator, Path resultDraftPath, Workspace workspace, String outputXmlContent) {
        jsonResponse.put("status", (Object)"success");
        jsonResponse.put("message", (Object)"");
        jsonResponse.put("resultString", (Object)outputXmlContent);
        jsonResponse.put("filePath", (Object)resultDraftPath);
        jsonResponse.put("totalJobs", (Object)dataAccumulator.getCreatedJobsCount().toString());
        jsonResponse.put("totalFolders", (Object)dataAccumulator.getCreatedFoldersCount().toString());
        jsonResponse.put("totalSubs", (Object)dataAccumulator.getCreatedSubCount().toString());
        jsonResponse.put("totalElements", (Object)Integer.toString(dataAccumulator.getCreatedSubCount() + dataAccumulator.getCreatedFoldersCount() + dataAccumulator.getCreatedJobsCount()));
        jsonResponse.put("workspaceFoldersCount", (Object)Integer.toString(workspace.getFoldersList().size()));
        jsonResponse.put("workspaceJobsCount", (Object)Integer.toString(workspace.getJobsList().size()));
        CalculateJobTypes calculateJobTypes = new CalculateJobTypes();
        calculateJobTypes.sortJobsByKind(workspace, jsonResponse);
    }

    private void initResponseJason(JSONObject jsonResponse) {
        jsonResponse.put("status", (Object)"success");
        jsonResponse.put("message", (Object)"");
        jsonResponse.put("resultString", (Object)"");
        jsonResponse.put("filePath", (Object)"");
        jsonResponse.put("totalJobs", (Object)"");
        jsonResponse.put("totalFolders", (Object)"");
        jsonResponse.put("totalSubs", (Object)"");
        jsonResponse.put("totalElements", (Object)"");
        jsonResponse.put("workspaceFoldersCount", (Object)"");
        jsonResponse.put("workspaceJobsCount", (Object)"");
    }

    private Path getResultDraftPath(String projectName) {
        Path projectPath = this.repositoryManager.getProjectDirPathWithProjectNameSuffix(projectName);
        String draftFileName = GlobalFunctions.getDraftFileName();
        return projectPath.resolve(draftFileName);
    }
}

