/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.SelfConversionRepositoryManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CreateProjectServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SelfConversionRepositoryManager selfConversionRepositoryManager = SelfConversionRepositoryManager.getRepositoryManager();
        JSONObject responseJsonObject = new JSONObject();
        String projectName = "";
        try {
            ServletInputStream requestAsInputStream = request.getInputStream();
            String requestBodyJsonString = IOUtils.toString((InputStream)requestAsInputStream);
            JSONObject requestBodyJson = new JSONObject(requestBodyJsonString);
            JSONObject projectDataJsonObject = requestBodyJson.getJSONObject("projectData");
            JSONArray projectDataFilesPathArray = requestBodyJson.getJSONArray("projectDataFile");
            projectName = projectDataJsonObject.getString("projectName");
            selfConversionRepositoryManager.createProjectAndSaveToDisk(projectDataJsonObject, projectDataFilesPathArray);
            responseJsonObject.put("status", (Object)"success");
            responseJsonObject.put("project", (Object)selfConversionRepositoryManager.getProjectByName(projectName));
        }
        catch (ConversionException e) {
            try {
                selfConversionRepositoryManager.revertProjectFileStructure(projectName);
            }
            catch (ConversionException ce) {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)ce));
            }
            finally {
                responseJsonObject.put("status", (Object)"failure");
                responseJsonObject.put("reason", (Object)e.getMessage());
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            }
        }
        finally {
            response.getWriter().println(responseJsonObject.toString());
        }
    }
}

