/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.SelfConversionServer;
import com.bmc.ctmconvert.common.CompareVersionToS3;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.WhichAppRunning;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class App {
    public static void main(String[] args) {
        App.setRunningApp();
        App.checkForNewVersions();
        int portNumber = SettingsStringKeys.PORT_NUMBER.getIntValue();
        try {
            ExceptionHandler.initExceptionFile();
            SelfConversionServer server = new SelfConversionServer();
            server.start(portNumber);
            Process exec = App.getExec(server);
            exec.waitFor();
            server.stop();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            Thread.currentThread().interrupt();
        }
    }

    private static Process getExec(SelfConversionServer server) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(App.getElectronCommand());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.environment().putAll(App.createEnvironmentVariablesForClient(server));
        return processBuilder.start();
    }

    private static Map<String, String> createEnvironmentVariablesForClient(SelfConversionServer server) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("SELF_CONVERSION_PORT", "" + server.getPortNumber());
        SettingsTable.instance().consumeSettings((name, value) -> env.put(name.toString(), value.toString()));
        return env;
    }

    private static void setRunningApp() {
        WhichAppRunning whichAppRunning = new WhichAppRunning();
        try {
            whichAppRunning.setCurrentApp("SelfConversion");
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private static void checkForNewVersions() {
        try {
            TextManager.initiateInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        Thread compareVersion = new Thread(){

            @Override
            public void run() {
                this.start();
            }

            @Override
            public synchronized void start() {
                CompareVersionToS3 compareVer = new CompareVersionToS3(true);
                compareVer.compareToLatestVersion("https://control-m-conversion.s3.eu-central-1.amazonaws.com/ConversionToolVersionContent/VersionsContent.txt", Globs.TEMP_DIR + "/VersionsContent.txt");
            }
        };
        compareVersion.start();
    }

    private static String getElectronCommand() {
        String electronPath = Globs.HOME_DIR + "\\SelfConversion\\dist\\electron\\dist\\electron.exe ";
        String args = Globs.HOME_DIR + "\\SelfConversion\\dist";
        return "\"" + electronPath + "\" \"" + args + "\"";
    }
}

