/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0014\u0010\u0013\u001a\u00020\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "length", "", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "integerAutoincType", "integerType", "longAutoincType", "longType", "processForDefaultValue", "e", "Lorg/jetbrains/exposed/sql/Expression;", "textType", "timeType", "ubyteType", "uintegerType", "ulongType", "uuidType", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String integerType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "NUMBER(13)";
    }

    @Override
    @NotNull
    public String longType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String textType() {
        return "CLOB";
    }

    @Override
    @NotNull
    public String timeType() {
        return this.dateTimeType();
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        String string = "Binary type is unsupported for Oracle. Please use blob column type instead.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        return length < 2000 ? "RAW (" + length + ')' : this.binaryType();
    }

    @Override
    @NotNull
    public String uuidType() {
        return "RAW(16)";
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            String string = value;
            boolean bl2 = false;
            bl = Long.parseLong(string) != 0L;
        }
        catch (NumberFormatException ex) {
            String string = Intrinsics.stringPlus((String)"Unexpected value of type Boolean: ", (Object)value);
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp) {
            IDateColumnType iDateColumnType;
            IColumnType iColumnType = ((LiteralOp)e).getColumnType();
            IDateColumnType iDateColumnType2 = iDateColumnType = iColumnType instanceof IDateColumnType ? (IDateColumnType)((Object)iColumnType) : null;
            if (iDateColumnType == null ? false : !iDateColumnType.getHasTimePart()) {
                string = Intrinsics.stringPlus((String)"DATE ", (Object)super.processForDefaultValue(e));
                return string;
            }
        }
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof IDateColumnType) {
            string = Intrinsics.stringPlus((String)"TIMESTAMP ", (Object)super.processForDefaultValue(e));
            return string;
        }
        string = super.processForDefaultValue(e);
        return string;
    }
}

