/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0)H&J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0016JC\u00100\u001a$\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020/\u0012\b\u0012\u0006\u0012\u0002\b\u00030302\u0012\n\u0012\b\u0012\u0004\u0012\u0002040)012\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020/06\"\u00020/H\u0016\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020;H&J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000fH&J\u0018\u0010C\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>2\u0006\u0010D\u001a\u00020\u0013H\u0016J3\u0010E\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0)012\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020/06\"\u00020/H\u0016\u00a2\u0006\u0002\u00107J\b\u0010F\u001a\u00020\u000fH&J\u0014\u0010G\u001a\u00020\u00132\n\u0010H\u001a\u0006\u0012\u0002\b\u00030IH\u0016J2\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0)2\n\u0010K\u001a\u0006\u0012\u0002\b\u0003032\u0006\u0010L\u001a\u00020\u00132\u0006\u0010M\u001a\u00020\u00132\u0006\u0010N\u001a\u00020\u0013H&J\b\u0010O\u001a\u00020PH&J\b\u0010Q\u001a\u00020PH&J\u0010\u0010R\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>H&J\u0010\u0010S\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010T\u001a\u00020\u0013H&J3\u0010U\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0)012\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020/06\"\u00020/H\u0016\u00a2\u0006\u0002\u00107J\u0010\u0010W\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0014\u0010\u001e\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0012\u0010 \u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u0014\u0010&\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015\u00a8\u0006X"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "name", "", "getName", "()Ljava/lang/String;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsCreateSchema", "getSupportsCreateSchema", "supportsCreateSequence", "getSupportsCreateSequence", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "allTablesNames", "", "catalog", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "checkTableMapping", "table", "Lorg/jetbrains/exposed/sql/Table;", "columnConstraints", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "createDatabase", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "dropSchema", "cascade", "existingIndices", "getDatabase", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "column", "nullabilityChanged", "autoIncrementChanged", "defaultChanged", "resetCaches", "", "resetSchemaCaches", "schemaExists", "setSchema", "supportsSelectForUpdate", "tableColumns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableExists", "exposed-core"})
public interface DatabaseDialect {
    @NotNull
    public String getName();

    @NotNull
    public DataTypeProvider getDataTypeProvider();

    @NotNull
    public FunctionProvider getFunctionProvider();

    public boolean getSupportsIfNotExists();

    public boolean getSupportsCreateSequence();

    public boolean getNeedsSequenceToAutoInc();

    @NotNull
    public ReferenceOption getDefaultReferenceOption();

    public boolean getNeedsQuotesWhenSymbolsInNames();

    public boolean getSupportsMultipleGeneratedKeys();

    public boolean getSupportsSequenceAsGeneratedKeys();

    public boolean getSupportsOnlyIdentifiersInGeneratedKeys();

    public boolean getSupportsCreateSchema();

    public boolean getSupportsSubqueryUnions();

    public boolean getSupportsDualTableConcept();

    @NotNull
    public String getDatabase();

    @NotNull
    public List<String> allTablesNames();

    public boolean tableExists(@NotNull Table var1);

    public boolean schemaExists(@NotNull Schema var1);

    public boolean checkTableMapping(@NotNull Table var1);

    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... var1);

    @NotNull
    public Map<Pair<Table, Column<?>>, List<ForeignKeyConstraint>> columnConstraints(Table ... var1);

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... var1);

    public boolean supportsSelectForUpdate();

    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> var1);

    @NotNull
    public String catalog(@NotNull Transaction var1);

    public void resetCaches();

    public void resetSchemaCaches();

    @NotNull
    public String createIndex(@NotNull Index var1);

    @NotNull
    public String dropIndex(@NotNull String var1, @NotNull String var2);

    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> var1, boolean var2, boolean var3, boolean var4);

    @NotNull
    public String createDatabase(@NotNull String var1);

    @NotNull
    public String dropDatabase(@NotNull String var1);

    @NotNull
    public String setSchema(@NotNull Schema var1);

    @NotNull
    public String createSchema(@NotNull Schema var1);

    @NotNull
    public String dropSchema(@NotNull Schema var1, boolean var2);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean getSupportsIfNotExists(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return true;
        }

        public static boolean getSupportsCreateSequence(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return true;
        }

        public static boolean getNeedsSequenceToAutoInc(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return false;
        }

        @NotNull
        public static ReferenceOption getDefaultReferenceOption(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return ReferenceOption.RESTRICT;
        }

        public static boolean getNeedsQuotesWhenSymbolsInNames(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return true;
        }

        public static boolean getSupportsSequenceAsGeneratedKeys(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return this_.getSupportsCreateSequence();
        }

        public static boolean getSupportsOnlyIdentifiersInGeneratedKeys(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return false;
        }

        public static boolean getSupportsCreateSchema(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return true;
        }

        public static boolean getSupportsSubqueryUnions(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return false;
        }

        public static boolean getSupportsDualTableConcept(@NotNull DatabaseDialect this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return false;
        }

        public static boolean checkTableMapping(@NotNull DatabaseDialect this_, @NotNull Table table) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return true;
        }

        @NotNull
        public static Map<Table, List<ColumnMetadata>> tableColumns(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Pair<Table, Column<?>>, List<ForeignKeyConstraint>> columnConstraints(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Table, List<Index>> existingIndices(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            return MapsKt.emptyMap();
        }

        public static boolean isAllowedAsColumnDefault(@NotNull DatabaseDialect this_, @NotNull Expression<?> e) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(e, (String)"e");
            return e instanceof LiteralOp;
        }

        @NotNull
        public static String catalog(@NotNull DatabaseDialect this_, @NotNull Transaction transaction2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            return transaction2.getConnection().getCatalog();
        }

        @NotNull
        public static String createDatabase(@NotNull DatabaseDialect this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.stringPlus((String)"CREATE DATABASE IF NOT EXISTS ", (Object)DefaultKt.inProperCase(name));
        }

        @NotNull
        public static String dropDatabase(@NotNull DatabaseDialect this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.stringPlus((String)"DROP DATABASE IF EXISTS ", (Object)DefaultKt.inProperCase(name));
        }

        @NotNull
        public static String setSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return Intrinsics.stringPlus((String)"SET SCHEMA ", (Object)schema.getIdentifier());
        }

        @NotNull
        public static String createSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder;
            boolean bl5 = false;
            receiver.append("CREATE SCHEMA IF NOT EXISTS ");
            receiver.append(schema.getIdentifier());
            SchemaKt.appendIfNotNull(receiver, " AUTHORIZATION ", schema.getAuthorization());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public static String dropSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema, boolean cascade) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder receiver = stringBuilder;
            boolean bl5 = false;
            String[] stringArray = new String[]{"DROP SCHEMA IF EXISTS ", schema.getIdentifier()};
            StringsKt.append((StringBuilder)receiver, (String[])stringArray);
            if (cascade) {
                receiver.append(" CASCADE");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

