/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Slf4jSqlDebugLogger;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.UserDataHolder;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 v2\u00020\u00012\u00020\u0002:\u0001vB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\t\u0010K\u001a\u00020LH\u0096\u0001J\u0006\u0010M\u001a\u00020LJ\b\u0010N\u001a\u00020LH\u0016J\u0018\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020$H\u0002J?\u0010R\u001a\u0004\u0018\u00010L2\u0006\u0010Q\u001a\u00020$2\u001c\b\u0002\u0010S\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020U\u0012\u0006\u0012\u0004\u0018\u00010V0:0T2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010X\u00a2\u0006\u0002\u0010YJ]\u0010R\u001a\u0004\u0018\u0001HZ\"\b\b\u0000\u0010Z*\u00020V2\u0006\u0010Q\u001a\u00020$2\u001c\b\u0002\u0010S\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020U\u0012\u0006\u0012\u0004\u0018\u00010V0:0T2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010X2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u0002HZ0\\\u00a2\u0006\u0002\u0010^J!\u0010R\u001a\u0004\u0018\u0001HZ\"\u0004\b\u0000\u0010Z2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HZ0_\u00a2\u0006\u0002\u0010`JL\u0010R\u001a\u0004\u0018\u0001Ha\"\u0004\b\u0000\u0010Z\"\u0004\b\u0001\u0010a2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HZ0_2#\u0010b\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002HZ0_\u0012\u0004\u0012\u0002HZ\u0012\u0004\u0012\u0002Ha0c\u00a2\u0006\u0002\bd\u00a2\u0006\u0002\u0010eJ\u0014\u0010f\u001a\u00020L2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020$0hJ\u0012\u0010i\u001a\u00020$2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030kJ!\u0010i\u001a\u00020L2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030k2\u0006\u0010l\u001a\u00020mH\u0000\u00a2\u0006\u0002\bnJ\u0012\u0010o\u001a\u00020$2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030kJ\u000e\u0010o\u001a\u00020$2\u0006\u0010p\u001a\u00020qJ\u000e\u0010r\u001a\u00020\u00142\u0006\u0010s\u001a\u00020+J\b\u0010t\u001a\u00020LH\u0016J\u000e\u0010u\u001a\u00020\u00142\u0006\u0010s\u001a\u00020+R\u0016\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R$\u0010)\u001a\u0012\u0012\u0004\u0012\u00020+0*j\b\u0012\u0004\u0012\u00020+`,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0004\u0018\u00010\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107RE\u00108\u001a6\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001a0:09j\u001a\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001a0:`;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0015\u0010>\u001a\u00060?j\u0002`@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010C\u001a\u000203X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bD\u00105R\u001e\u0010E\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010J\u001a\u0004\bF\u0010G\"\u0004\bH\u0010I\u00a8\u0006w"}, d2={"Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/UserDataHolder;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "transactionImpl", "(Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;)V", "connection", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "currentStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "executedStatements", "", "getExecutedStatements$exposed_core", "()Ljava/util/List;", "id", "", "getId", "()Ljava/lang/String;", "id$delegate", "Lkotlin/Lazy;", "interceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;", "Lkotlin/collections/ArrayList;", "getInterceptors$exposed_core", "()Ljava/util/ArrayList;", "outerTransaction", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "statementCount", "", "getStatementCount", "()I", "setStatementCount", "(I)V", "statementStats", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lkotlin/collections/HashMap;", "getStatementStats", "()Ljava/util/HashMap;", "statements", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getStatements", "()Ljava/lang/StringBuilder;", "transactionIsolation", "getTransactionIsolation", "warnLongQueriesDuration", "getWarnLongQueriesDuration", "()Ljava/lang/Long;", "setWarnLongQueriesDuration", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "close", "", "closeExecutedStatements", "commit", "describeStatement", "delta", "stmt", "exec", "args", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "explicitStatementType", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;)Lkotlin/Unit;", "T", "transform", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "(Lorg/jetbrains/exposed/sql/statements/Statement;)Ljava/lang/Object;", "R", "body", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/statements/Statement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "execInBatch", "stmts", "", "fullIdentity", "column", "Lorg/jetbrains/exposed/sql/Column;", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "fullIdentity$exposed_core", "identity", "table", "Lorg/jetbrains/exposed/sql/Table;", "registerInterceptor", "interceptor", "rollback", "unregisterInterceptor", "Companion", "exposed-core"})
public class Transaction
extends UserDataHolder
implements TransactionInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransactionInterface transactionImpl;
    @NotNull
    private final ArrayList<StatementInterceptor> interceptors;
    private int statementCount;
    private long duration;
    @Nullable
    private Long warnLongQueriesDuration;
    private boolean debug;
    @NotNull
    private final Lazy id$delegate;
    @Nullable
    private PreparedStatementApi currentStatement;
    @NotNull
    private final List<PreparedStatementApi> executedStatements;
    @NotNull
    private final StringBuilder statements;
    @NotNull
    private final HashMap<String, Pair<Integer, Long>> statementStats;
    @NotNull
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors;

    public Transaction(@NotNull TransactionInterface transactionImpl) {
        Intrinsics.checkNotNullParameter((Object)transactionImpl, (String)"transactionImpl");
        this.transactionImpl = transactionImpl;
        boolean bl = false;
        this.interceptors = new ArrayList();
        this.id$delegate = LazyKt.lazy((Function0)id.2.INSTANCE);
        bl = false;
        this.executedStatements = new ArrayList();
        this.statements = new StringBuilder();
        bl = false;
        this.statementStats = new HashMap();
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{Slf4jSqlDebugLogger.INSTANCE};
        SQLLogKt.addLogger(this, sqlLoggerArray);
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    @Override
    @NotNull
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    @NotNull
    public Database getDb() {
        return this.transactionImpl.getDb();
    }

    @Override
    @Nullable
    public Transaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @NotNull
    public final ArrayList<StatementInterceptor> getInterceptors$exposed_core() {
        return this.interceptors;
    }

    public final boolean registerInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.add(interceptor);
    }

    public final boolean unregisterInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.remove(interceptor);
    }

    public final int getStatementCount() {
        return this.statementCount;
    }

    public final void setStatementCount(int n) {
        this.statementCount = n;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    @Nullable
    public final Long getWarnLongQueriesDuration() {
        return this.warnLongQueriesDuration;
    }

    public final void setWarnLongQueriesDuration(@Nullable Long l) {
        this.warnLongQueriesDuration = l;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final String getId() {
        Lazy lazy = this.id$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Nullable
    public final PreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable PreparedStatementApi preparedStatementApi) {
        this.currentStatement = preparedStatementApi;
    }

    @NotNull
    public final List<PreparedStatementApi> getExecutedStatements$exposed_core() {
        return this.executedStatements;
    }

    @NotNull
    public final StringBuilder getStatements() {
        return this.statements;
    }

    @NotNull
    public final HashMap<String, Pair<Integer, Long>> getStatementStats() {
        return this.statementStats;
    }

    @Override
    public void commit() {
        StatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeCommit(this);
        }
        this.transactionImpl.commit();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit();
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit();
        }
        this.getUserdata().clear();
    }

    @Override
    public void rollback() {
        StatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        this.transactionImpl.rollback();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback();
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback();
        }
        this.getUserdata().clear();
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take((String)stmt, (int)1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args, @Nullable StatementType explicitStatementType) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return (Unit)this.exec(stmt, args, explicitStatementType, exec.1.INSTANCE);
    }

    public static /* synthetic */ Unit exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType);
    }

    @Nullable
    public final <T> T exec(@NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args, @Nullable StatementType explicitStatementType, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        StatementType statementType;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        CharSequence charSequence = stmt;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Object object = explicitStatementType;
        if (object == null) {
            StatementType statementType2;
            block4: {
                StatementType statementType3;
                StatementType[] statementTypeArray = StatementType.values();
                boolean bl2 = false;
                StatementType[] statementTypeArray2 = statementTypeArray;
                boolean bl3 = false;
                StatementType[] statementTypeArray3 = statementTypeArray2;
                int n = statementTypeArray3.length;
                for (int i = 0; i < n; ++i) {
                    StatementType statementType4;
                    StatementType it = statementType4 = statementTypeArray3[i];
                    boolean bl4 = false;
                    String string = stmt;
                    boolean bl5 = false;
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)it.name(), (boolean)true)) continue;
                    statementType3 = statementType4;
                    break block4;
                }
                statementType3 = statementType2 = null;
            }
            statementType = statementType2 == null ? StatementType.OTHER : statementType2;
        } else {
            statementType = object;
        }
        StatementType type = statementType;
        object = CollectionsKt.emptyList();
        return this.exec(new Statement<T>(type, transform, stmt, args, (List<? extends Table>)object){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType, Object>> $args;
            {
                this.$type = $type;
                this.$transform = $transform;
                this.$stmt = $stmt;
                this.$args = $args;
                super($type, $super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
                Object object;
                ResultSet resultSet;
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                Object object2 = this.$type;
                int n = exec.WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
                switch (n) {
                    case 1: 
                    case 2: {
                        resultSet = $this$executeInternal.executeQuery();
                        break;
                    }
                    default: {
                        $this$executeInternal.executeUpdate();
                        resultSet = $this$executeInternal.getResultSet();
                    }
                }
                ResultSet result = resultSet;
                object2 = result;
                if (object2 == null) {
                    object = null;
                } else {
                    Object object3;
                    Object object4 = object2;
                    Function1<ResultSet, T> function1 = this.$transform;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    try (Object it = object4;){
                        object3 = function1.invoke(it);
                    }
                    object = object3;
                }
                return (T)object;
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction2) {
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                return this.$stmt;
            }

            @NotNull
            public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
                return CollectionsKt.listOf(this.$args);
            }
        });
    }

    public static /* synthetic */ Object exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType, function1);
    }

    @Nullable
    public final <T> T exec(@NotNull Statement<? extends T> stmt) {
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        return (T)this.exec(stmt, exec.3.INSTANCE);
    }

    public final void execInBatch(@NotNull List<String> stmts) {
        Intrinsics.checkNotNullParameter(stmts, (String)"stmts");
        this.getConnection().executeInBatch(stmts);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull Statement<? extends T> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Transaction transaction2 = this;
        int n = transaction2.statementCount;
        transaction2.statementCount = n + 1;
        long start = System.currentTimeMillis();
        Pair<? extends T, List<StatementContext>> answer = stmt.executeIn$exposed_core(this);
        long delta = System.currentTimeMillis() - start;
        Lazy lazySQL2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(answer, this){
            final /* synthetic */ Pair<T, List<StatementContext>> $answer;
            final /* synthetic */ Transaction this$0;
            {
                this.$answer = $answer;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)this.$answer.getSecond();
                Transaction transaction2 = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StatementContext statementContext = (StatementContext)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.sql(transaction2);
                    collection.add(string);
                }
                return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
            }
        }));
        Object object2 = this;
        ((Transaction)object2).duration += delta;
        if (this.debug) {
            Object object3;
            void $this$getOrPut$iv;
            this.statements.append(this.describeStatement(delta, (String)lazySQL2.getValue()));
            object2 = this.statementStats;
            Object key$iv = lazySQL2.getValue();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Pair answer$iv = TuplesKt.to((Object)0, (Object)0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            object2 = object3;
            boolean bl3 = false;
            bl = false;
            Pair $dstr$count$time = (Pair)object2;
            boolean bl4 = false;
            int count2 = ((Number)$dstr$count$time.component1()).intValue();
            long time = ((Number)$dstr$count$time.component2()).longValue();
            Map map = this.getStatementStats();
            Object object4 = lazySQL2.getValue();
            Pair pair = TuplesKt.to((Object)(count2 + 1), (Object)(time + delta));
            boolean bl5 = false;
            map.put(object4, pair);
        }
        if (delta > ((object2 = this.warnLongQueriesDuration) == null ? Long.MAX_VALUE : (Long)object2)) {
            SQLLogKt.getExposedLogger().warn(Intrinsics.stringPlus((String)"Long query: ", (Object)this.describeStatement(delta, (String)lazySQL2.getValue())), (Throwable)new RuntimeException());
        }
        if ((object2 = answer.getFirst()) == null) {
            object = null;
        } else {
            Object object5 = object2;
            bl = false;
            boolean bl6 = false;
            Object it = object5;
            boolean bl7 = false;
            object = body.invoke(stmt, it);
        }
        return (R)object;
    }

    @NotNull
    public final String identity(@NotNull Table table) {
        String string;
        Alias alias;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Alias alias2 = alias = table instanceof Alias ? (Alias)table : null;
        if (alias == null) {
            string = null;
        } else {
            Alias alias3 = alias;
            boolean bl = false;
            boolean bl2 = false;
            Alias it = alias3;
            boolean bl3 = false;
            string = this.identity((Table)it.getDelegate()) + ' ' + this.getDb().getIdentifierManager().quoteIfNecessary(it.getAlias());
        }
        String string2 = string;
        return string2 == null ? this.getDb().getIdentifierManager().quoteIfNecessary(DefaultKt.inProperCase(table.getTableName())) : string2;
    }

    @NotNull
    public final String fullIdentity(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        QueryBuilder queryBuilder = new QueryBuilder(false);
        boolean bl = false;
        boolean bl2 = false;
        QueryBuilder it = queryBuilder;
        boolean bl3 = false;
        this.fullIdentity$exposed_core(column, it);
        return queryBuilder.toString();
    }

    public final void fullIdentity$exposed_core(@NotNull Column<?> column, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(column, this){
            final /* synthetic */ Column<?> $column;
            final /* synthetic */ Transaction this$0;
            {
                this.$column = $column;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                if (this.$column.getTable() instanceof Alias) {
                    $this$invoke.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(((Alias)this.$column.getTable()).getAlias()));
                } else {
                    $this$invoke.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(DefaultKt.inProperCase(this.$column.getTable().getTableName())));
                }
                $this$invoke.append('.');
                $this$invoke.append(this.this$0.identity(this.$column));
            }
        }));
    }

    @NotNull
    public final String identity(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.getName());
    }

    public final void closeExecutedStatements() {
        Iterable $this$forEach$iv = this.executedStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreparedStatementApi it = (PreparedStatementApi)element$iv;
            boolean bl = false;
            it.closeIfPossible();
        }
        this.executedStatements.clear();
    }

    static {
        boolean bl = false;
        globalInterceptors = new ArrayList();
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(GlobalStatementInterceptor::class.java, GlobalStatementInterceptor::class.java.classLoader)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl2 = false;
            globalInterceptors.add(it);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/Transaction$Companion;", "", "()V", "globalInterceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "Lkotlin/collections/ArrayList;", "getGlobalInterceptors$exposed_core", "()Ljava/util/ArrayList;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors$exposed_core() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

