/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\fJ3\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u000f*\u00020\b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000f0\u0007\"\u0002H\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ)\u0010\u001b\u001a\u00020\u000e2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J)\u0010\u001c\u001a\u00020\u000e2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0007\"\u00020\u001e2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u000e2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0\u0007\"\u00020\"2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ)\u0010%\u001a\u00020\u000e2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J)\u0010&\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J3\u0010'\u001a\u00020\u000e2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0007\"\u00020\u001e2\b\b\u0002\u0010(\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010)J)\u0010*\u001a\u00020\u000e2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0\u0007\"\u00020\"2\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010#J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u001e2\b\b\u0002\u0010\u0010\u001a\u00020\u000bJ\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0.J\"\u0010/\u001a\u00020\u000e*\u0002002\u0006\u0010\u0010\u001a\u00020\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001e\u00102\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f*\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u0002H\u000f04\u00a8\u00066"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils;", "", "()V", "addMissingColumnsStatements", "", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/List;", "checkCycle", "", "([Lorg/jetbrains/exposed/sql/Table;)Z", "create", "", "T", "inBatch", "([Lorg/jetbrains/exposed/sql/Table;Z)V", "createDatabase", "databases", "([Ljava/lang/String;Z)V", "createFKey", "reference", "Lorg/jetbrains/exposed/sql/Column;", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createMissingTablesAndColumns", "createSchema", "schemas", "Lorg/jetbrains/exposed/sql/Schema;", "([Lorg/jetbrains/exposed/sql/Schema;Z)V", "createSequence", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "([Lorg/jetbrains/exposed/sql/Sequence;Z)V", "createStatements", "drop", "dropDatabase", "dropSchema", "cascade", "([Lorg/jetbrains/exposed/sql/Schema;ZZ)V", "dropSequence", "setSchema", "schema", "sortTablesByReferences", "", "execStatements", "Lorg/jetbrains/exposed/sql/Transaction;", "statements", "withDataBaseLock", "body", "Lkotlin/Function0;", "TableDepthGraph", "exposed-core"})
public final class SchemaUtils {
    @NotNull
    public static final SchemaUtils INSTANCE = new SchemaUtils();

    private SchemaUtils() {
    }

    @NotNull
    public final List<Table> sortTablesByReferences(@NotNull Iterable<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        return new TableDepthGraph(tables).sorted();
    }

    public final boolean checkCycle(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return new TableDepthGraph(ArraysKt.toList((Object[])tables)).hasCycle();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> createStatements(Table ... tables) {
        void $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Table[] tableArray = tables;
        boolean bl = false;
        if (tableArray.length == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filterNot$iv = this.sortTablesByReferences(ArraysKt.toList((Object[])tables));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Table it = (Table)element$iv$iv;
            boolean bl2 = false;
            if (QueriesKt.exists(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toCreate = (List)destination$iv$iv;
        $i$f$filterNot = false;
        ArrayList alters = new ArrayList();
        Iterable $this$flatMap$iv = toCreate;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv2;
            Table table = (Table)element$iv$iv;
            boolean bl3 = false;
            Iterable $this$partition$iv = table.getDdl();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                String it = (String)element$iv2;
                boolean bl4 = false;
                if (StringsKt.startsWith$default((String)it, (String)"CREATE ", (boolean)false, (int)2, null)) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List create = (List)pair.component1();
            List alter = (List)pair.component2();
            Iterable $this$flatMap$iv2 = table.getIndices();
            boolean $i$f$flatMap2 = false;
            element$iv2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                Index it = (Index)element$iv$iv2;
                boolean bl5 = false;
                Iterable list$iv$iv = INSTANCE.createIndex(it);
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List indicesDDL = (List)destination$iv$iv3;
            Collection collection = alters;
            boolean bl6 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)alter);
            Iterable list$iv$iv = CollectionsKt.plus((Collection)create, (Iterable)indicesDDL);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)alters);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSequence(@NotNull Sequence[] seq, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$createSequence_u24lambda_u2d5 = transaction2;
        boolean bl3 = false;
        Sequence[] $this$flatMap$iv = seq;
        boolean $i$f$flatMap = false;
        Sequence[] sequenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var13_13 = $this$flatMapTo$iv$iv;
        int n = ((void)var13_13).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var13_13[i];
            boolean bl4 = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$createSequence_u24lambda_u2d5, inBatch, createStatements);
    }

    public static /* synthetic */ void createSequence$default(SchemaUtils schemaUtils, Sequence[] sequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createSequence(sequenceArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropSequence(@NotNull Sequence[] seq, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$dropSequence_u24lambda_u2d7 = transaction2;
        boolean bl3 = false;
        Sequence[] $this$flatMap$iv = seq;
        boolean $i$f$flatMap = false;
        Sequence[] sequenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var13_13 = $this$flatMapTo$iv$iv;
        int n = ((void)var13_13).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var13_13[i];
            boolean bl4 = false;
            Iterable list$iv$iv = it.dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$dropSequence_u24lambda_u2d7, inBatch, dropStatements);
    }

    public static /* synthetic */ void dropSequence$default(SchemaUtils schemaUtils, Sequence[] sequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.dropSequence(sequenceArray, bl);
    }

    @NotNull
    public final List<String> createFKey(@NotNull Column<?> reference) {
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        ForeignKeyConstraint foreignKey = reference.getForeignKey();
        boolean bl = foreignKey != null && (foreignKey.getDeleteRule() != null || foreignKey.getUpdateRule() != null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = reference + " does not reference anything";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return foreignKey.createStatement();
    }

    @NotNull
    public final List<String> createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        return index.createStatement();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> addMissingColumnsStatements(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$addMissingColumnsStatements_u24lambda_u2d22 = transaction2;
        boolean bl3 = false;
        ArrayList statements = new ArrayList();
        Table[] tableArray = tables;
        boolean bl4 = false;
        if (tableArray.length == 0) {
            return statements;
        }
        Table[] message$iv = "Extracting table columns";
        int $i$f$logTimeSpent = 0;
        long start$iv = System.currentTimeMillis();
        boolean bl5 = false;
        Map<Table, List<ColumnMetadata>> answer$iv = DefaultKt.getCurrentDialect().tableColumns(Arrays.copyOf(tables, tables.length));
        SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        Map<Table, List<ColumnMetadata>> existingTableColumns = answer$iv;
        message$iv = tables;
        $i$f$logTimeSpent = 0;
        int n = message$iv.length;
        while ($i$f$logTimeSpent < n) {
            void $this$mapNotNullTo$iv$iv;
            Object $this$any$iv;
            Iterator $this$filterNotTo$iv$iv;
            Table table = message$iv[$i$f$logTimeSpent];
            ++$i$f$logTimeSpent;
            List list = existingTableColumns.get(table);
            boolean bl6 = false;
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List thisTableExistingColumns = list2;
            Iterable $this$filterNot$iv = table.getColumns();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl7;
                Object element$iv$iv;
                block27: {
                    element$iv$iv = iterator2.next();
                    Column c = (Column)element$iv$iv;
                    boolean bl8 = false;
                    $this$any$iv = thisTableExistingColumns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl7 = false;
                    } else {
                        Iterator iterator3 = $this$any$iv.iterator();
                        while (iterator3.hasNext()) {
                            Object element$iv = iterator3.next();
                            ColumnMetadata it = (ColumnMetadata)element$iv;
                            boolean bl9 = false;
                            if (!StringsKt.equals((String)it.getName(), (String)c.getName(), (boolean)true)) continue;
                            bl7 = true;
                            break block27;
                        }
                        bl7 = false;
                    }
                }
                if (bl7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missingTableColumns = (List)destination$iv$iv;
            Iterable $this$flatMapTo$iv = missingTableColumns;
            boolean $i$f$flatMapTo = false;
            $this$filterNotTo$iv$iv = $this$flatMapTo$iv.iterator();
            while ($this$filterNotTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterNotTo$iv$iv.next();
                Column it = (Column)element$iv;
                boolean bl10 = false;
                Iterable list$iv = it.getDdl();
                CollectionsKt.addAll((Collection)statements, (Iterable)list$iv);
            }
            if (!$this$addMissingColumnsStatements_u24lambda_u2d22.getDb().getSupportsAlterTableWithAddColumn()) continue;
            for (Index index : table.getIndices()) {
                boolean bl11;
                block28: {
                    Iterable $this$any$iv2 = index.getColumns();
                    boolean $i$f$any = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl11 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            Column it = (Column)element$iv;
                            boolean bl12 = false;
                            if (!missingTableColumns.contains(it)) continue;
                            bl11 = true;
                            break block28;
                        }
                        bl11 = false;
                    }
                }
                if (!bl11) continue;
                statements.addAll(INSTANCE.createIndex(index));
            }
            DataTypeProvider dataTypeProvider = $this$addMissingColumnsStatements_u24lambda_u2d22.getDb().getDialect().getDataTypeProvider();
            Iterable $this$mapNotNull$iv = table.getColumns();
            boolean $i$f$mapNotNull = false;
            Iterable list$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            $this$any$iv = $this$forEach$iv$iv$iv.iterator();
            while ($this$any$iv.hasNext()) {
                Pair pair;
                Triple triple;
                Object v3;
                boolean bl13;
                boolean bl14;
                Object object;
                Column c;
                block29: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = $this$any$iv.next();
                    boolean bl15 = false;
                    c = (Column)element$iv$iv;
                    boolean bl16 = false;
                    object = thisTableExistingColumns;
                    bl14 = false;
                    Iterable iterable2 = object;
                    bl13 = false;
                    for (Object t : iterable2) {
                        ColumnMetadata it = (ColumnMetadata)t;
                        boolean bl17 = false;
                        if (!StringsKt.equals((String)c.getName(), (String)it.getName(), (boolean)true)) continue;
                        v3 = t;
                        break block29;
                    }
                    v3 = null;
                }
                ColumnMetadata columnMetadata = v3;
                if (columnMetadata == null) {
                    triple = null;
                } else {
                    String string;
                    object = columnMetadata;
                    bl14 = false;
                    boolean bl18 = false;
                    Object it = object;
                    boolean bl19 = false;
                    boolean incorrectNullability = ((ColumnMetadata)it).getNullable() != c.getColumnType().getNullable();
                    boolean incorrectAutoInc = ((ColumnMetadata)it).getAutoIncrement() != ColumnTypeKt.isAutoInc(c.getColumnType());
                    String string2 = ((ColumnMetadata)it).getDefaultDbValue();
                    Expression expression = c.getDbDefaultValue$exposed_core();
                    if (expression == null) {
                        string = null;
                    } else {
                        void it2;
                        Expression expression2 = expression;
                        boolean bl20 = false;
                        boolean bl21 = false;
                        Expression expression3 = expression2;
                        String string3 = string2;
                        boolean bl22 = false;
                        String string4 = dataTypeProvider.processForDefaultValue((Expression<?>)it2);
                        string2 = string3;
                        string = string4;
                    }
                    boolean incorrectDefaults = !Intrinsics.areEqual((Object)string2, string);
                    triple = new Triple((Object)incorrectNullability, (Object)incorrectAutoInc, (Object)incorrectDefaults);
                }
                Triple changedState = triple;
                columnMetadata = changedState;
                if (columnMetadata == null) {
                    pair = null;
                } else {
                    Object object2 = columnMetadata;
                    boolean bl23 = false;
                    bl13 = false;
                    Object it = object2;
                    boolean bl24 = false;
                    Object object3 = object = (Boolean)it.getFirst() != false || (Boolean)it.getSecond() != false || (Boolean)it.getThird() != false ? object2 : null;
                    if (object == null) {
                        pair = null;
                    } else {
                        object2 = object;
                        bl23 = false;
                        bl13 = false;
                        it = object2;
                        boolean bl25 = false;
                        pair = TuplesKt.to((Object)c, (Object)changedState);
                    }
                }
                if (pair == null) continue;
                Pair pair2 = pair;
                boolean bl26 = false;
                boolean bl27 = false;
                Pair it$iv$iv = pair2;
                boolean bl28 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List redoColumn = (List)destination$iv$iv2;
            Iterable $this$flatMapTo$iv2 = redoColumn;
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv : $this$flatMapTo$iv2) {
                Pair $dstr$col$changedState = (Pair)element$iv;
                boolean bl29 = false;
                Column col = (Column)$dstr$col$changedState.component1();
                Triple changedState = (Triple)$dstr$col$changedState.component2();
                Iterable list$iv2 = col.modifyStatements((Boolean)changedState.getFirst(), (Boolean)changedState.getSecond(), (Boolean)changedState.getThird());
                CollectionsKt.addAll((Collection)statements, (Iterable)list$iv2);
            }
        }
        if ($this$addMissingColumnsStatements_u24lambda_u2d22.getDb().getSupportsAlterTableWithAddColumn()) {
            String message$iv2 = "Extracting column constraints";
            boolean $i$f$logTimeSpent2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl30 = false;
            Map<Pair<Table, Column<?>>, List<ForeignKeyConstraint>> answer$iv2 = $this$addMissingColumnsStatements_u24lambda_u2d22.getDb().getDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
            Map<Pair<Table, Column<?>>, List<ForeignKeyConstraint>> existingColumnConstraint = answer$iv2;
            Table[] tableArray2 = tables;
            n = 0;
            int n2 = tableArray2.length;
            while (n < n2) {
                Table table = tableArray2[n];
                ++n;
                for (Column<?> column : table.getColumns()) {
                    ForeignKeyConstraint existingConstraint;
                    ForeignKeyConstraint foreignKey = column.getForeignKey();
                    if (foreignKey == null) continue;
                    List<ForeignKeyConstraint> list = existingColumnConstraint.get(TuplesKt.to((Object)table, column));
                    ForeignKeyConstraint foreignKeyConstraint = existingConstraint = list == null ? null : (ForeignKeyConstraint)CollectionsKt.firstOrNull(list);
                    if (existingConstraint == null) {
                        statements.addAll(INSTANCE.createFKey(column));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)existingConstraint.getTarget().getTable(), (Object)foreignKey.getTarget().getTable()) && foreignKey.getDeleteRule() == existingConstraint.getDeleteRule() && foreignKey.getUpdateRule() == existingConstraint.getUpdateRule()) continue;
                    statements.addAll(existingConstraint.dropStatement());
                    statements.addAll(INSTANCE.createFKey(column));
                }
            }
        }
        return statements;
    }

    private final void execStatements(Transaction $this$execStatements, boolean inBatch, List<String> statements) {
        if (inBatch) {
            $this$execStatements.execInBatch(statements);
        } else {
            for (String statement : statements) {
                Transaction.exec$default($this$execStatements, statement, null, null, 6, null);
            }
        }
    }

    public final <T extends Table> void create(@NotNull T[] tables, boolean inBatch) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$create_u24lambda_u2d23 = transaction2;
        boolean bl3 = false;
        INSTANCE.execStatements($this$create_u24lambda_u2d23, inBatch, INSTANCE.createStatements((Table[])Arrays.copyOf(tables, tables.length)));
        $this$create_u24lambda_u2d23.commit();
        DefaultKt.getCurrentDialect().resetCaches();
    }

    public static /* synthetic */ void create$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.create(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createDatabase(@NotNull String[] databases, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$createDatabase_u24lambda_u2d25 = transaction2;
        boolean bl3 = false;
        String[] $this$flatMap$iv = databases;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var13_13 = $this$flatMapTo$iv$iv;
        int n = ((void)var13_13).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var13_13[i];
            boolean bl4 = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().createDatabase((String)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$createDatabase_u24lambda_u2d25, inBatch, createStatements);
    }

    public static /* synthetic */ void createDatabase$default(SchemaUtils schemaUtils, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createDatabase(stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropDatabase(@NotNull String[] databases, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)databases, (String)"databases");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$dropDatabase_u24lambda_u2d27 = transaction2;
        boolean bl3 = false;
        String[] $this$flatMap$iv = databases;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var13_13 = $this$flatMapTo$iv$iv;
        int n = ((void)var13_13).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var13_13[i];
            boolean bl4 = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().dropDatabase((String)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$dropDatabase_u24lambda_u2d27, inBatch, createStatements);
    }

    public static /* synthetic */ void dropDatabase$default(SchemaUtils schemaUtils, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.dropDatabase(stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createMissingTablesAndColumns(@NotNull Table[] tables, boolean inBatch) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$createMissingTablesAndColumns_u24lambda_u2d34 = transaction2;
        boolean bl3 = false;
        $this$createMissingTablesAndColumns_u24lambda_u2d34.getDb().getDialect().resetCaches();
        String message$iv = "Preparing create tables statements";
        boolean $i$f$logTimeSpent = false;
        long start$iv = System.currentTimeMillis();
        boolean bl4 = false;
        List<String> answer$iv = INSTANCE.createStatements(Arrays.copyOf(tables, tables.length));
        SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        List<String> createStatements = answer$iv;
        message$iv = "Executing create tables statements";
        $i$f$logTimeSpent = false;
        start$iv = System.currentTimeMillis();
        boolean bl5 = false;
        INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d34, inBatch, createStatements);
        $this$createMissingTablesAndColumns_u24lambda_u2d34.commit();
        Unit answer$iv2 = Unit.INSTANCE;
        SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        String message$iv2 = "Preparing alter table statements";
        boolean $i$f$logTimeSpent2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl6 = false;
        List<String> answer$iv22 = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tables, tables.length));
        SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
        List<String> alterStatements = answer$iv22;
        message$iv2 = "Executing alter table statements";
        $i$f$logTimeSpent2 = false;
        start$iv2 = System.currentTimeMillis();
        boolean bl7 = false;
        INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d34, inBatch, alterStatements);
        $this$createMissingTablesAndColumns_u24lambda_u2d34.commit();
        Unit answer$iv3 = Unit.INSTANCE;
        SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
        List executedStatements = CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements);
        String message$iv3 = "Checking mapping consistence";
        boolean $i$f$logTimeSpent3 = false;
        long start$iv3 = System.currentTimeMillis();
        boolean bl8 = false;
        Iterable $this$filter$iv = QueriesKt.checkMappingConsistence(Arrays.copyOf(tables, tables.length));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl9 = false;
            if (!(!executedStatements.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifyTablesStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2d34, inBatch, modifyTablesStatements);
        $this$createMissingTablesAndColumns_u24lambda_u2d34.commit();
        Unit answer$iv4 = Unit.INSTANCE;
        SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv3) + "ms");
        $this$createMissingTablesAndColumns_u24lambda_u2d34.getDb().getDialect().resetCaches();
    }

    public static /* synthetic */ void createMissingTablesAndColumns$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createMissingTablesAndColumns(tableArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void withDataBaseLock(@NotNull Transaction $this$withDataBaseLock, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter((Object)$this$withDataBaseLock, (String)"<this>");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Table buzyTable2 = new Table(){
            @NotNull
            private final Column<Boolean> busy;
            {
                this.busy = Table.uniqueIndex$default((Table)this, this.bool("busy"), null, 1, null);
            }

            @NotNull
            public final Column<Boolean> getBusy() {
                return this.busy;
            }
        };
        withDataBaseLock.buzyTable.1[] nullArray = new withDataBaseLock.buzyTable.1[]{buzyTable2};
        SchemaUtils.create$default(this, nullArray, false, 2, null);
        boolean isBusy = CollectionsKt.any((Iterable)QueriesKt.selectAll(buzyTable2).forUpdate());
        if (!isBusy) {
            QueriesKt.insert((Table)buzyTable2, (Function2)new Function2<withDataBaseLock.buzyTable.1, InsertStatement<Number>, Unit>(buzyTable2){
                final /* synthetic */ withDataBaseLock.buzyTable.1 $buzyTable;
                {
                    this.$buzyTable = $buzyTable;
                    super(2);
                }

                public final void invoke(@NotNull withDataBaseLock.buzyTable.1 $this$insert, @NotNull InsertStatement<Number> it) {
                    Intrinsics.checkNotNullParameter((Object)$this$insert, (String)"$this$insert");
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.set(this.$buzyTable.getBusy(), true);
                }
            });
            try {
                body.invoke();
            }
            finally {
                QueriesKt.deleteAll(buzyTable2);
                $this$withDataBaseLock.getConnection().commit();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drop(@NotNull Table[] tables, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Table it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Object object = tables;
        boolean bl = false;
        if (((Table[])object).length == 0) {
            return;
        }
        object = TransactionManager.Companion.current();
        bl = false;
        boolean bl2 = false;
        Object $this$drop_u24lambda_u2d38 = object;
        boolean bl3 = false;
        Iterable iterable = CollectionsKt.reversed((Iterable)INSTANCE.sortTablesByReferences(ArraysKt.toList((Object[])tables)));
        boolean $i$f$filter = false;
        void var10_11 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Table)element$iv$iv;
            boolean bl4 = false;
            if (!ArraysKt.contains((Object[])tables, (Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesForDeletion = (List)destination$iv$iv;
        if (!DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$filter$iv = tablesForDeletion;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Table)element$iv$iv;
                boolean bl5 = false;
                if (!QueriesKt.exists(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tablesForDeletion = (List)destination$iv$iv;
        }
        Iterable $this$flatMap$iv = tablesForDeletion;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Table it2 = (Table)element$iv$iv;
            boolean bl6 = false;
            Iterable list$iv$iv = it2.dropStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements((Transaction)$this$drop_u24lambda_u2d38, inBatch, dropStatements);
        DefaultKt.getCurrentDialect().resetCaches();
    }

    public static /* synthetic */ void drop$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.drop(tableArray, bl);
    }

    public final void setSchema(@NotNull Schema schema, boolean inBatch) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Transaction transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$setSchema_u24lambda_u2d39 = transaction2;
        boolean bl3 = false;
        List<String> createStatements = schema.setSchemaStatement();
        INSTANCE.execStatements($this$setSchema_u24lambda_u2d39, inBatch, createStatements);
        DatabaseDialect databaseDialect = DefaultKt.getCurrentDialect();
        if (databaseDialect instanceof MysqlDialect) {
            $this$setSchema_u24lambda_u2d39.getConnection().setCatalog(schema.getIdentifier());
        } else if (databaseDialect instanceof H2Dialect) {
            $this$setSchema_u24lambda_u2d39.getConnection().setSchema(schema.getIdentifier());
        }
        DefaultKt.getCurrentDialect().resetCaches();
        $this$setSchema_u24lambda_u2d39.getConnection().metadata(setSchema.1.1.INSTANCE);
    }

    public static /* synthetic */ void setSchema$default(SchemaUtils schemaUtils, Schema schema, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.setSchema(schema, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSchema(@NotNull Schema[] schemas, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schemas, (String)"schemas");
        Object object = schemas;
        boolean bl = false;
        if (((Schema[])object).length == 0) {
            return;
        }
        object = TransactionManager.Companion.current();
        bl = false;
        boolean bl2 = false;
        Object $this$createSchema_u24lambda_u2d42 = object;
        boolean bl3 = false;
        Iterable $this$filterNot$iv = ArraysKt.distinct((Object[])schemas);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl4 = false;
            if (it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toCreate = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = toCreate;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements((Transaction)$this$createSchema_u24lambda_u2d42, inBatch, createStatements);
        ((Transaction)$this$createSchema_u24lambda_u2d42).commit();
        DefaultKt.getCurrentDialect().resetSchemaCaches();
    }

    public static /* synthetic */ void createSchema$default(SchemaUtils schemaUtils, Schema[] schemaArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createSchema(schemaArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropSchema(@NotNull Schema[] schemas, boolean cascade, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Iterable destination$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)schemas, (String)"schemas");
        Object object = schemas;
        boolean bl = false;
        if (((Schema[])object).length == 0) {
            return;
        }
        object = TransactionManager.Companion.current();
        bl = false;
        boolean bl2 = false;
        Object $this$dropSchema_u24lambda_u2d45 = object;
        boolean bl3 = false;
        if (DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            list = ArraysKt.distinct((Object[])schemas);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ArraysKt.distinct((Object[])schemas);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Schema it = (Schema)element$iv$iv;
                boolean bl4 = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List schemasForDeletion = list;
        Iterable $this$flatMap$iv = schemasForDeletion;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = it.dropStatement(cascade);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements((Transaction)$this$dropSchema_u24lambda_u2d45, inBatch, dropStatements);
        DefaultKt.getCurrentDialect().resetSchemaCaches();
    }

    public static /* synthetic */ void dropSchema$default(SchemaUtils schemaUtils, Schema[] schemaArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        schemaUtils.dropSchema(schemaArray, bl, bl2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012R)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils$TableDepthGraph;", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "(Ljava/lang/Iterable;)V", "graph", "", "", "getGraph", "()Ljava/util/Map;", "getTables", "()Ljava/lang/Iterable;", "fetchAllTables", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hasCycle", "sorted", "", "exposed-core"})
    private static final class TableDepthGraph {
        @NotNull
        private final Iterable<Table> tables;
        @NotNull
        private final Map<Table, Map<Table, Boolean>> graph;

        /*
         * WARNING - void declaration
         */
        public TableDepthGraph(@NotNull Iterable<? extends Table> tables) {
            Map map;
            void tables2;
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            this.tables = tables;
            HashSet<Table> hashSet = this.fetchAllTables();
            boolean bl = false;
            boolean bl2 = false;
            HashSet<Table> hashSet2 = hashSet;
            TableDepthGraph tableDepthGraph = this;
            boolean bl3 = false;
            if (tables2.isEmpty()) {
                map = MapsKt.emptyMap();
            } else {
                Iterable $this$associateWith$iv = (Iterable)tables2;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void $this$mapNotNullTo$iv$iv;
                    void t;
                    Table table = (Table)element$iv$iv;
                    Object t2 = element$iv$iv;
                    Map map2 = result$iv;
                    boolean bl4 = false;
                    Iterable $this$mapNotNull$iv = t.getColumns();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Pair pair;
                        Object element$iv$iv$iv;
                        Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                        boolean bl5 = false;
                        Column c = (Column)element$iv$iv2;
                        boolean bl6 = false;
                        Column<?> column = c.getReferee();
                        if (column == null) {
                            pair = null;
                        } else {
                            Column<?> column2 = column;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            Column<?> it = column2;
                            boolean bl9 = false;
                            pair = TuplesKt.to((Object)it.getTable(), (Object)c.getColumnType().getNullable());
                        }
                        if (pair == null) continue;
                        Pair pair2 = pair;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        Pair it$iv$iv = pair2;
                        boolean bl12 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Map map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    map2.put(t2, map3);
                }
                map = result$iv;
            }
            Map map4 = map;
            tableDepthGraph.graph = map4;
        }

        @NotNull
        public final Iterable<Table> getTables() {
            return this.tables;
        }

        @NotNull
        public final Map<Table, Map<Table, Boolean>> getGraph() {
            return this.graph;
        }

        private final HashSet<Table> fetchAllTables() {
            HashSet<Table> result = new HashSet<Table>();
            Iterable<Table> $this$forEach$iv = this.tables;
            boolean $i$f$forEach = false;
            Iterator<Table> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Table element$iv;
                Table p0 = element$iv = iterator2.next();
                boolean bl = false;
                TableDepthGraph.fetchAllTables$parseTable(result, p0);
            }
            return result;
        }

        @NotNull
        public final List<Table> sorted() {
            if (!this.tables.iterator().hasNext()) {
                return CollectionsKt.emptyList();
            }
            boolean bl = false;
            Set visited = new LinkedHashSet();
            boolean bl2 = false;
            ArrayList<Table> result = new ArrayList<Table>();
            Iterable<Table> $this$forEach$iv = this.tables;
            boolean $i$f$forEach = false;
            Iterator<Table> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Table element$iv;
                Table p0 = element$iv = iterator2.next();
                boolean bl3 = false;
                TableDepthGraph.sorted$traverse(visited, this, result, p0);
            }
            return result;
        }

        public final boolean hasCycle() {
            boolean bl;
            block4: {
                if (!this.tables.iterator().hasNext()) {
                    return false;
                }
                boolean bl2 = false;
                Set visited = new LinkedHashSet();
                boolean bl3 = false;
                Set recursion = new LinkedHashSet();
                List<Table> sortedTables = this.sorted();
                Iterable $this$any$iv = sortedTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Table it = (Table)element$iv;
                        boolean bl4 = false;
                        if (!TableDepthGraph.hasCycle$traverse-9(recursion, visited, this, it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final void fetchAllTables$parseTable(HashSet<Table> result, Table table) {
            if (result.add(table)) {
                Iterable $this$forEach$iv = table.getColumns();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Table table2;
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    Column<?> column = it.getReferee();
                    if (column == null || (table2 = column.getTable()) == null) continue;
                    Table table3 = table2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Table p0 = table3;
                    boolean bl4 = false;
                    TableDepthGraph.fetchAllTables$parseTable(result, p0);
                }
            }
        }

        private static final void sorted$traverse(Set<Table> visited, TableDepthGraph this$0, ArrayList<Table> result, Table table) {
            if (!visited.contains(table)) {
                Collection collection = visited;
                boolean bl = false;
                collection.add(table);
                Map $this$forEach$iv = (Map)MapsKt.getValue(this$0.graph, (Object)table);
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl2 = false;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry $dstr$t$_u24__u24 = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Map.Entry entry = $dstr$t$_u24__u24;
                    boolean bl4 = false;
                    Table t = (Table)entry.getKey();
                    if (visited.contains(t)) continue;
                    TableDepthGraph.sorted$traverse(visited, this$0, result, t);
                }
                collection = result;
                bl = false;
                collection.add(table);
            }
        }

        private static final boolean hasCycle$traverse-9(Set<Table> recursion, Set<Table> visited, TableDepthGraph this$0, Table table) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Collection collection;
            block7: {
                if (recursion.contains(table)) {
                    return true;
                }
                if (visited.contains(table)) {
                    return false;
                }
                collection = recursion;
                bl3 = false;
                collection.add(table);
                collection = visited;
                bl3 = false;
                collection.add(table);
                Map<Table, Boolean> map = this$0.graph.get(table);
                Intrinsics.checkNotNull(map);
                Map<Table, Boolean> $this$any$iv = map;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Map<Table, Boolean> map2 = $this$any$iv;
                    boolean bl4 = false;
                    Iterator<Map.Entry<Table, Boolean>> iterator2 = map2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<Table, Boolean> element$iv;
                        Map.Entry<Table, Boolean> it = element$iv = iterator2.next();
                        boolean bl5 = false;
                        if (!TableDepthGraph.hasCycle$traverse-9(recursion, visited, this$0, it.getKey())) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                bl = true;
            } else {
                collection = recursion;
                bl3 = false;
                collection.remove(table);
                bl = false;
            }
            return bl;
        }
    }
}

