/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/sql/DecimalColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "precision", "", "scale", "(II)V", "getPrecision", "()I", "getScale", "equals", "", "other", "", "hashCode", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "sqlType", "", "valueFromDB", "Ljava/math/BigDecimal;", "value", "Companion", "exposed-core"})
public final class DecimalColumnType
extends ColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int precision;
    private final int scale;
    @NotNull
    private static final DecimalColumnType INSTANCE = new DecimalColumnType(MathContext.DECIMAL64.getPrecision(), 20);

    public DecimalColumnType(int precision, int scale) {
        super(false, 1, null);
        this.precision = precision;
        this.scale = scale;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    @Override
    @NotNull
    public String sqlType() {
        return "DECIMAL(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getBigDecimal(index);
    }

    @Override
    @NotNull
    public BigDecimal valueFromDB(@NotNull Object value) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)value;
        } else if (object instanceof Double) {
            double d = ((Number)value).doubleValue();
            boolean bl = false;
            if (Double.isNaN(d)) {
                String string = Intrinsics.stringPlus((String)"Unexpected value of type Double: NaN of ", (Object)Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName());
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            d = ((Number)value).doubleValue();
            bl = false;
            bigDecimal = new BigDecimal(String.valueOf(d));
        } else if (object instanceof Float) {
            float f = ((Number)value).floatValue();
            boolean bl = false;
            if (Float.isNaN(f)) {
                String string = Intrinsics.stringPlus((String)"Unexpected value of type Float: NaN of ", (Object)Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName());
                bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            f = ((Number)value).floatValue();
            bl = false;
            bigDecimal = new BigDecimal(String.valueOf(f));
        } else if (object instanceof Long) {
            long l = ((Number)value).longValue();
            boolean bl = false;
            BigDecimal bigDecimal2 = BigDecimal.valueOf(l);
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"BigDecimal.valueOf(this)");
        } else if (object instanceof Integer) {
            int n = ((Number)value).intValue();
            boolean bl = false;
            BigDecimal bigDecimal3 = BigDecimal.valueOf(n);
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"BigDecimal.valueOf(this.toLong())");
        } else {
            String string = "Unexpected value of type Decimal: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BigDecimal bigDecimal4 = bigDecimal.setScale(this.scale, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"when (value) {\n        is BigDecimal -> value\n        is Double -> {\n            if (value.isNaN())\n                error(\"Unexpected value of type Double: NaN of ${value::class.qualifiedName}\")\n            else\n                value.toBigDecimal()\n        }\n        is Float -> {\n            if (value.isNaN())\n                error(\"Unexpected value of type Float: NaN of ${value::class.qualifiedName}\")\n            else\n                value.toBigDecimal()\n        }\n        is Long -> value.toBigDecimal()\n        is Int -> value.toBigDecimal()\n        else -> error(\"Unexpected value of type Decimal: $value of ${value::class.qualifiedName}\")\n    }.setScale(scale, RoundingMode.HALF_EVEN)");
        return bigDecimal4;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.exposed.sql.DecimalColumnType");
        }
        DecimalColumnType cfr_ignored_0 = (DecimalColumnType)other;
        if (this.precision != ((DecimalColumnType)other).precision) {
            return false;
        }
        return this.scale == ((DecimalColumnType)other).scale;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/DecimalColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/DecimalColumnType;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/sql/DecimalColumnType;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecimalColumnType getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

