/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.vc;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.XMLValidatorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Paths;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DraftStructureValidator {
    public void runDraftValidation(String FilePath) throws XMLValidatorException {
        String type = this.draftDtdOrXsd(FilePath);
        if (type.equals("DTD")) {
            this.runDraftValidationWithDtd(FilePath);
        } else if (type.equals("XSD")) {
            this.runDraftValidationWithXsd(FilePath);
        } else if (type.equals("ERR")) {
            throw new XMLValidatorException("ERROR: Could not decide if need XSD validation or DTD validation.");
        }
    }

    private String draftDtdOrXsd(String FilePath) {
        String type = "";
        try (BufferedReader reader = FileUtils.createNewBufferedReader(Paths.get(FilePath, new String[0]));){
            int lineNum = 0;
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.contains("Folder.xsd")) {
                    type = "XSD";
                } else if (line.contains("deftable.dtd")) {
                    type = "DTD";
                } else {
                    if (lineNum++ <= 5) continue;
                    type = "ERR";
                }
                break;
            }
        }
        catch (Exception e) {
            String msg = String.format("Error: File %s were not found.", FilePath);
            ConversionLogger.getLogger().severe(msg);
            ExceptionHandler.writeToExceptionFile(e);
            type = "ERR";
        }
        return type;
    }

    private void runDraftValidationWithXsd(String FilePath) throws XMLValidatorException {
        try (Reader reader = FileUtils.createNewReader(Paths.get(FilePath, new String[0]));){
            StreamSource xmlFile = new StreamSource(reader);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File(Globs.XML_VALIDATAION_DIR + Globs.DIRSEP + "data" + Globs.DIRSEP + "Resource" + Globs.DIRSEP + "Folder.xsd"));
            Validator validator = schema.newValidator();
            DraftParseErrorHandler dpeh = new DraftParseErrorHandler(this);
            validator.setErrorHandler(dpeh);
            validator.validate(xmlFile);
            if (dpeh.getNumOfErrors() > 0) {
                ConversionLogger.getLogger().info("Xsd Validator got: " + String.valueOf(dpeh.getNumOfErrors()) + " validation Errors!");
                throw new XMLValidatorException(TextManager.instance().get("EVALUATION_PANEL_XML_VALIDATION_FAILED_MESSAGE"));
            }
        }
        catch (Exception e) {
            ConversionLogger.getLogger().severe(e.getMessage() + " " + String.valueOf(e.getCause()));
            String messageBoxValidationFailed = TextManager.instance().get("EVALUATION_PANEL_XML_VALIDATION_FAILED_MESSAGE");
            throw new XMLValidatorException(messageBoxValidationFailed);
        }
    }

    private void runDraftValidationWithDtd(String filePathName) throws XMLValidatorException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            SAXParser parser = saxParserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new EntityResolver(this){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.contains("deftable.dtd")) {
                        return new InputSource(new FileReader(Globs.XML_VALIDATAION_DIR + Globs.DIRSEP + "data" + Globs.DIRSEP + "Resource" + Globs.DIRSEP + "deftable.dtd"));
                    }
                    System.err.println("Ignoring " + publicId + ", " + systemId);
                    String msg = String.format("Error: File deftable.dtd were not found in %s.", Globs.XML_VALIDATAION_DIR + Globs.DIRSEP + "data" + Globs.DIRSEP + "Resource");
                    ConversionLogger.getLogger().severe(msg);
                    return new InputSource(new StringReader(""));
                }
            });
            DraftParseErrorHandler dpeh = new DraftParseErrorHandler(this);
            reader.setErrorHandler(dpeh);
            reader.parse(new InputSource(filePathName));
            if (dpeh.getNumOfErrors() > 0) {
                ConversionLogger.getLogger().info("Dtd Validator got: " + String.valueOf(dpeh.getNumOfErrors()) + " validation Errors!");
                throw new XMLValidatorException(TextManager.instance().get("EVALUATION_PANEL_XML_VALIDATION_FAILED_MESSAGE"));
            }
        }
        catch (Exception e) {
            ConversionLogger.getLogger().severe(e.getMessage() + " " + String.valueOf(e.getCause()));
            String messageBoxValidationFailed = TextManager.instance().get("EVALUATION_PANEL_XML_VALIDATION_FAILED_MESSAGE");
            throw new XMLValidatorException(messageBoxValidationFailed);
        }
    }

    class DraftParseErrorHandler
    implements ErrorHandler {
        private int numOfErrors = 0;

        DraftParseErrorHandler(DraftStructureValidator this$0) {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXParseException {
            String msg = "Fatal Error: " + e.getMessage() + " at " + e.getLineNumber() + " line.";
            ConversionLogger.getLogger().severe(msg);
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            String msg = "Error: " + e.getMessage() + " at " + e.getLineNumber() + " line.";
            ConversionLogger.getLogger().severe(msg);
            ++this.numOfErrors;
        }

        @Override
        public void warning(SAXParseException e) throws SAXParseException {
            String msg = "Warning: " + e.getMessage() + " at " + e.getLineNumber() + " line.";
            ConversionLogger.getLogger().warning(msg);
        }

        public int getNumOfErrors() {
            return this.numOfErrors;
        }
    }
}

