/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.services;

import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.interfaces.VendorData;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VendorDataManager {
    public static final String APPLICATIONS = "Applications";
    public static final String SCHEDULERS = "Schedulers";
    private static VendorDataManager instance;
    private Map<String, VendorData> schedulersDataMap;
    private Map<String, VendorData> applicationsDataMap;

    static void setVendorDataForTestRememberToCleanup(VendorDataManager newInstance) {
        instance = newInstance;
    }

    public static VendorDataManager instance() {
        if (instance == null) {
            instance = new VendorDataManager();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public VendorData getVendorData(String vendor) {
        VendorData toRet = this.schedulersDataMap.get(vendor);
        if (toRet == null) {
            toRet = this.applicationsDataMap.get(vendor);
        }
        return toRet;
    }

    public VendorData getVendorData() {
        Properties projectProperties = Params.instance().getProjectProperties();
        if (projectProperties == null) {
            return VendorData.NULL;
        }
        return this.getVendorData(projectProperties.getProperty("VENDOR"));
    }

    public List<Properties> getVendorsList() {
        Properties prop;
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        for (VendorData data : this.schedulersDataMap.values()) {
            prop = new Properties();
            prop.put("ID", data.getName());
            prop.put("NAME", data.getDisplayName());
            prop.put("GROUP", data.getVendorType().toString());
            prop.put("GROUP_PRIORITY_AND_NAME", this.getTypePriority(data.getVendorType()) + "_" + data.getDisplayName());
            toRet.add(prop);
        }
        for (VendorData data : this.applicationsDataMap.values()) {
            prop = new Properties();
            prop.put("ID", data.getName());
            prop.put("NAME", data.getDisplayName());
            prop.put("GROUP", data.getVendorType().toString());
            prop.put("GROUP_PRIORITY_AND_NAME", this.getTypePriority(data.getVendorType()) + "_" + data.getDisplayName());
            toRet.add(prop);
        }
        return toRet;
    }

    public Integer getTypePriority(VendorData.VendorType vendorType) {
        switch (vendorType) {
            case Applications: {
                return 1;
            }
            case Other: {
                return 2;
            }
        }
        return 0;
    }

    public DataImportVendor getDataImport(String vendor) {
        return this.getVendorData(vendor).getDataImport();
    }

    public Dimension getDataImportDialogSize(String vendor) {
        return this.getVendorData(vendor).getSize();
    }

    public CliImporter getCLIImporter(String vendor) {
        return this.getVendorData(vendor).getCLIImporter();
    }

    public BasePanel getAssessmentReport(String vendor, String path) {
        return this.getVendorData(vendor).getAssessmentReport(path);
    }

    public SourceDefinitions getSourceDefinitions(String vendor, BaseProgressBar progressBar) throws ConvertorCancelClickException {
        return this.getVendorData(vendor).getSourceDefinition(progressBar);
    }

    public VendorDataManager() {
        this.init();
    }

    void init() {
        this.schedulersDataMap = this.getModules(SCHEDULERS);
        this.applicationsDataMap = this.getModules(APPLICATIONS);
    }

    Map<String, VendorData> removedVendorsThatShouldNotBeLoaded(Map<String, VendorData> dataMap) {
        return dataMap.entrySet().stream().filter(d -> ((VendorData)d.getValue()).shouldBeLoaded()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, VendorData> getModules(String moduleType) {
        String modulePath = Globs.HOME_DIR + Globs.DIRSEP + "lib" + Globs.DIRSEP + moduleType;
        File modulesDir = this.createFolderIfNotExists(modulePath);
        return this.removedVendorsThatShouldNotBeLoaded(this.createVendorDataMap(modulesDir));
    }

    private File createFolderIfNotExists(String path) {
        try {
            GlobalFunctions.createDirectoryIfNotExist(path);
            return new File(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, VendorData> createVendorDataMap(File directory) {
        Collection<File> modulesFromTargetDirectory = this.getModulesFromTargetDirectory(directory);
        HashMap<String, VendorData> map = new HashMap<String, VendorData>();
        Collection<File> modules = modulesFromTargetDirectory.isEmpty() ? this.getModulesFromLibDirectory(directory) : modulesFromTargetDirectory;
        for (File module : modules) {
            try {
                URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{module.toURI().toURL()});
                Class<?> cls = classLoader.loadClass("com.bmc.ctmconvert.AppData");
                Object appData = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(appData instanceof VendorData)) continue;
                VendorData vendorData = (VendorData)appData;
                map.put(vendorData.getName(), vendorData);
            }
            catch (IllegalAccessException | MalformedURLException e) {
                ExceptionHandler.writeToExceptionFile(e);
            }
            catch (ClassNotFoundException e) {
                ConversionLogger.getLogger().info(module.getName() + ": Does not have AppData.");
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ConversionLogger.getLogger().info(module.getName() + ": Unable to instantiate AppData.");
            }
            catch (NoClassDefFoundError e) {
                ConversionLogger.getLogger().info(module.getName() + ": Unable to find instance class of AppData.");
                ExceptionHandler.writeToExceptionFile(e.getMessage());
            }
        }
        return map;
    }

    private List<File> getModulesFromLibDirectory(File directory) {
        return Optional.ofNullable(directory.listFiles()).map(Arrays::asList).orElseThrow(() -> new RuntimeException("No vendors were found in the folder " + directory.getAbsolutePath()));
    }

    private Collection<File> getModulesFromTargetDirectory(File directory) {
        Collection collection;
        block8: {
            Stream<Path> projects = Files.list(Paths.get("..", new String[0]));
            try {
                collection = projects.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(dir -> dir.resolve("target").resolve("classes")).filter(classesDir -> Files.exists(classesDir.resolve("com").resolve("bmc").resolve("ctmconvert").resolve("AppData.class"), new LinkOption[0])).filter(this.schedulersOrApplication(directory)).map(Path::toFile).collect(Collectors.toList());
                if (projects == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (projects != null) {
                        try {
                            projects.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            projects.close();
        }
        return collection;
    }

    private Predicate<Path> schedulersOrApplication(File directory) {
        Predicate<Path> isApplication = file -> file.toString().startsWith("..\\Application-");
        return APPLICATIONS.equals(directory.getName()) ? isApplication : isApplication.negate();
    }

    public DataObject getDataObject() {
        return this.getVendorData().getDataObject();
    }
}

