/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.scriptelement;

import com.bmc.ctmconvert.api.FileWatcherParametersAPI;
import com.bmc.ctmconvert.api.SapBWParametersAPI;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmJobBaseApi;
import com.bmc.ctmconvert.scriptelement.CtmXmlElement;
import com.bmc.ctmconvert.workspace.entities.BaseJob;
import com.bmc.ctmconvert.workspace.entities.QuantitativeResource;
import com.bmc.ctmconvert.workspace.entities.Variable;

public class CtmJob
extends BaseJob
implements CtmJobBaseApi,
Cloneable {
    private final CtmXmlElement jobInputXmlData;
    private Integer fileTransferCounter = 0;
    private Integer sapStepsCounter = 0;

    public CtmJob(CtmXmlElement jobInputXmlData) {
        this.jobInputXmlData = jobInputXmlData;
    }

    public void setDatabasesType() {
        this.addAttribute("TASKTYPE", "Job");
        this.addAttribute("APPL_TYPE", "DATABASE");
        this.addAttribute("APPL_FORM", "Databases");
        this.addAttribute("CM_VER", "N/A");
        this.setVariable("%%DB-EXEC_TYPE", "Stored Procedure");
        this.setVariable("%%DB-AUTOCOMMIT", "N");
        this.setVariable("%%DB-CSV_SEPERATOR", ",");
        this.setVariable("%%DB-SSIS_PACKAGE_SOURCE", "SQL Server");
        this.setVariable("%%DB-APPEND_LOG", "Y");
        this.setVariable("%%DB-APPEND_OUTPUT", "N");
        this.setVariable("%%DB-OUTPUT_FORMAT", "Text");
        this.setVariable("%%DB-STP_PACKAGE", "*");
    }

    public void setAirflowType() {
        this.addAttribute("TASKTYPE", "Job");
        this.addAttribute("APPL_TYPE", "AFL");
        this.addAttribute("APPL_FORM", "Airflow");
        this.addAttribute("CM_VER", "9.0.21");
        this.setVariable("%%AFL-OUTPUT_MODE", "FAILED_TASKS");
        this.setVariable("%%AFL-RERUN_POF", "False");
    }

    public void setDummyType() {
        this.removeAttribute("APPL_FORM");
        this.removeAttribute("APPL_VER");
        this.removeAttribute("CM_VER");
        this.removeAttribute("APPL_TYPE");
        this.addAttribute("APPL_FORM", "");
        this.addAttribute("APPL_VER", "");
        this.addAttribute("CM_VER", "");
        this.addAttribute("APPL_TYPE", "");
        this.general().enableRunAsDummy();
    }

    public void setOsType() {
        this.addAttribute("APPL_FORM", "");
        this.addAttribute("APPL_VER", "");
        this.addAttribute("CM_VER", "");
        this.addAttribute("APPL_TYPE", "OS");
        this.addAttribute("TASKTYPE", "Job");
    }

    public void setOs2200Type() {
        this.addAttribute("APPL_VER", "");
        this.addAttribute("CM_VER", "");
        this.addAttribute("MEMLIB", "");
        this.addAttribute("MEMNAME", "");
        this.addAttribute("OVERLIB", "");
        this.addVariable(new Variable("%%OS2200-JOB_OWNER", ""));
        this.addAttribute("APPL_FORM", "OS2200");
        this.addAttribute("APPL_TYPE", "OS2200");
        this.addAttribute("TASKTYPE", "Job");
        this.addAttribute("USE_INSTREAM_JCL", "N");
        this.addVariable(new Variable("%%OS2200-AEV_LEN", "4000"));
    }

    public void setInformaticaType() {
        this.addAttribute("APPL_TYPE", "ETL_INFA");
        this.addAttribute("APPL_FORM", "Informatica");
        this.addAttribute("APPL_VER", "9.0.00");
        this.addAttribute("CM_VER", "N/A");
        this.addAttribute("TASKTYPE", "Job");
        this.setVariable("%%INF-EXEC_TYPE", "Informatica Workflow");
        this.setVariable("%%INF-DEPTH", "10");
        this.setVariable("%%INF-WORKFLOW_EXE_MODE", "WHOLE");
        this.setVariable("%%INF-WORKFLOW_RESTART_MODE", "RECOVER");
        this.setVariable("%%INF-ENABLE_OUTPUT", "X");
        this.setVariable("%%INF-ENABLE_ERROR_DETAILS", "X");
        this.setVariable("%%INF-FORCE_RESTART", "N");
    }

    public void setSapR3Type() {
        this.addAttribute("TASKTYPE", "Job");
        Globs.SAP_TYPE_FORM_VERSION.forEach(this::addAttribute);
        this.setVariable("%%SAPR3-JOBNAME", this.general().getName());
        this.setVariable("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        this.setVariable("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        this.setVariable("%%SAPR3-JOB_MODE", "CREATE");
        this.setVariable("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.setVariable("%%SAPR3-JOBCLASS", "C");
        this.setVariable("%%SAPR3-JOB_COUNT", "FIRST_SCHEDULED");
        this.setVariable("%%SAPR3-JOBCOUNT", "FIRST_SCHEDULED");
        this.setVariable("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.setVariable("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.setVariable("%%SAPR3-JOBLOG", "*SYSOUT");
        this.setVariable("%%SAPR3-SUBMIT_ASAP", "X");
        this.setVariable("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.setVariable("%%SAPR3-DETECT_OPTION", "1");
        this.setVariable("%%SAPR3-INC_APP_STAT", "no");
        this.setVariable("%%SAPR3-RERUN_STEP_NUM", "1");
        this.setVariable("%%SAPR3-RECIP_TYPE", "B");
        this.setVariable("%%SAPR3-RECIP_COPY", "N");
        this.setVariable("%%SAPR3-RECIP_BLIND_COPY", "N");
        this.setVariable("%%SAPR3-RECIP_EXPRESS", "N");
        this.setVariable("%%SAPR3-RECIP_NO_FORWARDING", "N");
        this.setVariable("%%SAPR3-RERUN_FROM_POF", "N");
    }

    public void setSapBWType() {
        this.addAttribute("TASKTYPE", "Job");
        SapBWParametersAPI sapBWParametersAPI = new SapBWParametersAPI(this);
        sapBWParametersAPI.convertToSapJob();
    }

    public void setFileTransferType() {
        this.addAttribute("TASKTYPE", "Job");
        this.addAttribute("APPL_TYPE", "FILE_TRANS");
        this.addAttribute("APPL_VER", "9.0.00");
        this.addAttribute("APPL_FORM", "AFT");
        this.addAttribute("CM_VER", "610");
        this.setVariable("%%FTP-UPLOAD1", "1");
        this.setVariable("%%FTP-TRANSFER_NUM", "1");
    }

    public void setFileWatcherType() {
        new FileWatcherParametersAPI(this).initDefaults();
    }

    public void setTaskType(String taskType) {
        this.addAttribute("TASKTYPE", taskType);
    }

    public String getTaskType() {
        return this.getAttribute("TASKTYPE");
    }

    public void setHost(String host) {
        this.addAttribute("NODEID", host);
    }

    public String getHost() {
        return this.getAttribute("NODEID");
    }

    @Override
    public CtmXmlElement getJobInputXmlData() {
        return this.jobInputXmlData;
    }

    public Integer getFileTransferCounter() {
        return this.fileTransferCounter;
    }

    public void incrementFileTransferCounter() {
        Integer n = this.fileTransferCounter;
        this.fileTransferCounter = this.fileTransferCounter + 1;
    }

    public Integer getSapStepsCounter() {
        return this.sapStepsCounter;
    }

    public void incrementSapStepsCounter() {
        Integer n = this.sapStepsCounter;
        this.sapStepsCounter = this.sapStepsCounter + 1;
    }

    @Override
    public CtmBaseEntity getBaseEntity() {
        return this;
    }

    public void setInformaticaRepositoryFolderName(String repoName) {
        this.setVariable("%%INF-REP_FOLDER", repoName);
    }

    public void addQuantitativeResource(String name, String quantity) {
        super.addQuantitativeResource(new QuantitativeResource(name, quantity, "R", "R"));
    }

    public void setInformaticaWorkflowName(String workflowName) {
        this.setVariable("%%INF-WORKFLOW", workflowName);
    }

    public void setInformaticaRunSingleTask(String singleTaskValue) {
        this.setVariable("%%INF-START_FROM_TASK", singleTaskValue);
        this.setVariable("%%INF-WORKFLOW_EXE_MODE", "SINGLE");
    }

    public void setInformaticaConnectionProfile(String connectionProfile) {
        this.setVariable("%%INF-ACCOUNT", connectionProfile);
    }

    @Override
    public CtmJob clone() throws CloneNotSupportedException {
        return (CtmJob)super.clone();
    }
}

