/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.excel;

import com.bmc.ctmconvert.excel.ActionItem;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriter {
    protected XSSFWorkbook excelWorkBook;
    private List<Sheet> sheetList = new ArrayList<Sheet>();
    private Map<Integer, Integer> sheetNumberToCurrentRowNumberMap = new HashMap<Integer, Integer>();
    private final int COLUMN_WIDTH = 7000;
    protected String[] titles;
    protected String[][] headersList;

    public ExcelWriter() {
        this.excelWorkBook = new XSSFWorkbook();
    }

    public void addSheet(String title, String[] headers) {
        XSSFSheet sheet = this.excelWorkBook.createSheet(title);
        this.setColumnWidth((Sheet)sheet);
        XSSFCellStyle headerStyle = this.createStyle(true);
        sheet.createFreezePane(0, 1);
        this.sheetList.add((Sheet)sheet);
        this.sheetNumberToCurrentRowNumberMap.put(this.sheetList.size() - 1, 0);
        int sheetCounter = this.sheetList.size() - 1;
        this.writeRecord(headers, headerStyle, sheetCounter);
    }

    public void addRowsToSheet(List<ActionItem> actionItems, int sheetNumber) {
        if (this.sheetNumberToCurrentRowNumberMap.containsKey(sheetNumber)) {
            for (ActionItem actionItem : actionItems) {
                XSSFCellStyle recordStyle = this.createStyle(false);
                this.writeRecord(actionItem.toObjectArray(), recordStyle, sheetNumber);
            }
        }
    }

    public void writeReport(OutputStream outputStream) throws IOException {
        this.excelWorkBook.write(outputStream);
    }

    private void writeRecord(Object[] rowData, XSSFCellStyle style, int sheetCounter) {
        Row row = this.sheetList.get(this.sheetList.size() - 1).createRow(this.sheetNumberToCurrentRowNumberMap.get(sheetCounter).intValue());
        for (int i = 0; i < rowData.length; ++i) {
            Cell cell = row.createCell(i);
            if (rowData[i] instanceof String) {
                cell.setCellValue((String)rowData[i]);
            } else {
                cell.setCellValue((double)((Integer)rowData[i]).intValue());
            }
            cell.setCellStyle((CellStyle)style);
        }
        this.sheetNumberToCurrentRowNumberMap.put(sheetCounter, this.sheetNumberToCurrentRowNumberMap.get(sheetCounter) + 1);
    }

    private XSSFCellStyle createStyle(Boolean isBold) {
        XSSFCellStyle cellStyle = this.excelWorkBook.createCellStyle();
        XSSFFont font = this.excelWorkBook.createFont();
        font.setBold(isBold.booleanValue());
        cellStyle.setFont((Font)font);
        cellStyle.setWrapText(true);
        HorizontalAlignment align = HorizontalAlignment.CENTER;
        cellStyle.setAlignment(align);
        return cellStyle;
    }

    private void setColumnWidth(Sheet sheet) {
        sheet.setColumnWidth(0, 7000);
        sheet.setColumnWidth(1, 7000);
        sheet.setColumnWidth(2, 7000);
        sheet.setColumnWidth(3, 7000);
    }

    public XSSFWorkbook getExcelWorkBook() {
        return this.excelWorkBook;
    }
}

