/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport.dbtableomporter;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.fileimporter.FIleImporter;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;

public class ManualDBTableImporter
extends Importer {
    protected FIleImporter fileImporter;
    protected ImportEntry entry;

    public ManualDBTableImporter(ImportEntry entry) {
        this.entry = entry;
    }

    @Override
    public Progressable.ProgressStatus performImport() {
        Path path = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
        this.fileImporter = new FIleImporter(this.entry, path);
        this.fileImporter.addProgressListener(evt -> this.fireProgressEvent(evt));
        Progressable.ProgressStatus tmpStatus = this.fileImporter.performImport();
        if (this.isStopped()) {
            this.setStatus(Progressable.ProgressStatus.ENDED_STOPED);
        } else if (tmpStatus == Progressable.ProgressStatus.ENDED_FAILURE) {
            this.setStatus(this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
        } else if (tmpStatus == Progressable.ProgressStatus.ENDED_SUCCESS) {
            this.tableHeaderToUpper();
        } else {
            this.setStatus(tmpStatus);
        }
        return this.getStatus();
    }

    @Override
    public String getTitle() {
        return "Copy tables...";
    }

    private void tableHeaderToUpper() {
        Progressable.ProgressStatus tmpStatus = this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE;
        String input = ConversionEntitiesService.getCurrentProjectDataDirectory() + this.entry.getDestinationFileName();
        try (RandomAccessFile file = new RandomAccessFile(input, "rw");){
            String header = file.readLine();
            ConversionLogger.getLogger().info("Fixing table header: Read header");
            if (!header.toUpperCase().equals(header)) {
                ConversionLogger.getLogger().info("Fixing table header: header need to be fixed");
                file.seek(0L);
                file.write(header.toUpperCase().getBytes());
                ConversionLogger.getLogger().info("Fixing table header: done fixing header");
            }
            tmpStatus = Progressable.ProgressStatus.ENDED_SUCCESS;
        }
        catch (FileNotFoundException e1) {
            ConversionLogger.getLogger().log(Level.INFO, String.format("Fixing table header: File '%s' not exist", this.entry.getDestinationFileName()));
            tmpStatus = Progressable.ProgressStatus.ENDED_FAILURE;
        }
        catch (IOException e) {
            ConversionLogger.getLogger().log(Level.INFO, String.format("Fixing table header: Unable to read/write to '%s'", this.entry.getDestinationFileName()));
            tmpStatus = Progressable.ProgressStatus.ENDED_FAILURE;
        }
        this.setStatus(tmpStatus);
    }

    @Override
    public String getID() {
        return this.entry.getID();
    }
}

