/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DirectoryFileImporter
extends Importer {
    protected Path sourceDir;
    protected Path targetDir;

    public DirectoryFileImporter(Path file, Path targetDir) {
        this.sourceDir = file;
        this.targetDir = targetDir;
    }

    protected Progressable.ProgressStatus copyDir() throws IOException {
        if (this.sourceDir != null && Files.exists(this.sourceDir, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(this.sourceDir);){
                List childs = paths.collect(Collectors.toList());
                if (childs != null) {
                    long fileCount = childs.size();
                    this.setProgressMax(fileCount);
                    for (int i = 0; i < childs.size(); ++i) {
                        Path child = (Path)childs.get(i);
                        if (!Files.isRegularFile(child, new LinkOption[0]) || Files.isHidden(child)) continue;
                        ConversionLogger.getLogger().info(String.format("Copy file '%s' started", child.getFileName()));
                        this.setCurrentProgress(i);
                        this.copyFile(child);
                    }
                } else {
                    this.setProgressMax(1L);
                    Path child = this.sourceDir;
                    if (Files.isRegularFile(child, new LinkOption[0])) {
                        ConversionLogger.getLogger().info(String.format("Copy file '%s' started", child.getFileName()));
                        this.setCurrentProgress(1L);
                        this.copyFile(child);
                    }
                }
            }
            this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
        } else {
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
        }
        return this.getStatus();
    }

    @Override
    public Progressable.ProgressStatus performImport() {
        try {
            this.copyDir();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
        }
        return this.getStatus();
    }

    private void copyFile(Path child) {
        Path targetPath = this.targetDir.toAbsolutePath().resolve(child.getFileName());
        try {
            Files.copy(child, targetPath, new CopyOption[0]);
        }
        catch (IOException e) {
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
            ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to copy '%s'", child.getFileName()), e);
            ExceptionHandler.writeToExceptionFile(e);
        }
        ConversionLogger.getLogger().info(String.format("Copy file '%s' ended", child.getFileName()));
    }
}

