/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.dataimport.DirectoryImporter;
import com.bmc.ctmconvert.dataimport.ImportDetails;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.dataimport.dbtableomporter.AutomaticDBTableImporter;
import com.bmc.ctmconvert.dataimport.dbtableomporter.ManualDBTableImporter;
import com.bmc.ctmconvert.dataimport.fileimporter.FIleImporter;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultImporter
extends Importer {
    protected ImportEntryList importEntries;
    protected boolean automatic;
    protected Importer vendorImporter;
    private List<Importer> importersList;
    private List<String> stepList;
    private int stepCount = 0;

    public DefaultImporter(boolean automatic, ImportEntryList importEntries, Importer vendorImporter) {
        this.automatic = automatic;
        this.importEntries = importEntries;
        this.vendorImporter = vendorImporter;
        if (vendorImporter != null) {
            vendorImporter.addProgressListener(evt -> this.fireProgressEvent(evt));
        }
        this.importersList = new ArrayList<Importer>();
    }

    @Override
    public boolean isImportable() {
        boolean importable = true;
        ArrayList<ImportDetails> detailsList = new ArrayList<ImportDetails>();
        ArrayList<ImportEntry> entriesList = new ArrayList<ImportEntry>();
        for (ImportEntry entry : this.importEntries) {
            if (detailsList.contains(entry.getImportDetails())) continue;
            detailsList.add(entry.getImportDetails());
            entriesList.add(entry);
        }
        for (ImportEntry entry : entriesList) {
            importable = (this.getImporter(entry, true).isImportable() || !entry.isMandatory()) && importable;
        }
        if (importable) {
            for (ImportEntry entry : this.importEntries) {
                importable = (this.getImporter(entry).isImportable() || !entry.isMandatory()) && importable;
            }
        }
        return importable;
    }

    @Override
    public void stop() {
        super.stop();
        for (Importer importer : this.importersList) {
            importer.stop();
        }
        if (this.vendorImporter != null) {
            this.vendorImporter.stop();
        }
    }

    @Override
    public Progressable.ProgressStatus performImport() {
        this.initializeStepList();
        this.setProgressStep(String.format("%s (step %d/%d)", this.stepList.get(this.stepCount), ++this.stepCount, this.stepList.size()));
        if (this.isImportable()) {
            ExecutorService pool = Executors.newWorkStealingPool(30);
            this.setProgressStep(String.format("%s (step %d/%d)", this.stepList.get(this.stepCount), ++this.stepCount, this.stepList.size()));
            for (ImportEntry entry : this.importEntries) {
                if (this.isStopped()) break;
                Importer importer = this.getImporter(entry);
                this.importersList.add(importer);
                importer.addProgressListener(evt -> this.fireProgressEvent(evt));
                pool.submit(importer);
            }
            boolean stopRunning = false;
            while (this.importersList.size() > 0) {
                ArrayList<Importer> toRemove = new ArrayList<Importer>();
                for (Importer importer : this.importersList) {
                    if (this.isStopped()) {
                        importer.stop();
                    }
                    switch (importer.getStatus()) {
                        case ENDED_FAILURE: {
                            stopRunning = true;
                        }
                        case ENDED_STOPED: 
                        case ENDED_WITH_MESSAGE: 
                        case ENDED_SUCCESS: {
                            toRemove.add(importer);
                            break;
                        }
                    }
                }
                this.importersList.removeAll(toRemove);
                if (!stopRunning) continue;
                for (Importer importer : this.importersList) {
                    importer.stop();
                }
            }
            if (stopRunning) {
                this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
            } else if (this.isStopped()) {
                this.setStatus(Progressable.ProgressStatus.ENDED_STOPED);
            } else if (this.vendorImporter != null) {
                this.setProgressStep(String.format("%s (step %d/%d)", this.stepList.get(this.stepCount), ++this.stepCount, this.stepList.size()));
                this.setStatus(this.vendorImporter.performImport());
            } else {
                this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
            }
        } else {
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
        }
        return this.getStatus();
    }

    private void initializeStepList() {
        this.stepList = new ArrayList<String>();
        this.stepList.add("Is importable");
        if (this.importEntries.size() > 0) {
            this.stepList.add(this.getImporter(this.importEntries.first()).getTitle());
        }
        if (this.vendorImporter != null) {
            this.stepList.add(this.vendorImporter.getTitle());
        }
    }

    private Importer getImporter(ImportEntry entry) {
        return this.getImporter(entry, false);
    }

    private Importer getImporter(ImportEntry entry, boolean testOnly) {
        ImporterType type = entry.getType();
        return switch (type) {
            case ImporterType.DBTable -> {
                if (this.automatic) {
                    yield new AutomaticDBTableImporter(entry, testOnly);
                }
                yield new ManualDBTableImporter(entry);
            }
            case ImporterType.Directory -> {
                Path pathDirectory = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
                yield new DirectoryImporter(entry, pathDirectory);
            }
            default -> {
                Path path = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
                yield new FIleImporter(entry, path);
            }
        };
    }

    @Override
    public String getID() {
        return this.importEntries.getImportDetails().getProperty("ID");
    }

    @Override
    public void postImportAction() {
        if (this.vendorImporter != null) {
            this.vendorImporter.postImportAction();
        }
    }
}

