/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataObject.entities;

import com.bmc.ctmconvert.dataObject.Attributes;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.dataObject.IAttribute;
import com.bmc.ctmconvert.dataObject.entities.DataEntityImp;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InMemoryDataObject
implements DataObject {
    private Map<DataEntity, DataEntity> childToParent;
    private parentIdTochildsId parentChildMap;
    private List<DataEntity> entites = new ArrayList<DataEntity>();
    private PairToID pairToId;
    private Cache cache = new Cache(this);

    public InMemoryDataObject() {
        this.childToParent = new HashMap<DataEntity, DataEntity>();
        this.pairToId = new PairToID(this);
        this.parentChildMap = new parentIdTochildsId();
    }

    @Override
    public DataEntity store(Data data, DataEntity parent) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("cannot store Null value");
        }
        DataEntityImp entity = null;
        if (parent != null) {
            entity = new DataEntityImp(data, parent);
            if (!this.entites.contains(parent)) {
                throw new IllegalArgumentException("The DataObject does NOT contain " + String.valueOf(parent));
            }
            this.childToParent.put(entity, parent);
            this.parentChildMap.put(parent, entity);
        } else {
            entity = new DataEntityImp(data);
        }
        this.entites.add(entity);
        return entity;
    }

    @Override
    public DataEntity store(Data data) {
        return this.store(data, null);
    }

    @Override
    public DataObject filterEntitiesBy(Predicate<DataEntity> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<DataEntity> stream() {
        return this.entites.stream();
    }

    @Override
    public List<DataEntity> getChildrenOf(DataEntity entity, Predicate<DataEntity> predicate) throws RuntimeException {
        if (!this.entites.contains(entity)) {
            throw new RuntimeException("Reuqested entity does not exist - " + entity.toString());
        }
        ArrayList<DataEntity> ret = new ArrayList();
        if (this.parentChildMap.containsKey(entity)) {
            ret.addAll((Collection)this.parentChildMap.get(entity));
        }
        ret = ret.stream().filter(predicate).collect(Collectors.toList());
        return ret;
    }

    @Override
    public Optional<DataEntity> getParentOf(DataEntity entity) throws IllegalArgumentException {
        if (!this.entites.contains(entity)) {
            throw new IllegalArgumentException("Reuqested entity does not exist - " + entity.toString());
        }
        DataEntity parent = this.childToParent.get(entity);
        Optional<DataEntity> ret = Optional.ofNullable(parent);
        return ret;
    }

    @Override
    public List<DataEntity> getDecendentsOf(DataEntity entity) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataEntity> getAncestorsOf(DataEntity entity) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Optional<DataEntity> getFirstAncestor(DataEntity entity, Predicate<DataEntity> predicate) throws Exception {
        Optional<DataEntity> candidateParent = this.getParentOf(entity);
        while (candidateParent.isPresent()) {
            DataEntity parent = candidateParent.get();
            if (predicate.test(parent)) {
                return candidateParent;
            }
            candidateParent = this.getParentOf(parent);
        }
        return Optional.empty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName() + "\n");
        for (DataEntity entity : this.entites) {
            Attributes attributes = entity.getAttributes();
            for (IAttribute attribute : attributes) {
                stringBuilder.append(entity.hashCode()).append("\t").append(attribute.getName()).append("\t").append(attribute.getValue()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public class Cache {
        public Cache(InMemoryDataObject this$0) {
        }

        public void add(Predicate<DataEntity> predicate, List<DataEntity> ret) {
            throw new UnsupportedOperationException();
        }
    }

    public class PairToID {
        private HashMap<String, List<Pair<String, String>>> keyToPair = new LinkedHashMap<String, List<Pair<String, String>>>();
        private HashMap<Pair<String, String>, ArrayList<DataEntity>> PairToIds = new HashMap();

        public PairToID(InMemoryDataObject this$0) {
        }

        public String toString() {
            return super.toString() + "\nPairToID [keyToPair=" + String.valueOf(this.keyToPair) + "]";
        }

        public void put(Pair<String, String> pair, DataEntity id) {
            if (!this.PairToIds.containsKey(pair)) {
                this.PairToIds.put(pair, new ArrayList());
            }
            if (!this.keyToPair.containsKey(pair.getKey())) {
                this.keyToPair.put(pair.getKey(), new ArrayList());
            }
            this.PairToIds.get(pair).add(id);
            if (!this.keyToPair.get(pair.getKey()).contains(pair)) {
                this.keyToPair.get(pair.getKey()).add(pair);
            }
        }

        public List<DataEntity> getIdsThatHaveKeyWithValue(String Key2, String Value) {
            Pair<String, String> pair = new Pair<String, String>(Key2, Value);
            ArrayList<DataEntity> ret = new ArrayList<DataEntity>();
            ArrayList<DataEntity> ids = this.PairToIds.get(pair);
            if (ids != null) {
                ret.addAll(ids);
            }
            return ret;
        }

        public List<DataEntity> getIdWhoHasKey(String key) {
            if (!this.keyToPair.containsKey(key)) {
                return Collections.emptyList();
            }
            List<Pair<String, String>> pairsWithId = this.keyToPair.get(key);
            HashSet<DataEntity> set = new HashSet<DataEntity>();
            for (Pair<String, String> pair : pairsWithId) {
                ArrayList<DataEntity> ids = this.PairToIds.get(pair);
                set.addAll(ids);
            }
            ArrayList<DataEntity> ret = new ArrayList<DataEntity>(set);
            return ret;
        }
    }

    public class parentIdTochildsId
    extends HashMap<DataEntity, ArrayList<DataEntity>> {
        private static final long serialVersionUID = -6486716711115532959L;

        @Override
        public void put(DataEntity parnet, DataEntity child) {
            if (!this.containsKey(parnet)) {
                this.put(parnet, new ArrayList());
            }
            ((ArrayList)this.get(parnet)).add(child);
        }

        public ArrayList<DataEntity> getChilds(DataEntity parnet) {
            ArrayList<DataEntity> ret = new ArrayList<DataEntity>();
            if (this.containsKey(parnet)) {
                ret.addAll((Collection)this.get(parnet));
            }
            return ret;
        }
    }
}

