/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.reporter;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.reporter.ActionReporter;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class CsvActionReporter
implements ActionReporter {
    private int m_actionSerial = 0;
    private File actionFile;
    private CsvWriter csvWriter;

    @Override
    public void initActionsReport() {
        if (this.actionFile == null) {
            this.actionFile = new File(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "Actions.csv");
        }
        if (this.csvWriter != null) {
            this.csvWriter.close();
            this.csvWriter = null;
        }
        if (this.actionFile.exists()) {
            this.actionFile.delete();
        }
        try {
            this.csvWriter = new CsvWriter(FileUtils.createNewWriter(Paths.get(this.actionFile.getAbsolutePath(), new String[0]), new OpenOption[0]));
            this.csvWriter.writeRecord(Globs.ACTION_REPORT_HEADR_ARR);
            this.csvWriter.flush();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    @Override
    public void addAction(Map<String, String> action) {
        if (this.m_actionSerial == 0) {
            this.initActionsReport();
        }
        ++this.m_actionSerial;
        String[] actEntry = new String[Globs.ACTION_REPORT_HEADR_ARR.length];
        for (int i = 0; i < Globs.ACTION_REPORT_HEADR_ARR.length; ++i) {
            actEntry[i] = Globs.ACTION_REPORT_HEADR_ARR[i].equals("ACTID") ? Integer.toString(this.m_actionSerial) : (action.containsKey(Globs.ACTION_REPORT_HEADR_ARR[i]) ? action.get(Globs.ACTION_REPORT_HEADR_ARR[i]) : "");
        }
        try {
            this.csvWriter.writeRecord(actEntry);
            this.csvWriter.flush();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    @Override
    public void reset() {
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
    }
}

