/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.rbc;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.exceptions.RBCIllegalValueException;
import com.bmc.ctmconvert.common.rbc.RbcNamer;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.vc.Message;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RBC {
    private static final int MAXIMUM_NUMBER_OF_ALLOWED_WEEKDAYS = 10;
    private static final String ALL = "ALL";
    private String name;
    private int maxwait;
    private String active_from;
    private String active_till;
    private boolean[][] days;
    private String dayscal;
    private DAYS_AND_OR days_and_or;
    private boolean[][] weekdays;
    private String weekscal;
    private WEEKDAYS firstDayOfTheWeek;
    private boolean[][] dayInWeek;
    private boolean[] months;
    private String confcal;
    private SHIFT shift;
    private int shiftnum;
    private int uniquenessID = 0;
    private LEVEL level;
    private boolean retro;
    private String date;
    protected boolean truncated;
    protected boolean containsInvalidCharacters;
    protected boolean renamed;
    private boolean isWeekdaysTruncated;
    protected static int anonymousCount = 0;

    public RBC() {
        this.initialize(null, WEEKDAYS.MONDAY);
    }

    public RBC(String name) {
        this.initialize(name, WEEKDAYS.MONDAY);
    }

    public RBC(String name, WEEKDAYS firstDayOfTheWeek) {
        this.initialize(name, firstDayOfTheWeek);
    }

    private void initialize(String name, WEEKDAYS firstDayOfTheWeek) {
        this.setName(name);
        this.setFirstDayOfTheWeek(firstDayOfTheWeek);
        this.setDays_and_or(DAYS_AND_OR.OR);
        this.setShift(SHIFT.IGNOREJOB);
        this.setLevel(LEVEL.TABLE);
        this.days = new boolean[DAY_TYPE.values().length][32];
        this.weekdays = new boolean[DAY_TYPE.values().length][7];
        this.dayInWeek = new boolean[7][7];
        this.months = new boolean[12];
    }

    public static void initAnonymousCount() {
        anonymousCount = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean isContainsInvalidCharacters() {
        return this.containsInvalidCharacters;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isWeekdaysTruncated() {
        return this.isWeekdaysTruncated;
    }

    private int getMaxwait() {
        return this.maxwait;
    }

    public void setMaxwait(int maxwait) throws RBCIllegalValueException {
        if (maxwait < 0 || maxwait > 99) {
            throw new RBCIllegalValueException("incorrect value " + maxwait + " of maxWait in calendar " + this.name);
        }
        this.maxwait = maxwait;
    }

    private String getActive_from() {
        return this.active_from;
    }

    public void setActive_from(int year, int month, int day) {
        this.active_from = String.format("%4d%02d%02d", year, month, day);
    }

    public void setActive_from(LocalDate fromDate) {
        this.setActive_from(fromDate.getYear(), fromDate.getMonthValue(), fromDate.getDayOfMonth());
    }

    private String getActive_till() {
        return this.active_till;
    }

    public void setActive_till(int year, int month, int day) {
        this.active_till = String.format("%4d%02d%02d", year, month, day);
    }

    public void setActive_till(LocalDate untilDate) {
        this.setActive_till(untilDate.getYear(), untilDate.getMonthValue(), untilDate.getDayOfMonth());
    }

    private String getDays() {
        StringBuilder toRet = new StringBuilder();
        boolean allDays = true;
        for (int day = 1; day < this.days[DAY_TYPE.DAY.ordinal()].length; ++day) {
            allDays &= this.days[DAY_TYPE.DAY.ordinal()][day];
        }
        if (allDays) {
            toRet.append(ALL);
        } else {
            for (DAY_TYPE type : DAY_TYPE.values()) {
                for (int day = 1; day < this.days[type.ordinal()].length; ++day) {
                    if (!this.days[type.ordinal()][day]) continue;
                    toRet.append(",").append(String.format(type.getTypeFormat(), day));
                }
            }
            if (toRet.length() > 0) {
                toRet.deleteCharAt(0);
            }
        }
        return toRet.toString();
    }

    public void setDay(DAY_TYPE type, int day, boolean aFlag) throws RBCIllegalValueException {
        if (day < 1 || day > 31) {
            throw new RBCIllegalValueException("incorrect value " + day + " of " + String.valueOf((Object)type) + " in calendar " + this.name);
        }
        this.days[type.ordinal()][day] = aFlag;
    }

    public void setDay(DAY_TYPE type, int day) {
        if (day < 1 || day > 31) {
            return;
        }
        this.days[type.ordinal()][day] = true;
    }

    public void setDayRange(DAY_TYPE type, int start, int end, boolean aFlag) throws RBCIllegalValueException {
        int day = start;
        while (day <= end) {
            this.setDay(type, day++, aFlag);
        }
    }

    public void addDay(int day) throws RBCIllegalValueException {
        this.addDay(DAY_TYPE.DAY, day);
    }

    public void addDay(DAY_TYPE type, int day) throws RBCIllegalValueException {
        this.setDay(type, day, true);
    }

    public void addDaysRange(DAY_TYPE type, int start, int end) throws RBCIllegalValueException {
        this.setDayRange(type, start, end, true);
    }

    public void addAllDays() {
        try {
            this.setDayRange(DAY_TYPE.DAY, 1, 31, true);
        }
        catch (RBCIllegalValueException rBCIllegalValueException) {
            // empty catch block
        }
    }

    public void addAllMonths() {
        for (MONTHS month : MONTHS.values()) {
            this.addMonth(month);
        }
    }

    public void removeDay(int day) throws RBCIllegalValueException {
        this.removeDay(DAY_TYPE.DAY, day);
    }

    public void removeDay(DAY_TYPE type, int day) throws RBCIllegalValueException {
        this.setDay(type, day, false);
    }

    public void removeDaysRange(DAY_TYPE type, int start, int end) throws RBCIllegalValueException {
        this.setDayRange(type, start, end, false);
    }

    public void removeAllDays() {
        try {
            this.setDayRange(DAY_TYPE.DAY, 1, 31, false);
        }
        catch (RBCIllegalValueException rBCIllegalValueException) {
            // empty catch block
        }
    }

    public String getDayscal() {
        return this.dayscal;
    }

    public void setDayscal(String dayscal) {
        this.dayscal = dayscal;
    }

    private DAYS_AND_OR getDays_and_or() {
        return this.days_and_or;
    }

    public void setDays_and_or(DAYS_AND_OR days_and_or) {
        this.days_and_or = days_and_or;
    }

    private WEEKDAYS getFirstDayOfTheWeek() {
        return this.firstDayOfTheWeek;
    }

    public void setFirstDayOfTheWeek(WEEKDAYS firstDayOfTheWeek) {
        this.firstDayOfTheWeek = firstDayOfTheWeek;
    }

    /*
     * WARNING - void declaration
     */
    private String getWeekdays() {
        ArrayList<String> weekDays = new ArrayList<String>();
        boolean allDays = true;
        for (boolean weekday : this.weekdays[DAY_TYPE.DAY.ordinal()]) {
            allDays &= weekday;
        }
        if (allDays) {
            weekDays.add(ALL);
        } else {
            void var3_6;
            for (DAY_TYPE type : DAY_TYPE.values()) {
                for (WEEKDAYS weekday : WEEKDAYS.values()) {
                    if (!this.weekdays[type.ordinal()][weekday.ordinal()]) continue;
                    weekDays.add(String.format(type.getTypeFormat(), this.getWeekdayAccordingToFirstDayOfTheWeek(weekday)));
                }
            }
            boolean bl = true;
            while (var3_6 < this.dayInWeek.length) {
                for (WEEKDAYS weekday : WEEKDAYS.values()) {
                    if (!this.dayInWeek[var3_6][weekday.ordinal()]) continue;
                    weekDays.add(String.format("D%dW%d", this.getWeekdayAccordingToFirstDayOfTheWeek(weekday), (int)var3_6));
                }
                ++var3_6;
            }
        }
        return this.weekdaysToString(weekDays);
    }

    private String weekdaysToString(List<String> weekDays) {
        if (this.isNotValidWeekDays(weekDays)) {
            weekDays = this.trimWeekDays(weekDays);
        }
        return weekDays.stream().collect(Collectors.joining(","));
    }

    private List<String> trimWeekDays(List<String> weekDays) {
        this.isWeekdaysTruncated = true;
        return weekDays.subList(0, 10);
    }

    private boolean isNotValidWeekDays(List<String> weekDays) {
        return weekDays.size() > 10;
    }

    private int getWeekdayAccordingToFirstDayOfTheWeek(WEEKDAYS weekday) {
        return (weekday.ordinal() - (this.getFirstDayOfTheWeek().ordinal() - 1) + 7) % 7;
    }

    private void setWeekDay(DAY_TYPE type, WEEKDAYS weekday, boolean aFlag) {
        this.weekdays[type.ordinal()][weekday.ordinal()] = aFlag;
    }

    private void setAllWeekDay(boolean aFlag) {
        for (WEEKDAYS weekday : WEEKDAYS.values()) {
            this.setWeekDay(DAY_TYPE.DAY, weekday, aFlag);
        }
    }

    public void addWeekDay(WEEKDAYS weekday) {
        this.setWeekDay(DAY_TYPE.DAY, weekday, true);
    }

    public void addWeekDay(DAY_TYPE type, WEEKDAYS weekday) {
        this.setWeekDay(type, weekday, true);
    }

    public void addAllWeekDay() {
        this.setAllWeekDay(true);
    }

    public void removeAllWeekDay() {
        this.setAllWeekDay(false);
    }

    public void removeWeekDay(WEEKDAYS weekday) {
        this.setWeekDay(DAY_TYPE.DAY, weekday, false);
    }

    public void removeWeekDay(DAY_TYPE type, WEEKDAYS weekday) {
        this.setWeekDay(type, weekday, false);
    }

    private void setDayInWeek(int week, WEEKDAYS day, boolean aFlag) throws RBCIllegalValueException {
        if (week < 1 || week > 6) {
            throw new RBCIllegalValueException("incorrect value " + week + " of week in calendar " + this.name);
        }
        this.dayInWeek[week][day.ordinal()] = aFlag;
    }

    public void addDayInWeek(int week, WEEKDAYS day) throws RBCIllegalValueException {
        this.setDayInWeek(week, day, true);
    }

    public void removeDayInWeek(int week, WEEKDAYS day) throws RBCIllegalValueException {
        this.setDayInWeek(week, day, false);
    }

    private String getWeekscal() {
        return this.weekscal;
    }

    public void setWeekscal(String weekscal) {
        this.weekscal = weekscal;
    }

    public void addMonth(int month) {
        this.months[month - 1] = true;
    }

    public void removeMonth(int month) {
        this.months[month - 1] = false;
    }

    private void setMonth(MONTHS month, boolean aFlag) {
        this.months[month.ordinal()] = aFlag;
    }

    public void addMonth(MONTHS month) {
        this.setMonth(month, true);
    }

    public void removeMonth(MONTHS month) {
        this.setMonth(month, false);
    }

    public String getConfcal() {
        return this.confcal;
    }

    public void setConfcal(String confcal) {
        this.confcal = confcal;
    }

    public SHIFT getShift() {
        return this.shift;
    }

    public void setShift(SHIFT shift) {
        this.shift = shift;
    }

    public int getShiftnum() {
        return this.shiftnum;
    }

    public void setShiftnum(int shiftnum) {
        this.shiftnum = shiftnum;
    }

    private LEVEL getLevel() {
        return this.level;
    }

    public void setLevel(LEVEL level) {
        this.level = level;
    }

    private boolean getRetro() {
        return this.retro;
    }

    public void setRetro(boolean retro) {
        this.retro = retro;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getUniquenessID() {
        return this.uniquenessID;
    }

    public void setUniquenessID(int uniquenessID) {
        this.uniquenessID = uniquenessID;
    }

    public Properties getRawRbc() {
        Properties rbcProps = this.getRBCForCalendarFile(true);
        rbcProps.setProperty("RETRO", this.getRetro() ? "1" : "0");
        rbcProps.setProperty("LEVEL", this.getLevel().toString());
        return rbcProps;
    }

    public Properties getRBCForCalendarFile(boolean preserveName) {
        Properties toRet = new Properties();
        toRet.setProperty("DATACENTER", Params.instance().getDatacenterName());
        toRet.setProperty("MAXWAIT", String.format("%02d", this.getMaxwait()));
        toRet.setProperty("DAYS_AND_OR", this.getDays_and_or().toString());
        this.setProperty(toRet, "DAYS", this.getDays());
        this.setProperty(toRet, "DAYSCAL", this.getDayscal());
        this.setProperty(toRet, "WEEKDAYS", this.getWeekdays());
        this.setProperty(toRet, "WEEKSCAL", this.getWeekscal());
        this.setProperty(toRet, "CONFCAL", this.getConfcal());
        toRet.setProperty("SHIFT", this.getShift().toString());
        this.setProperty(toRet, "SHIFTNUM", this.shiftnumToString());
        this.setProperty(toRet, "ACTIVE_FROM", this.getActive_from());
        this.setProperty(toRet, "ACTIVE_TILL", this.getActive_till());
        this.setProperty(toRet, "DATE", this.getDate());
        for (MONTHS month : MONTHS.values()) {
            toRet.setProperty(month.toString(), this.months[month.ordinal()] ? "1" : "0");
        }
        if (!preserveName) {
            toRet.setProperty("NAME", this.getFixedName(toRet));
        } else {
            toRet.setProperty("NAME", this.getName());
        }
        return toRet;
    }

    private String shiftnumToString() {
        IntUnaryOperator limit = v -> {
            if (v > 62) {
                return 62;
            }
            if (v < -62) {
                return -62;
            }
            return v;
        };
        int value = limit.applyAsInt(this.getShiftnum());
        return String.format("%+03d", value);
    }

    public Properties getRBCForCalendarFile() {
        return this.getRBCForCalendarFile(false);
    }

    protected String getFixedName(Properties prop) {
        String name = this.getName();
        if (name != null && !name.isEmpty()) {
            name = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", name);
            for (Message message : FieldValidation.instance().getErrMsgs()) {
                if (message.getMsgType() == Message.MessageType.LENGTH) {
                    this.truncated = true;
                    continue;
                }
                if (message.getMsgType() != Message.MessageType.INVALID_CHARACTER) continue;
                this.containsInvalidCharacters = true;
            }
        }
        if (name == null || name.isEmpty()) {
            if (!RbcNamer.nameRbc(prop, this.getFirstDayOfTheWeek().toString().substring(0, 3))) {
                prop.setProperty("NAME", String.format("RBC_%03d", ++anonymousCount));
            }
            name = prop.getProperty("NAME");
            this.renamed = true;
        }
        this.setName(name);
        name = this.addUniqueIdPrefix(name);
        if (name.length() > 19) {
            name = name.substring(0, 19);
            if (!this.renamed) {
                this.truncated = true;
            }
        }
        return name;
    }

    protected String addUniqueIdPrefix(String name) {
        if (this.uniquenessID > 0) {
            name = this.formatNameWithUniqueId(name);
        }
        return name;
    }

    protected String formatNameWithUniqueId(String name) {
        return String.format("%d#%s", this.uniquenessID, name);
    }

    public Properties getRBC() {
        return this.getRBC(false);
    }

    public Properties getRBC(boolean exclude) {
        Properties toRet = this.getRBCForCalendarFile();
        if (exclude) {
            toRet.setProperty("NAME", "!" + toRet.getProperty("NAME"));
        }
        toRet.setProperty("RETRO", this.getRetro() ? "1" : "0");
        toRet.setProperty("LEVEL", this.getLevel().toString());
        return toRet;
    }

    public Properties getRBCWithPreservedName() {
        Properties toRet = this.getRBCForCalendarFile(true);
        toRet.setProperty("RETRO", this.getRetro() ? "1" : "0");
        toRet.setProperty("LEVEL", this.getLevel().toString());
        return toRet;
    }

    public static WEEKDAYS stringToWEEKDAY(String day) {
        if (day != null && !day.isEmpty() && day.length() > 2) {
            for (WEEKDAYS weekday : WEEKDAYS.values()) {
                if (!weekday.toString().toLowerCase().startsWith(day.toLowerCase().substring(0, 3))) continue;
                return weekday;
            }
        }
        return null;
    }

    private void setProperty(Properties prop, String key, String value) {
        if (value != null && !value.isEmpty()) {
            prop.setProperty(key, value);
        }
    }

    public int hashCode() {
        return this.getRBC().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RBC other = (RBC)obj;
        return this.getRBCForCalendarFile(true).equals(other.getRBCForCalendarFile(true));
    }

    public boolean schedulingEquals(Object obj) {
        if (obj instanceof RBC) {
            Properties p1 = this.getRBCForCalendarFile(true);
            Properties p2 = ((RBC)obj).getRBCForCalendarFile(true);
            p1.remove("NAME");
            p2.remove("NAME");
            return p1.equals(p2);
        }
        return super.equals(obj);
    }

    public void setAsExcludeRbc() {
        Object calName = this.getName();
        calName = ((String)calName).startsWith("!") ? calName : "!" + (String)calName;
        this.setName((String)calName);
    }

    public List<Integer> getDaysList() {
        return this.getDaysList(DAY_TYPE.DAY);
    }

    public List<Integer> getDaysList(DAY_TYPE dayType) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int day = 1; day < this.days[dayType.ordinal()].length; ++day) {
            if (!this.days[dayType.ordinal()][day]) continue;
            ret.add(day);
        }
        return ret;
    }

    public List<MONTHS> getMonths() {
        ArrayList<MONTHS> ret = new ArrayList<MONTHS>();
        for (MONTHS month : MONTHS.values()) {
            if (!this.months[month.ordinal()]) continue;
            ret.add(month);
        }
        return ret;
    }

    public static enum WEEKDAYS {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;


        public static WEEKDAYS from(String day) {
            return switch (StringUtils.substring((String)day.toLowerCase(), (int)0, (int)3)) {
                case "sun" -> SUNDAY;
                case "mon" -> MONDAY;
                case "tue" -> TUESDAY;
                case "wed" -> WEDNESDAY;
                case "thu" -> THURSDAY;
                case "fri" -> FRIDAY;
                case "sat" -> SATURDAY;
                default -> MONDAY;
            };
        }
    }

    public static enum DAYS_AND_OR {
        AND,
        OR;

    }

    public static enum SHIFT {
        IGNOREJOB,
        PREVDAY,
        NEXTDAY,
        NOCONFCAL;

    }

    public static enum LEVEL {
        TABLE,
        CONTROL_M{

            public String toString() {
                return "CONTROL-M";
            }
        };

    }

    public static enum DAY_TYPE {
        DAY("%d"),
        ADDITIONAL_WORKINGDAY("+%d"),
        EXCLUDE_ADDITIONAL_WORKINGDAY("-%d"),
        WORKINGDAY("D%d"),
        EXCLUDE_WORKINGDAY("-D%d"),
        DAY_FROM_END("L%d"),
        EXCLUDE_DAY_FROM_END("-L%d");

        private final String typeFormat;

        private DAY_TYPE(String typeFormat) {
            this.typeFormat = typeFormat;
        }

        public String getTypeFormat() {
            return this.typeFormat;
        }
    }

    public static enum MONTHS {
        JAN,
        FEB,
        MAR,
        APR,
        MAY,
        JUN,
        JUL,
        AUG,
        SEP,
        OCT,
        NOV,
        DEC;


        public static MONTHS ofValue(int month) {
            return switch (month) {
                case 1 -> JAN;
                case 2 -> FEB;
                case 3 -> MAR;
                case 4 -> APR;
                case 5 -> MAY;
                case 6 -> JUN;
                case 7 -> JUL;
                case 8 -> AUG;
                case 9 -> SEP;
                case 10 -> OCT;
                case 11 -> NOV;
                case 12 -> DEC;
                default -> throw new IllegalStateException("Unexpected month value: " + month);
            };
        }
    }
}

