/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.file_watcher;

public class AgeFormatBuilder {
    private static final String DAYS_UNITS = "D";
    private static final String HOURS_UNITS = "H";
    private static final String MINUTES_UNITS = "MIN";
    private int minutes;
    private int hours;
    private int days;

    public String buildMinAge() {
        return this.buildAge(DefaultAge.MIN_AGE);
    }

    String buildAge(DefaultAge defaultValue) {
        StringBuilder result = new StringBuilder("");
        if (this.isZeroAge()) {
            return defaultValue.toString();
        }
        this.calculateValues();
        this.formatAge(result);
        return result.toString();
    }

    public String buildMaxAge() {
        return this.buildAge(DefaultAge.MAX_AGE);
    }

    private boolean isZeroAge() {
        return this.minutes == 0 && this.hours == 0 && this.days == 0;
    }

    private void calculateValues() {
        this.hours += this.minutes / 60;
        this.minutes %= 60;
        this.days += this.hours / 24;
        this.hours %= 24;
    }

    private void formatAge(StringBuilder result) {
        this.appendUnit(result, this.days, DAYS_UNITS);
        this.appendUnit(result, this.hours, HOURS_UNITS);
        this.appendUnit(result, this.minutes, MINUTES_UNITS);
    }

    private void appendUnit(StringBuilder result, int number, String units) {
        if (number != 0) {
            result.append(number).append(units);
        }
    }

    public AgeFormatBuilder setMinutes(int minutes) {
        this.minutes = minutes;
        return this;
    }

    public AgeFormatBuilder setHours(int hours) {
        this.hours = hours;
        return this;
    }

    public AgeFormatBuilder setDays(int days) {
        this.days = days;
        return this;
    }

    public AgeFormatBuilder reset() {
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        return this;
    }

    static enum DefaultAge {
        MIN_AGE("NO_MIN_AGE"),
        MAX_AGE("NO_MAX_AGE");

        private final String text;

        private DefaultAge(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

