/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.xml;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.TopLevelAttrHolder;
import com.bmc.ctmconvert.common.draftwriter.AssistingJobUtils;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.draftwriter.DraftWriter;
import com.bmc.ctmconvert.common.draftwriter.EntityWriter;
import com.bmc.ctmconvert.common.draftwriter.VersionControl;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XMLDraftWriter
implements DraftWriter {
    private DraftFormat draftFormat;
    private SourceDefinitions sourceDefinitions;
    private DataAccumulator dataAccumulator;

    public XMLDraftWriter(SourceDefinitions sourceDefinitions, DataAccumulator dataAccumulator, DraftFormat draftFormat) {
        this.sourceDefinitions = sourceDefinitions;
        this.dataAccumulator = dataAccumulator;
        this.draftFormat = draftFormat;
    }

    @Override
    public void writeDraft(Writer output) throws ConvertorException, ConvertorCancelClickException, IOException {
        ArrayList<String> genMsg;
        AttrHolderList topLevel = this.sourceDefinitions.getTopLevelEntities();
        if (topLevel == null) {
            throw new ConvertorException("No jobs found");
        }
        EntityWriter.init(this.draftFormat);
        output.write(this.draftFormat.getDraftHeader());
        ArrayList<SchedEntity> standaloneJobs = new ArrayList<SchedEntity>();
        ArrayList<AssistingJob> assistingStandAlone = new ArrayList<AssistingJob>();
        for (IAttrHolder entAttrs : topLevel) {
            boolean isHasChildren = entAttrs instanceof TopLevelAttrHolder ? this.sourceDefinitions.hasChildren(((TopLevelAttrHolder)entAttrs).getIdValue()) : this.sourceDefinitions.hasChildren(entAttrs.getAttr(this.sourceDefinitions.getIdFieldName()));
            if (isHasChildren || this.sourceDefinitions.isContainerEntity(entAttrs)) {
                SchedEntity smartFolder = this.sourceDefinitions.spawnJob("", entAttrs);
                SchedEntity parent = null;
                EntityWriter.writeEntity(smartFolder, parent, output, this.dataAccumulator);
                assistingStandAlone.addAll(AssistingJobUtils.getSiblingAssistingJobs(smartFolder));
                continue;
            }
            String tableName = this.sourceDefinitions.isStandAloneGrouped() ? "StandAloneJobs" : entAttrs.getAttr(this.sourceDefinitions.getIdFieldName()) + "_TABLE";
            standaloneJobs.add(this.sourceDefinitions.spawnJob(tableName, entAttrs));
        }
        if (!standaloneJobs.isEmpty() || !assistingStandAlone.isEmpty()) {
            ArrayList<SchedEntity> standaloneAndAssiting = new ArrayList<SchedEntity>();
            standaloneAndAssiting.addAll(standaloneJobs);
            standaloneAndAssiting.addAll(assistingStandAlone);
            Map<String, List<SchedEntity>> saMap = this.getStandaloneAndAssistingJobs(standaloneAndAssiting, this.sourceDefinitions);
            for (String tableID : saMap.keySet()) {
                String tName = this.getTableNameFromTableID(tableID);
                String userdaily = this.getUserDailyFromTableID(tableID);
                this.openDumbTable(output, tName, userdaily);
                for (SchedEntity saj : saMap.get(tableID)) {
                    EntityWriter.writeStandAloneJob(saj, output, tName, this.dataAccumulator);
                }
                this.closeDumbTable(output);
            }
        }
        if ((genMsg = this.sourceDefinitions.getGeneralMessages()) != null) {
            this.dataAccumulator.addGeneralMessages(genMsg);
        }
        output.write(this.draftFormat.getDraftFooter());
        this.sourceDefinitions.postActions();
    }

    private void closeDumbTable(Writer output) throws IOException {
        output.write(this.draftFormat.getDumbTableFooterFormat());
    }

    private void openDumbTable(Writer output, String tableName, String uDly) throws IOException {
        this.dataAccumulator.increaseTheCreatedFolderstCount();
        String encodedTableName = GlobalFunctions.EncodeXMLString(tableName);
        String encodedUserDaily = GlobalFunctions.EncodeXMLString(uDly);
        VersionControl versionControl = new VersionControl();
        Object versionKeyword = "";
        String version = versionControl.getVersionForXml();
        if (version.compareTo("900") > 0) {
            versionKeyword = "VERSION=\"" + version + "\"";
        }
        output.write(String.format(this.draftFormat.getDumbTableHeaderFormat(), Params.instance().getDatacenterName(), encodedTableName, encodedUserDaily, "UNIX", versionKeyword));
    }
}

