/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.BaseWhenAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.ConfirmationCalendarAttributeGetter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.ConfirmationCalendarsAdapter;
import com.bmc.ctmconvert.generated.json.models.base.ConfirmationCalendars;
import com.bmc.ctmconvert.generated.json.models.base.Month;
import com.bmc.ctmconvert.generated.json.models.base.RuleBasedCalendars;
import com.bmc.ctmconvert.generated.json.models.scheduling.RuleBasedCalendar;
import com.bmc.ctmconvert.generated.json.models.scheduling.WhenCalendar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class RuleBasedCalendarsAdapter
extends BaseWhenAdapter {
    private final List<Properties> calendars;
    private final String rbcRelationship;
    private final SchedEntity.TYPE type;
    RuleBasedCalendars ruleBasedCalendars;

    public RuleBasedCalendarsAdapter(List<Properties> calendars, SchedEntity.TYPE type, String rbcRelationship) {
        this.calendars = calendars;
        this.type = type;
        this.rbcRelationship = rbcRelationship;
        this.ruleBasedCalendars = new RuleBasedCalendars();
    }

    public RuleBasedCalendars getRuleBaseCalendars() {
        this.fillIncludeExclude();
        this.handleRelationshipBetweenSchedulingAndRBC();
        this.fillCalendarsDefinition();
        return this.ruleBasedCalendars.getExcluded() == null && this.ruleBasedCalendars.getIncluded() == null ? null : this.ruleBasedCalendars;
    }

    private void fillCalendarsDefinition() {
        if (GlobalFunctions.isSmartFolder(this.type)) {
            this.calendars.forEach(cal -> {
                String calLevel = cal.getProperty("LEVEL");
                if (this.isFolderLevelRbc(calLevel)) {
                    String calName = cal.getProperty("NAME");
                    RuleBasedCalendar calendar = this.getCalendar((Properties)cal);
                    this.ruleBasedCalendars.withAdditionalProperty(calName.replace("!", ""), calendar);
                }
            });
        }
    }

    private boolean isFolderLevelRbc(String calLevel) {
        return Optional.ofNullable(calLevel).map(level -> level.equals("N") || level.equals("TABLE")).orElse(true);
    }

    public RuleBasedCalendar getCalendar(Properties cal) {
        RuleBasedCalendar calendar = new RuleBasedCalendar();
        calendar.withType(RuleBasedCalendar.Type.CALENDAR_RULE_BASED);
        WhenCalendar when = new WhenCalendar();
        this.setDaysRelation(when, cal);
        this.setMonthDays(when, cal);
        this.setMonths(when, cal::getProperty);
        this.setDaysKeepActive(when, cal);
        this.setMonthDaysCalendar(when, cal.getProperty("DAYSCAL"));
        this.setWeekDaysCalendar(when, cal.getProperty("WEEKSCAL"));
        this.setStartDate(when, cal.getProperty("ACTIVE_FROM"));
        this.setEndDate(when, cal.getProperty("ACTIVE_TILL"));
        this.setConfirmationCalendar(when, cal);
        Optional<List<String>> weekDays = this.getWeekDays(cal.getProperty("WEEKDAYS"));
        weekDays.ifPresent(when::withWeekDays);
        return calendar.withWhen(when);
    }

    private void setConfirmationCalendar(WhenCalendar when, Properties cal) {
        ConfirmationCalendarAttributeGetter.ConfirmationCalendarAttributes confirmationCalendarAttributes = ConfirmationCalendarAttributeGetter.getAttributesFrom(cal);
        Optional<ConfirmationCalendars> confirmationCalendar = new ConfirmationCalendarsAdapter(confirmationCalendarAttributes).getConfirmationCalendars();
        when.setConfirmationCalendars(confirmationCalendar.orElse(null));
    }

    private void setDaysRelation(WhenCalendar when, Properties cal) {
        String daysAndOr = Optional.ofNullable(cal.getProperty("DAYS_AND_OR")).orElse("OR");
        when.withDaysRelation(daysAndOr.equals("AND") ? WhenCalendar.DaysRelation.AND : WhenCalendar.DaysRelation.OR);
    }

    private void setDaysKeepActive(WhenCalendar when, Properties cal) {
        Optional<String> maxWait = Optional.ofNullable(cal.getProperty("MAXWAIT"));
        maxWait.ifPresent(when::withDaysKeepActive);
    }

    private void setMonthDays(WhenCalendar when, Properties cal) {
        Optional.ofNullable(cal.getProperty("DAYS")).map(monthStr -> Arrays.asList(monthStr.split(","))).map(this::handleEmptyMonthdaysString).map(this::stripLeadingZeroes).ifPresent(monthDays -> when.withMonthDays((List<String>)monthDays));
    }

    private List<String> handleEmptyMonthdaysString(List<String> days) {
        return days.stream().map(day -> "".equals(day) ? Month.NONE.toString() : day).collect(Collectors.toList());
    }

    private List<String> stripLeadingZeroes(List<String> days) {
        return days.stream().map(day -> day.replaceAll("0(\\d)$", "$1")).collect(Collectors.toList());
    }

    private void fillIncludeExclude() {
        ArrayList<String> exclude = new ArrayList<String>();
        ArrayList<String> include = new ArrayList<String>();
        this.calendars.forEach(cal -> {
            String calName = cal.getProperty("NAME");
            if (calName.startsWith("!")) {
                exclude.add(calName.replace("!", ""));
            } else {
                include.add(this.handleUseParentSchedule(calName));
            }
        });
        if (!exclude.isEmpty()) {
            this.ruleBasedCalendars.withExcluded(exclude);
        }
        if (!include.isEmpty()) {
            this.ruleBasedCalendars.withIncluded(include);
        }
    }

    private void handleRelationshipBetweenSchedulingAndRBC() {
        if (JsonUtils.isJob(this.type)) {
            Optional<String> relationship = Optional.ofNullable(this.rbcRelationship);
            relationship.ifPresent(relat -> this.ruleBasedCalendars.withRelationship(relat.contains("O") ? "OR" : "AND"));
        } else {
            this.ruleBasedCalendars.withRelationship(null);
        }
    }

    private String handleUseParentSchedule(String calName) {
        if (!GlobalFunctions.isSmartFolder(this.type) && calName.equals("*")) {
            return "USE PARENT";
        }
        return calName;
    }
}

