/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling;

import com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling.ConfirmationCalendarAttributeGetter;
import com.bmc.ctmconvert.generated.json.models.base.ConfirmationCalendars;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfirmationCalendarsAdapter {
    public static final String EMPTY_SHIFT_BY = null;
    public static final ConfirmationCalendars.ExceptionPolicy EMPTY_POLICY = null;
    public static final String PREV_DAY = "Prev Day";
    public static final String NEXT_DAY = "Next Day";
    public static final String NO_CONFCAL = "No Confcal";
    public static final String IGNORE_JOB = "Ignore Job";
    private final ConfirmationCalendarAttributeGetter.ConfirmationCalendarAttributes attributes;
    public static final Pattern SHIFT_BY_PATTERN = Pattern.compile("^[+]?(-?[0-9]{1,2})$");

    public ConfirmationCalendarsAdapter(ConfirmationCalendarAttributeGetter.ConfirmationCalendarAttributes attributes) {
        this.attributes = attributes;
    }

    public Optional<ConfirmationCalendars> getConfirmationCalendars() {
        if (this.hasConfirmationCalendar()) {
            return Optional.ofNullable(this.createConfirmationCalendars());
        }
        return Optional.empty();
    }

    private ConfirmationCalendars createConfirmationCalendars() {
        ConfirmationCalendars.ExceptionPolicy exceptionPolicy = this.getExceptionPolicy();
        String calendarName = this.attributes.getCalendarName();
        String shiftBY = this.getShiftBY(exceptionPolicy);
        return new ConfirmationCalendars().withCalendar(calendarName).withShiftBy(shiftBY).withExceptionPolicy(exceptionPolicy);
    }

    private ConfirmationCalendars.ExceptionPolicy getExceptionPolicy() {
        return Optional.ofNullable(this.attributes.getExceptionPolicy()).map(this::convertExceptionPolicy).orElse(EMPTY_POLICY);
    }

    private ConfirmationCalendars.ExceptionPolicy convertExceptionPolicy(String policy) {
        return switch (policy) {
            case "PREVDAY", PREV_DAY -> ConfirmationCalendars.ExceptionPolicy.ORDER_ON_PREVIOUS_CONFIRMED_DAY;
            case "NEXTDAY", NEXT_DAY -> ConfirmationCalendars.ExceptionPolicy.ORDER_ON_NEXT_CONFIRMED_DAY;
            case "NOCONFCAL", NO_CONFCAL -> ConfirmationCalendars.ExceptionPolicy.ORDER_ANYWAY;
            case "IGNOREJOB", IGNORE_JOB -> ConfirmationCalendars.ExceptionPolicy.DO_NOT_ORDER;
            default -> EMPTY_POLICY;
        };
    }

    private String getShiftBY(ConfirmationCalendars.ExceptionPolicy exceptionPolicy) {
        if (ConfirmationCalendars.ExceptionPolicy.DO_NOT_ORDER.equals((Object)exceptionPolicy)) {
            return EMPTY_SHIFT_BY;
        }
        return Optional.ofNullable(this.attributes.getShiftBy()).map(this::convertToShiftBY).orElse(EMPTY_SHIFT_BY);
    }

    private String convertToShiftBY(String shiftNum) {
        String shiftBy = EMPTY_SHIFT_BY;
        Matcher matcher = SHIFT_BY_PATTERN.matcher(shiftNum);
        if (matcher.matches()) {
            String shiftByNumber = matcher.group(1);
            shiftBy = this.formatShiftBy(shiftByNumber);
        }
        return shiftBy;
    }

    private String formatShiftBy(String shiftByNumber) {
        String shiftByWithoutLeadingZero = this.removeLeadingZero(shiftByNumber);
        return this.filterDefaultShiftBy(shiftByWithoutLeadingZero);
    }

    private String removeLeadingZero(String shiftByNumber) {
        if (shiftByNumber.startsWith("0")) {
            return shiftByNumber.substring(1);
        }
        if (shiftByNumber.startsWith("-0")) {
            return "-" + shiftByNumber.substring(2);
        }
        return shiftByNumber;
    }

    private String filterDefaultShiftBy(String shiftBy) {
        boolean isDefaultOrEmpty = "0".equals(shiftBy) || "-0".equals(shiftBy) || "".equals(shiftBy);
        return isDefaultOrEmpty ? EMPTY_SHIFT_BY : shiftBy;
    }

    private boolean hasConfirmationCalendar() {
        Optional<String> confCal = Optional.ofNullable(this.attributes.getCalendarName());
        return confCal.map(calendarName -> !calendarName.isEmpty()).orElse(false);
    }
}

