/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.rerun;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.generated.json.models.base.rerun.Rerun;
import com.bmc.ctmconvert.generated.json.models.base.rerun.RerunLimit;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RerunAdapter {
    private final SchedEntity schedEntity;
    private final SchedEntity parent;

    public RerunAdapter(SchedEntity schedEntity, SchedEntity parent) {
        this.schedEntity = schedEntity;
        this.parent = parent;
    }

    public Optional<Rerun> getRerun() {
        return Optional.ofNullable(this.schedEntity.getAttr("INTERVAL")).filter(interval -> !this.isAllZero(this.removeUnits((String)interval))).map(interval -> new Rerun().withUnits(this.getUnits((String)interval)).withTimes(this.getTimes()).withEvery(this.getEvery((String)interval)).withFrom(this.getFrom()));
    }

    private Rerun.From getFrom() {
        return Optional.ofNullable(this.schedEntity.getAttr("IND_CYCLIC")).map(from -> {
            if (from.startsWith("E")) {
                return Rerun.From.END;
            }
            if (from.startsWith("T")) {
                return Rerun.From.TARGET;
            }
            return Rerun.From.START;
        }).orElse(Rerun.From.START);
    }

    private String getEvery(String interval) {
        return Optional.ofNullable(interval).map(this::removeUnits).map(this::stripLeadingZeros).orElse(null);
    }

    private boolean isAllZero(String interval) {
        return interval.matches("^0+$");
    }

    private String stripLeadingZeros(String interval) {
        return this.isAllZero(interval) ? "0" : StringUtils.stripStart((String)interval, (String)"0");
    }

    private String removeUnits(String interval) {
        return interval.replaceAll("[HMD]", "");
    }

    private String getTimes() {
        return Optional.ofNullable(this.schedEntity.getAttr("MAXRERUN")).orElse("0");
    }

    private Rerun.RerunUnits getUnits(String interval) {
        return Optional.ofNullable(interval).map(i -> i.substring(i.length() - 1)).map(unit -> {
            if ("D".equals(unit)) {
                return Rerun.RerunUnits.DAYS;
            }
            if ("H".equals(unit)) {
                return Rerun.RerunUnits.HOURS;
            }
            return Rerun.RerunUnits.MINUTES;
        }).orElse(Rerun.RerunUnits.MINUTES);
    }

    public Optional<RerunLimit> getRerunLimit() {
        boolean parentIsCyclic = Optional.ofNullable(this.parent).map(SchedEntity::isCyclic).orElse(false);
        if (parentIsCyclic) {
            return Optional.of(new RerunLimit().withUnits((Object)Rerun.RerunUnits.MINUTES).withEvery("0"));
        }
        return this.getRerun().map(rerun -> new RerunLimit().withUnits((Object)rerun.getUnits()).withEvery(rerun.getEvery()).withTimes(rerun.getTimes()));
    }
}

