/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopBaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopJavaMapReduceJob;
import java.util.Set;
import java.util.regex.Pattern;

public class HadoopJavaMapReduceAdapter
extends HadoopBaseJobAdapter<HadoopJavaMapReduceJob.Type> {
    private static final Pattern JAVA_MAP_REDUCE_ARGUMENTS_PATTERN = Pattern.compile("HDP-JAVA-N([0-9]{3})-(ARG)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.getAllUsedVariablesInHadoopBasejob();
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getMainClass()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getProgramJar()));
        return usedVariablesFromStr;
    }

    public HadoopJavaMapReduceAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseHadoopJob buildBaseHadoopJob() {
        return new HadoopJavaMapReduceJob().withMainClass(this.getMainClass()).withProgramJar(this.getProgramJar());
    }

    @Override
    protected Pattern getArgumentsPattern() {
        return JAVA_MAP_REDUCE_ARGUMENTS_PATTERN;
    }

    private String getProgramJar() {
        return this.schedEntity.getVariable("%%HDP-JAVA_JAR_NAME");
    }

    private String getMainClass() {
        return this.schedEntity.getVariable("%%HDP-JAVA_MAIN_CLASS");
    }

    @Override
    public HadoopJavaMapReduceJob.Type getType() {
        return HadoopJavaMapReduceJob.Type.JOB_HADOOP_MAP_REDUCE;
    }
}

