/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.BaseDatabaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseDatabaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.StoredProcedureJob;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StoredProcedureJobAdapter
extends BaseDatabaseJobAdapter<StoredProcedureJob.Type> {
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("DB-STP_PARAMS-P([0-9]{3})-PRM_(NAME|DIRECTION|VALUE)");
    private static final String DBO = "dbo";
    private static final String PACKAGE = "DB-STP_PACKAGE";
    private static final String SCHEMA = "DB-STP_SCHEM";
    private static final String NAME = "DB-STP_NAME";
    public static final String EMPTY_PARAMETER = null;

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getPackage());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getStoredProcedureName()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getReturnValue()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getSchema()));
        Stream.ofNullable(this.getParameters()).forEach(param -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(param.toString())));
        return usedVariablesFromStr;
    }

    public StoredProcedureJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseDatabaseJob buildBaseDatabaseJob() {
        StoredProcedureJob storedProcedureJob = new StoredProcedureJob().withSchema(this.getSchema()).withReturnValue(this.getReturnValue()).withParameters(this.getParameters());
        this.getPackage().ifPresent(storedProcedureJob::setPackage);
        this.getStoredProcedureName().ifPresent(storedProcedureJob::setStoredProcedure);
        return storedProcedureJob;
    }

    private String getReturnValue() {
        List<Optional> parameters = this.getVariablesAdapter().convertAutoEditsWithPattern(PARAMETERS_PATTERN, this::getReturnValueFrom);
        return parameters.stream().findFirst().filter(Optional::isPresent).map(Optional::get).orElse(EMPTY_PARAMETER);
    }

    private Optional<String> getPackage() {
        return this.getVariablesAdapter().getVariableByName(PACKAGE).filter(value -> !value.equals("*"));
    }

    private String getSchema() {
        return this.getVariablesAdapter().getVariableByName(SCHEMA).orElse(DBO);
    }

    private Optional<String> getStoredProcedureName() {
        return this.getVariablesAdapter().getVariableByName(NAME);
    }

    @Override
    public StoredProcedureJob.Type getType() {
        return StoredProcedureJob.Type.JOB_DATABASE_STORED_PROCEDURE;
    }

    private List<Object> getParameters() {
        List<Object> parameters = this.getVariablesAdapter().convertAutoEditsWithPattern(PARAMETERS_PATTERN, this::createParametersFrom).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return parameters.isEmpty() ? null : parameters;
    }

    private Optional<String> getReturnValueFrom(List<VariableWrapper> variableWrappers) {
        String direction = VariablesAdapter.getParameterFrom(variableWrappers, "DIRECTION");
        if ("Return".equalsIgnoreCase(direction)) {
            return Optional.of(VariablesAdapter.getParameterFrom(variableWrappers, "NAME"));
        }
        return Optional.empty();
    }

    private Optional<Object> createParametersFrom(List<VariableWrapper> variableWrappers) {
        String parameterName = VariablesAdapter.getParameterFrom(variableWrappers, "NAME");
        String direction = VariablesAdapter.getParameterFrom(variableWrappers, "DIRECTION");
        String value = VariablesAdapter.getParameterFrom(variableWrappers, "VALUE");
        if ("In".equalsIgnoreCase(direction)) {
            return Optional.of(value);
        }
        if ("Out".equalsIgnoreCase(direction)) {
            return Optional.of(parameterName);
        }
        if ("InOut".equalsIgnoreCase(direction)) {
            return Optional.of(Arrays.asList(value, parameterName));
        }
        return Optional.empty();
    }
}

