/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.BaseDatabaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseDatabaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.Property;
import com.bmc.ctmconvert.generated.json.models.job_types.SSISJob;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SSISJobAdapter
extends BaseDatabaseJobAdapter<SSISJob.Type> {
    private static final Pattern CONFIG_FILES_PARAMETERS_PATTERN = Pattern.compile("DB-SSIS_CONFIGFILES-N([0-9]{3})-NAME");
    private static final Pattern SSIS_PROPERTIES_PATTERN = Pattern.compile("DB-SSIS_SETVALPARAMS-N([0-9]{3})-(NAME|VALUE)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getPackageSource());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getPackageName()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getCatalogEnv()));
        Stream.ofNullable(this.getConfigFiles()).flatMap(Collection::stream).forEach(configFile -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr((String)configFile)));
        Stream.ofNullable(this.getProperties()).forEach(prop -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(prop.toString())));
        return usedVariablesFromStr;
    }

    public SSISJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseDatabaseJob buildBaseDatabaseJob() {
        return new SSISJob().withPackageSource(this.getPackageSource()).withPackageName(this.getPackageName()).withCatalogEnv(this.getCatalogEnv()).withConfigFiles(this.getConfigFiles()).withProperties(this.getProperties());
    }

    @Override
    public SSISJob.Type getType() {
        return SSISJob.Type.JOB_DATABASE_MSSQL_SSIS;
    }

    private String getPackageSource() {
        return this.getVariablesAdapter().getVariableByName("%%DB-SSIS_PACKAGE_SOURCE").orElse(null);
    }

    private String getPackageName() {
        return this.getVariablesAdapter().getVariableByName("%%DB-SSIS_PACKAGE_NAME").orElse(null);
    }

    private String getCatalogEnv() {
        return this.getVariablesAdapter().getVariableByName("%%DB-CATALOG_ENV").orElse(null);
    }

    private List<String> getConfigFiles() {
        List<String> configFiles = this.getVariablesAdapter().convertAutoEditsWithPattern(CONFIG_FILES_PARAMETERS_PATTERN, this::createConfigFileFrom);
        return configFiles.isEmpty() ? null : configFiles;
    }

    private List<Property> getProperties() {
        List<Property> configFiles = this.getVariablesAdapter().convertAutoEditsWithPattern(SSIS_PROPERTIES_PATTERN, this::createPropertiesFrom);
        return configFiles.isEmpty() ? null : configFiles;
    }

    private Property createPropertiesFrom(List<VariableWrapper> variables) {
        String parameterName = VariablesAdapter.getParameterFrom(variables, "NAME");
        String parameterValue = VariablesAdapter.getParameterFrom(variables, "VALUE");
        return new Property().withAdditionalProperty(parameterName, parameterValue);
    }

    private String createConfigFileFrom(List<VariableWrapper> variables) {
        return variables.stream().map(VariableWrapper::getValue).findFirst().orElse("");
    }
}

