/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import com.bmc.ctmconvert.generated.json.models.job_types.OracleEBusinessSuiteJob;
import com.bmc.ctmconvert.generated.json.models.job_types.RequestSet;
import com.bmc.ctmconvert.generated.json.models.job_types.SingleRequest;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class OracleEBusinessSuiteJobAdapter
extends BaseJobAdapter<OracleEBusinessSuiteJob.Type> {
    public static boolean isOEBSJob(SchedEntity entity) {
        return "OEBS".equals(entity.getAttr("APPL_TYPE"));
    }

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        return Set.of();
    }

    public OracleEBusinessSuiteJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        BaseJob oracleEBusinessSuit = new OracleEBusinessSuiteJob().withConnectionProfile(this.getConnectionProfile()).withResponsibility(this.getResponsibility()).withUserName(this.getUserName()).withVariables((List)this.getVariables());
        this.getRequestSet().ifPresent(((OracleEBusinessSuiteJob)oracleEBusinessSuit)::setRequestSet);
        this.getSingleRequest().ifPresent(((OracleEBusinessSuiteJob)oracleEBusinessSuit)::setSingleRequest);
        return oracleEBusinessSuit;
    }

    private Optional<RequestSet> getRequestSet() {
        String requestType = this.getVariablesAdapter().getVariableByName("%%OAP-TASKTYPE").orElse("");
        RequestSet requestSet = null;
        if (requestType.equalsIgnoreCase("REQUEST_SET")) {
            requestSet = new RequestSet();
            requestSet.setSet(this.getVariablesAdapter().getVariableByName("%%OAP-SETDESP").orElse(""));
        }
        return Optional.ofNullable(requestSet);
    }

    private Optional<SingleRequest> getSingleRequest() {
        String requestType = this.getVariablesAdapter().getVariableByName("%%OAP-TASKTYPE").orElse("");
        SingleRequest singleRequest = null;
        if (requestType.equalsIgnoreCase("REQUEST")) {
            singleRequest = new SingleRequest();
            singleRequest.setProgramName(this.getVariablesAdapter().getVariableByName("%%OAP-PROGDESP").orElse(""));
        }
        return Optional.ofNullable(singleRequest);
    }

    private String getUserName() {
        return this.getVariablesAdapter().getVariableByName("%%OAP-USERNAME").orElse("");
    }

    private String getResponsibility() {
        return this.getVariablesAdapter().getVariableByName("%%OAP-RESPNAME").orElse("");
    }

    private String getConnectionProfile() {
        return this.getVariablesAdapter().getVariableByName("%%OAP-INSTANCE").orElse("OEBS_CONNECTION_PROFILE");
    }

    private List<Variable> getVariables() {
        List<String> removeOEBSVariable = Stream.of("%%OAP-SETDESP", "%%OAP-INSTANCE", "%%OAP-USERNAME", "%%OAP-RESPNAME", "%%OAP-PROGDESP", "%%OAP-TASKTYPE").map(v -> v.replaceAll("%%", "")).toList();
        return this.getVariablesAdapter().getCMVariables().stream().map(VariableWrapper::new).filter(variable -> variable.doesNotExistIn(removeOEBSVariable)).map(VariableWrapper::getVariable).toList();
    }

    @Override
    public OracleEBusinessSuiteJob.Type getType() {
        return OracleEBusinessSuiteJob.Type.JOB_OEBS;
    }
}

