/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.actions;

import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.EmptyOrElseGetter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.OrElseGetter;
import com.bmc.ctmconvert.generated.json.models.if_schema.If;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfNumberOfFailures;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.BaseProgramStep;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.BaseZosIf;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.IfAnyProgramStep;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.IfEveryProgramStep;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.IfJobRcCodes;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.IfOutputPattern;
import com.bmc.ctmconvert.generated.json.models.if_schema.zos.IfSpecificProgramStep;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

class ZosIfFactory {
    ZosIfFactory() {
    }

    public OrElseGetter<If> createZosIf(Properties onStatement, String code) {
        return new EmptyOrElseGetter<If>().orIfNotNullGet(onStatement.getProperty("PGMS"), pgmsValue -> switch (pgmsValue) {
            case "ANYSTEP" -> this.createZosIfBasedOnAnyStep(onStatement, code);
            case "+EVERY" -> this.createZosEveryProgramStep(onStatement, code);
            case "+JOBRC" -> this.createZosJobRc(code);
            default -> this.createZosSpecificProgramStep(onStatement, code);
        }).orIfNotNullGet(onStatement.getProperty("PATTERN"), () -> this.createZosIfOutputPattern(onStatement));
    }

    private IfOutputPattern createZosIfOutputPattern(Properties onStatement) {
        return new IfOutputPattern().withOutputPattern(onStatement.getProperty("PATTERN")).withFromColumn(onStatement.getProperty("FROM_COLUMN")).withToColumn(onStatement.getProperty("TO_COLUMN"));
    }

    private If createZosIfBasedOnAnyStep(Properties onStatement, String code) {
        if (code.startsWith("FC")) {
            return this.createZosIfNumberOfFailures(code);
        }
        return this.createZosAnyProgramStep(onStatement, code);
    }

    private If createZosSpecificProgramStep(Properties onStatement, String code) {
        return this.createZosProgramStep(onStatement, code, new IfSpecificProgramStep().withProgram(onStatement.getProperty("PGMS")));
    }

    private If createZosProgramStep(Properties onStatement, String code, BaseProgramStep baseProgramStep) {
        return this.createBaseZosIf(code, baseProgramStep.withProcedure(onStatement.getProperty("PROCS")));
    }

    private BaseZosIf createBaseZosIf(String code, BaseZosIf baseZosIf) {
        return baseZosIf.withReturnCodes(this.splitCodeToReturnCodes(code));
    }

    @NotNull
    private List<String> splitCodeToReturnCodes(String code) {
        return List.of(code.split(","));
    }

    private IfNumberOfFailures createZosIfNumberOfFailures(String code) {
        return new IfNumberOfFailures().withType(IfNumberOfFailures.Type.IF_Z_OS_NUMBER_OF_FAILURES).withNumberOfFailures(ZosIfFactory.extractNumberOfFailuresFromCode(code));
    }

    @NotNull
    private static String extractNumberOfFailuresFromCode(String code) {
        return code.substring(2);
    }

    private If createZosAnyProgramStep(Properties onStatement, String code) {
        return this.createZosProgramStep(onStatement, code, new IfAnyProgramStep());
    }

    private If createZosEveryProgramStep(Properties onStatement, String code) {
        return this.createZosProgramStep(onStatement, code, new IfEveryProgramStep());
    }

    private If createZosJobRc(String code) {
        return this.createBaseZosIf(code, new IfJobRcCodes());
    }
}

