/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.actions;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.AdapterUtilsKt;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.DestinationFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.EmptyOrElseGetter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.OrElseGetter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.actions.ZosIfFactory;
import com.bmc.ctmconvert.generated.json.models.base.Variable;
import com.bmc.ctmconvert.generated.json.models.if_schema.CompletionStatus;
import com.bmc.ctmconvert.generated.json.models.if_schema.If;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfCompletionStatus;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfJobNotSubmitted;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfJobOutputNotFound;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfNumberOfExecutions;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfNumberOfFailures;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfNumberOfReruns;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfOutput;
import com.bmc.ctmconvert.generated.json.models.if_schema.IfVariableValue;
import com.bmc.ctmconvert.generated.json.models.if_schema.RangeVariableValue;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.ActionSet;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.ControlMAnalyzerRule;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Event;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Mail;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Notify;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Output;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.OutputHandling;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Rerun;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Restart;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Run;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.SetToNotOK;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.SetToOK;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.StopCyclicRun;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IfFactory {
    private static final String ACTION_NOTIFY = "Action:Notify";
    private static final String UNSUPPORTED = "Unsupported";
    private static final String JOB_LOG_DESTINATION = "JobLog";
    private static final String REGULAR = "Regular";
    private static final String URGENT = "Urgent";
    private static final String VERY_URGENT = "VeryUrgent";
    private static final Map<String, String> dummyAction = IfFactory.createDummyAction();
    private static final String IF_VARIABLE_VALUE_REGEX = "%%.*";
    private static final String IN_RANGE = "IR";
    private static final String NOT_IN_RANGE = "NR";
    public static final String FAILURE_COUNT_ZOS = "FC";
    private final SchedEntity schedEntity;

    public IfFactory(SchedEntity schedEntity) {
        this.schedEntity = schedEntity;
    }

    private static Map<String, String> createDummyAction() {
        LinkedHashMap<String, String> dummyAction = new LinkedHashMap<String, String>();
        dummyAction.put("Type", ACTION_NOTIFY);
        dummyAction.put("Destination", JOB_LOG_DESTINATION);
        dummyAction.put("Message", UNSUPPORTED);
        dummyAction.put("Urgency", VERY_URGENT);
        return dummyAction;
    }

    private Run createActionRun(Properties action) {
        String folder = action.getProperty("TABLE_NAME");
        Run actionRun = new Run().withFolder(folder);
        GlobalFunctions.ifPresent(action.getProperty("NAME"), actionRun::setJob);
        GlobalFunctions.ifPresent(action.getProperty("DATACENTER"), actionRun::setControlmServer);
        GlobalFunctions.ifPresent(action.getProperty("ODATE"), actionRun::setDate);
        GlobalFunctions.ifPresent(action.get("VARIABLE"), variables -> this.addVariables(actionRun, variables));
        GlobalFunctions.ifPresent(action.getProperty("DSN"), actionRun::setLib);
        GlobalFunctions.ifPresent(action.getProperty("UFLOW"), uniqueFlow -> actionRun.setRunAsIndependentFlow("Y".equals(uniqueFlow)));
        return actionRun;
    }

    private ActionSet createDoVariable(Properties action) {
        return new ActionSet().withVariable(GlobalFunctions.removeVariablePrefix(this.getPropertyValueByName(action, "VARIABLE").orElse(""))).withValue(this.getPropertyValueByName(action, "VALUE").orElse(""));
    }

    private void addVariables(Run actionRun, Object variablesObject) {
        if (variablesObject instanceof LinkedHashMap) {
            LinkedHashMap variables = (LinkedHashMap)variablesObject;
            if (variables.isEmpty()) {
                return;
            }
            actionRun.setVariables(new ArrayList<Variable>());
            variables.forEach((name, value) -> {
                Variable variable = new Variable();
                variable.setAdditionalProperty(GlobalFunctions.removeVariablePrefix(name.toString()), value);
                actionRun.getVariables().add(variable);
            });
        }
    }

    private Output createDoOutput(Properties action) {
        Output output = new Output().withOperation(this.getOperationType(action.getProperty("OPTION")));
        this.getPropertyValueByName(action, "PAR").ifPresent(output::setDestination);
        Optional.ofNullable(action.getProperty("FROM")).ifPresent(output::setFromClass);
        return output;
    }

    protected Notify createDoShout(Properties actionList) {
        return new Notify().withUrgency(this.getNotifyUrgency(actionList)).withDestination(DestinationFactory.getDestination(this.schedEntity, actionList)).withMessage(this.getMessage(actionList));
    }

    protected String getMessage(Properties actionList) {
        return this.getPropertyValueByName(actionList, "MESSAGE").orElse("");
    }

    private Mail createDoMail(Properties action) {
        Mail mail = new Mail().withUrgency(this.getMailUrgency(action)).withMessage(this.getPropertyValueByName(action, "MESSAGE").orElse("")).withTo(this.getPropertyValueByName(action, "DEST").orElse(""));
        this.getPropertyValueByName(action, "SUBJECT").ifPresent(mail::setSubject);
        this.getPropertyValueByName(action, "CC_DEST").ifPresent(mail::setCc);
        this.getAttachOutput(action).ifPresent(mail::setAttachOutput);
        return mail;
    }

    private Optional<Boolean> getAttachOutput(Properties actionList) {
        String attachOutput;
        return switch (attachOutput = this.getPropertyValueByName(actionList, "ATTACH_SYSOUT").orElse("Default")) {
            case "Yes" -> Optional.of(true);
            case "No" -> Optional.of(false);
            default -> Optional.empty();
        };
    }

    private Mail.Urgency getMailUrgency(Properties action) {
        String ret = this.getUrgencyType(action);
        return Mail.Urgency.fromValue(ret);
    }

    protected Notify.Urgency getNotifyUrgency(Properties action) {
        String ret = this.getUrgencyType(action);
        return Notify.Urgency.fromValue(ret);
    }

    private String getUrgencyType(Properties action) {
        String urgency;
        return switch (urgency = this.getPropertyValueByName(action, "URGENCY").orElse("R")) {
            case "U" -> URGENT;
            case "V" -> VERY_URGENT;
            default -> REGULAR;
        };
    }

    private Optional<String> getPropertyValueByName(Properties action, String key) {
        return Optional.ofNullable(action.getProperty(key));
    }

    public void addAction(If anIf, int counter, Properties action) {
        Map.Entry<String, ?> actionEntry = this.createActionEntry(counter, action);
        anIf.setAdditionalProperty(actionEntry.getKey(), actionEntry.getValue());
    }

    @NotNull
    Map.Entry<String, ?> createActionEntry(int counter, Properties action) {
        String actionType = action.getProperty("ACTION");
        String actionPrefix = "Action_";
        Object actionKey = actionPrefix + counter;
        Map<String, String> newAction = switch (actionType) {
            case "DOMAIL" -> this.createDoMail(action);
            case "DOSHOUT" -> this.createDoShout(action);
            case "DOSYSOUT" -> this.createDoOutput(action);
            case "DOVARIABLE" -> this.createDoVariable(action);
            case "OK" -> new SetToOK();
            case "RERUN" -> new Rerun();
            case "NOTOK" -> new SetToNotOK();
            case "SPCYC" -> new StopCyclicRun();
            case "DOFORCEJOB" -> this.createActionRun(action);
            case "DOCOND" -> this.createActionEvent(action);
            case "DOCTBRULE" -> this.createActionControlMAnalyzerRule(action);
            case "DOIFRERUN" -> this.createActionRestart(action);
            default -> {
                actionKey = "UnsupportedAction";
                yield dummyAction;
            }
        };
        return Map.entry(actionKey, newAction);
    }

    private Restart createActionRestart(Properties action) {
        return new Restart().withFromProgram(action.getProperty("FPGMS")).withFromProcedure(action.getProperty("FPROCS")).withToProgram(action.getProperty("TPGMS")).withToProcedure(action.getProperty("TPROCS")).withConfirm("1".equals(action.getProperty("CONFIRM")));
    }

    private ControlMAnalyzerRule createActionControlMAnalyzerRule(Properties action) {
        return new ControlMAnalyzerRule().withName(action.getProperty("NAME")).withArg(action.getProperty("PAR"));
    }

    private Event createActionEvent(Properties action) {
        Event.Type type = this.getEventType(action);
        String eventName = action.getProperty("NAME");
        String orderDate = this.getOrderDate(action);
        return new Event().withType(type).withEvent(eventName).withDate(orderDate);
    }

    private String getOrderDate(Properties action) {
        String odate;
        String ORDER_DATE = "OrderDate";
        String ANY_DATE = "AnyDate";
        String PREV = "PreviousOrderDate";
        String NEXT = "NextOrderDate";
        String NO_DATE = "NoDate";
        String orderDate = null;
        switch (odate = Optional.ofNullable(action.getProperty("ODATE")).orElse("OrderDate")) {
            case "NEXT": {
                orderDate = "NextOrderDate";
                break;
            }
            case "PREV": {
                orderDate = "PreviousOrderDate";
                break;
            }
            case "****": {
                orderDate = "AnyDate";
                break;
            }
            case "STAT": {
                orderDate = "NoDate";
                break;
            }
            default: {
                if (!GlobalFunctions.isValidDate(odate, "MMdd")) break;
                orderDate = odate;
            }
        }
        return orderDate;
    }

    private Event.Type getEventType(Properties action) {
        String sign = action.getProperty("SIGN");
        return "ADD".equals(sign) ? Event.Type.EVENT_ADD : Event.Type.EVENT_DELETE;
    }

    public If createAnIf(Properties onStatement) {
        String statement = onStatement.getProperty("STMT");
        String code = onStatement.getProperty("CODE");
        If defaultIf = this.createIfOutput(statement, code);
        return (If)((Object)new EmptyOrElseGetter<If>().orIfTrueGet(IfFactory.isOnStatementBasedOnCode(statement), () -> this.createIfBasedOnCode(code).orDefault(defaultIf)).orIfTrueGet(IfFactory.isIfVariableValue(statement), () -> this.createIfVariableValue(statement, code)).orIfPresentGet((If)((Object)new ZosIfFactory().createZosIf(onStatement, code))).orDefault((OrElseGetter<If>)((Object)defaultIf)));
    }

    private static boolean isOnStatementBasedOnCode(String statement) {
        return "*".equals(statement);
    }

    private OrElseGetter<If> createIfBasedOnCode(String code) {
        return new EmptyOrElseGetter<If>().orIfNotNullGet(this.mapCompletionStatus(code), completionStatus -> new IfCompletionStatus().withCompletionStatus(completionStatus)).orIfNotNullGet(this.mapNumberOfReruns(code), numberOfReruns -> new IfNumberOfReruns().withNumberOfReruns((String)numberOfReruns)).orIfNotNullGet(this.numberOfFailures(code), numberOfFailures -> new IfNumberOfFailures().withNumberOfFailures((String)numberOfFailures)).orIfNotNullGet(this.numberOfExecutions(code), numberOfExecutions -> new IfNumberOfExecutions().withNumberOfExecutions((String)numberOfExecutions)).orIfTrueGet(this.isJobNotSubmitted(code), IfJobNotSubmitted::new).orIfTrueGet(this.isJobOutputNotFound(code), IfJobOutputNotFound::new);
    }

    @NotNull
    private IfVariableValue createIfVariableValue(String statement, String code) {
        IfVariableValue ifVariableValue = new IfVariableValue().withType(this.getIfVariableValueType()).withVariableName(this.extractVariableName(statement)).withVariableValue(code).withOperator(this.extractOperator(statement));
        this.createRangeVariableValue(statement, code).ifPresent(ifVariableValue::setRangeVariableValue);
        return ifVariableValue;
    }

    @NotNull
    private static Boolean isIfVariableValue(String statement) {
        return Optional.ofNullable(statement).map(s -> s.matches(IF_VARIABLE_VALUE_REGEX)).orElse(false);
    }

    private IfVariableValue.Type getIfVariableValueType() {
        if (this.schedEntity.isDSJob()) {
            return IfVariableValue.Type.IF_VARIABLE_VALUE;
        }
        return IfVariableValue.Type.IF_Z_OS_VARIABLE_VALUE;
    }

    private Optional<RangeVariableValue> createRangeVariableValue(String statement, String code) {
        if (statement.endsWith(IN_RANGE) || statement.endsWith(NOT_IN_RANGE)) {
            return Optional.ofNullable(code).map(c -> c.split(" ")).filter(splitted -> ((String[])splitted).length == 2).map(range -> new RangeVariableValue().withMin(range[0]).withMax(range[1]));
        }
        return Optional.empty();
    }

    private IfVariableValue.Operator extractOperator(String statement) {
        return Optional.ofNullable(statement).map(s -> s.split(" ")).filter(s -> ((String[])s).length == 2).map(operator -> switch (operator[1]) {
            case "NE" -> IfVariableValue.Operator.NOT_EQUAL_TO;
            case "GT" -> IfVariableValue.Operator.GREATER_THAN;
            case "GE" -> IfVariableValue.Operator.GREATER_THAN_OR_EQUAL;
            case "LT" -> IfVariableValue.Operator.LESS_THAN;
            case "LE" -> IfVariableValue.Operator.LESS_THAN_OR_EQUAL;
            case IN_RANGE -> IfVariableValue.Operator.IN_RANGE;
            case NOT_IN_RANGE -> IfVariableValue.Operator.NOT_IN_RANGE;
            case "LK" -> IfVariableValue.Operator.LIKE;
            case "NL" -> IfVariableValue.Operator.NOT_LIKE;
            case "IX" -> IfVariableValue.Operator.IS_EXACTLY;
            case "NX" -> IfVariableValue.Operator.IS_NOT_EXACTLY;
            case "SW" -> IfVariableValue.Operator.STARTS_WITH;
            case "EW" -> IfVariableValue.Operator.END_WITH;
            case "CO" -> IfVariableValue.Operator.CONTAINS;
            case "NC" -> IfVariableValue.Operator.DOES_NOT_CONTAIN;
            case "MP" -> IfVariableValue.Operator.IS_EMPTY;
            case "NP" -> IfVariableValue.Operator.IS_NOT_EMPTY;
            default -> IfVariableValue.Operator.EQUAL_TO;
        }).orElse(null);
    }

    private String extractVariableName(String statement) {
        return GlobalFunctions.removeVariablePrefix(statement.split("\\s")[0]);
    }

    private String numberOfExecutions(String code) {
        return this.mapComparison("RUNCOUNT", code);
    }

    private String mapComparison(String prefix, String code) {
        if ((prefix + " EQ EVEN").equals(code)) {
            return "Even";
        }
        if ((prefix + " EQ ODD").equals(code)) {
            return "Odd";
        }
        return this.mapCommonCodeOperators(prefix, code);
    }

    private boolean isJobOutputNotFound(String code) {
        return "JLOST".equals(code);
    }

    private boolean isJobNotSubmitted(String code) {
        return "NOTSUB".equals(code);
    }

    private String numberOfFailures(String code) {
        Matcher matcher = Pattern.compile("FAILCOUNT=(?<numberOfFailures>\\d+)").matcher(code);
        return matcher.find() ? matcher.group("numberOfFailures") : null;
    }

    public If createIfOutput(String statement, String code) {
        return new IfOutput().withStatement(statement).withCode(code);
    }

    private Object mapCompletionStatus(String code) {
        return switch (code) {
            case "OK" -> CompletionStatus.OK;
            case "NOTOK" -> CompletionStatus.NOTOK;
            case "COMPSTAT EQ ANY" -> CompletionStatus.ANY;
            case "COMPSTAT EQ EVEN" -> CompletionStatus.EVEN;
            case "COMPSTAT EQ ODD" -> CompletionStatus.ODD;
            default -> this.mapCommonCodeOperators("COMPSTAT", code);
        };
    }

    private String mapNumberOfReruns(String code) {
        return this.mapComparison("RERUNNO", code);
    }

    private String mapCommonCodeOperators(String prefix, String code) {
        Pattern pattern = Pattern.compile(prefix + " (EQ|NE|LE|LT|GE|GT) (\\d+)");
        Matcher matcher = pattern.matcher(code);
        if (matcher.find()) {
            return IfFactory.convertXmlOperatorToJsonOperator(matcher);
        }
        return null;
    }

    private static String convertXmlOperatorToJsonOperator(Matcher matcher) {
        String operator = matcher.group(1);
        String value = matcher.group(2);
        return switch (operator) {
            case "EQ" -> value;
            case "NE" -> "!=" + value;
            case "LE" -> "<=" + value;
            case "LT" -> "<" + value;
            case "GE" -> ">=" + value;
            case "GT" -> ">" + value;
            default -> null;
        };
    }

    private OutputHandling.Operation getOperationType(String operation) {
        return AdapterUtilsKt.parseOperation(operation);
    }
}

