/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseSapR3JobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.BaseSapExternalStep;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.PrintArchiveMode;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.PrintOptions;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.SapABAPStep;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.SapExternalCommandStep;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.SapExternalProgramStep;
import com.bmc.ctmconvert.generated.json.models.job_types.SapSteps.SapStep;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class SapStepsAdapter {
    private static final Pattern SAP_STEPS_PATTERN = Pattern.compile("SAPR3-STEP-S([0-9]{2})-(?<parameterName>.*)");
    private final VariablesAdapter variablesAdapter;

    public SapStepsAdapter(VariablesAdapter variablesAdapter) {
        this.variablesAdapter = variablesAdapter;
    }

    public List<SapStep> getSteps() {
        return this.variablesAdapter.convertAutoEditsWithPattern(SAP_STEPS_PATTERN, this::sapStepFrom);
    }

    private SapStep sapStepFrom(List<VariableWrapper> variables) {
        SapStep sapStep = this.convertStepByType(variables);
        return this.addBaseStepFields(variables, sapStep);
    }

    private SapStep convertStepByType(List<VariableWrapper> variables) {
        String stepType;
        switch (stepType = VariablesAdapter.getParameterFrom(variables, "STEP_TYPE")) {
            case "A": {
                return this.createSapABAPStep(variables);
            }
            case "C": {
                return this.createSapExternalCommandStep(variables);
            }
            case "E": {
                return this.createSapExternalProgramStep(variables);
            }
        }
        return this.createEmptyStep();
    }

    private SapStep createEmptyStep() {
        return new SapStep();
    }

    private BaseSapExternalStep createSapExternalProgramStep(List<VariableWrapper> variables) {
        return this.buildBaseExternalStep(new SapExternalProgramStep(), variables);
    }

    private BaseSapExternalStep buildBaseExternalStep(BaseSapExternalStep sapStep, List<VariableWrapper> variables) {
        return sapStep.withTargetHost(VariablesAdapter.getParameterFrom(variables, "TARGET_HOST", null)).withLogExternalErrors(BaseSapR3JobAdapter.isSapSelected(variables, "LOG_STDERR")).withLogExternalOutput(BaseSapR3JobAdapter.isSapSelected(variables, "LOG_STDOUT")).withWaitExternalTermination(BaseSapR3JobAdapter.isSapSelected(variables, "WAIT_FOR_TERM")).withActiveTrace(BaseSapR3JobAdapter.isSapSelected(variables, "ACTIVATE_TRACE")).withVariantName(this.getVariantName(variables));
    }

    private BaseSapExternalStep createSapExternalCommandStep(List<VariableWrapper> variables) {
        SapExternalCommandStep sapStep = new SapExternalCommandStep().withOperatingSystem(VariablesAdapter.getParameterFrom(variables, "OPERSYS", null));
        return this.buildBaseExternalStep(sapStep, variables);
    }

    private SapABAPStep createSapABAPStep(List<VariableWrapper> variables) {
        SapABAPStep sapABAPStep = new SapABAPStep().withLanguage(VariablesAdapter.getParameterFrom(variables, "LANGU", null));
        this.getPrintArchiveMode(variables).ifPresent(sapABAPStep::withPrintArchiveMode);
        this.convertVariantName(sapABAPStep, variables);
        this.convertArchiveAttributes(sapABAPStep, variables);
        this.convertPrintAttributes(sapABAPStep, variables);
        return sapABAPStep;
    }

    private void convertArchiveAttributes(SapABAPStep sapABAPStep, List<VariableWrapper> variables) {
        sapABAPStep.setArchiveId(VariablesAdapter.getParameterFrom(variables, "ARCH_ID", null));
        sapABAPStep.setArchiveDocumentType(VariablesAdapter.getParameterFrom(variables, "ARCHIVE_OBJECT", null));
        sapABAPStep.setArchiveInformationField(VariablesAdapter.getParameterFrom(variables, "ARCHIVE_INFO", null));
        sapABAPStep.setArchiveText(VariablesAdapter.getParameterFrom(variables, "ARCH_TEXT", null));
        sapABAPStep.setArchiveObjectType(VariablesAdapter.getParameterFrom(variables, "ARCHIVE_SAPOBJECT", null));
    }

    private void convertPrintAttributes(SapABAPStep sapABAPStep, List<VariableWrapper> variables) {
        sapABAPStep.setTimeToPrint(this.getTimeToPrint(variables));
        sapABAPStep.setCoverRecipient(VariablesAdapter.getParameterFrom(variables, "PRINT_RECIPIENT", null));
        sapABAPStep.setCoverPrintPage(BaseSapR3JobAdapter.isSapSelected(variables, "PRINT_BANNER_PAGE"));
        sapABAPStep.setCoverPage(this.getCover(variables, "PRINT_BANNER"));
        sapABAPStep.setCoverDepartment(VariablesAdapter.getParameterFrom(variables, "DEPT", null));
        sapABAPStep.setCoverSheet(this.getCover(variables, "PRINT_HOST_BANNER"));
        sapABAPStep.setPrintExpiration(this.getNumberOf("PRINT_EXPIRATION", variables, null));
        sapABAPStep.setSpoolListTitles(VariablesAdapter.getParameterFrom(variables, "LIST_TEXT", null));
        sapABAPStep.setSpoolListName(VariablesAdapter.getParameterFrom(variables, "LIST_NAME", null));
        sapABAPStep.setDeleteAfterPrint(BaseSapR3JobAdapter.isSapSelected(variables, "PRINT_RELEASE"));
        sapABAPStep.setOutputDevice(VariablesAdapter.getParameterFrom(variables, "PRINT_DEST", null));
        sapABAPStep.setOutputNumberColumns(this.getNumberOf("PRINT_NUMCOLUMNS", variables));
        sapABAPStep.setOutputNumberRows(this.getNumberOf("PRINT_NUMLINES", variables));
        sapABAPStep.setSpoolAuthorization(VariablesAdapter.getParameterFrom(variables, "PRINT_AUTH", null));
        sapABAPStep.setNewSpoolRequest(BaseSapR3JobAdapter.isSapSelected(variables, "NEW_LIST_ID"));
        sapABAPStep.setNumberOfCopies(this.getNumberOf("PRINT_COPIES", variables, null));
        sapABAPStep.setOutputLayout(VariablesAdapter.getParameterFrom(variables, "PRINT_LAYOUT", null));
    }

    private Integer getNumberOf(String attribute, List<VariableWrapper> variables) {
        return this.getNumberOf(attribute, variables, -1);
    }

    private PrintOptions getCover(List<VariableWrapper> variables, String attribute) {
        String value;
        switch (value = VariablesAdapter.getParameterFrom(variables, attribute)) {
            case "X": {
                return PrintOptions.PRINT;
            }
            case "N": {
                return PrintOptions.DO_NOT_PRINT;
            }
        }
        return PrintOptions.DEFAULT_SETTING;
    }

    private Integer getNumberOf(String attribute, List<VariableWrapper> variables, Integer defaultValue) {
        String value = VariablesAdapter.getParameterFrom(variables, attribute, null);
        return Optional.ofNullable(value).filter(s -> !s.isEmpty()).map(Integer::valueOf).orElse(defaultValue);
    }

    private SapABAPStep.TimeToPrint getTimeToPrint(List<VariableWrapper> variables) {
        String timeToPrint;
        switch (timeToPrint = VariablesAdapter.getParameterFrom(variables, "PRINT_IMMED")) {
            case "A": {
                return SapABAPStep.TimeToPrint.PRINT_LATER;
            }
            case "X": {
                return SapABAPStep.TimeToPrint.PRINT_IMMEDIATELY;
            }
        }
        return SapABAPStep.TimeToPrint.SEND_TO_SAP_SPOOLER;
    }

    private void convertVariantName(SapABAPStep sapABAPStep, List<VariableWrapper> variables) {
        boolean isTemporaryVarName = VariablesAdapter.getParameterFrom(variables, "VAR_TYPE").equals("TMP");
        if (isTemporaryVarName) {
            sapABAPStep.setTemporaryName(true);
        } else {
            sapABAPStep.setVariantName(this.getVariantName(variables));
        }
    }

    private String getVariantName(List<VariableWrapper> variables) {
        return VariablesAdapter.getParameterFrom(variables, "VAR-NAME", null);
    }

    private Optional<PrintArchiveMode> getPrintArchiveMode(List<VariableWrapper> variables) {
        String printMode;
        switch (printMode = VariablesAdapter.getParameterFrom(variables, "PRINT_ARCHMODE")) {
            case "Print": {
                return Optional.of(PrintArchiveMode.PRINT);
            }
            case "ARCHIVE": {
                return Optional.of(PrintArchiveMode.ARCHIVE);
            }
            case "PRINT_ARCHIVE": {
                return Optional.of(PrintArchiveMode.PRINT_AND_ARCHIVE);
            }
        }
        return Optional.empty();
    }

    private SapStep addBaseStepFields(List<VariableWrapper> variables, SapStep step) {
        return step.withProgramName(VariablesAdapter.getParameterFrom(variables, "PROGRAM")).withUserName(VariablesAdapter.getParameterFrom(variables, "OWNER", null));
    }
}

