/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.resource.IfFail;
import com.bmc.ctmconvert.generated.json.models.resource.Lock;
import com.bmc.ctmconvert.generated.json.models.resource.Pool;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class ResourcesAdapter {
    private final SchedEntity schedEntity;

    public ResourcesAdapter(SchedEntity schedEntity) {
        this.schedEntity = schedEntity;
    }

    public void addQuantitativeResources(JobProperties jobProperties) {
        GlobalFunctions.ifPresent(this.schedEntity.getQuantResources(), quantitativeResources -> {
            ArrayList<Pool> quantitativeResourceArray = new ArrayList<Pool>();
            for (Properties quantitativeResource : quantitativeResources) {
                String quantity = quantitativeResource.getProperty("QUANT");
                Optional<IfFail> ifFail = this.convertIfFail(quantitativeResource);
                Optional<Pool.IfOk> ifOk = this.convertIfOk(quantitativeResource);
                quantitativeResourceArray.add(this.createPool(quantity, quantitativeResource.getProperty("NAME"), ifFail, ifOk));
            }
            this.addResourcesToProp(jobProperties, quantitativeResourceArray);
        });
    }

    private void addResourcesToProp(JobProperties jobProperties, List resourceArray) {
        if (!resourceArray.isEmpty()) {
            if (jobProperties.getResources() != null) {
                List<Object> resources = jobProperties.getResources();
                resources.addAll(resourceArray);
                jobProperties.setResources(resources);
            } else {
                jobProperties.setResources(resourceArray);
            }
        }
    }

    private Optional<Pool.IfOk> convertIfOk(Properties resource) {
        if ("D".equals(resource.getProperty("ONOK"))) {
            return Optional.ofNullable(Pool.IfOk.DISCARD);
        }
        return Optional.empty();
    }

    private Pool createPool(String quantity, String name, Optional<IfFail> ifFail, Optional<Pool.IfOk> ifOk) {
        Pool pool = new Pool();
        ifFail.ifPresent(value -> pool.withIfFail((IfFail)((Object)value)));
        ifOk.ifPresent(value -> pool.withIfOk((Pool.IfOk)((Object)value)));
        return pool.withQuantity(quantity).withName(name);
    }

    public void addControlResources(JobProperties jobProperties) {
        GlobalFunctions.ifPresent(this.schedEntity.getCtrlResources(), controlResources -> {
            ArrayList<Lock> controlResourceArray = new ArrayList<Lock>();
            for (Properties controlResource : controlResources) {
                Optional<Lock.LockType> lockType = this.convertLockType(controlResource);
                Optional<IfFail> ifFail = this.convertIfFail(controlResource);
                controlResourceArray.add(this.createLock(lockType, controlResource.getProperty("NAME"), ifFail));
            }
            this.addResourcesToProp(jobProperties, controlResourceArray);
        });
    }

    private Optional<IfFail> convertIfFail(Properties resource) {
        if ("K".equals(resource.getProperty("ONFAIL"))) {
            return Optional.ofNullable(IfFail.KEEP);
        }
        return Optional.empty();
    }

    public Optional<Lock.LockType> convertLockType(Properties controlResource) {
        Optional<Lock.LockType> lockType = Optional.empty();
        String resourceType = controlResource.getProperty("TYPE");
        if ("S".equals(resourceType)) {
            lockType = Optional.of(Lock.LockType.SHARED);
        } else if ("E".equals(resourceType)) {
            lockType = Optional.of(Lock.LockType.EXCLUSIVE);
        }
        return lockType;
    }

    public Lock createLock(Optional<Lock.LockType> LockType2, String name, Optional<IfFail> ifFail) {
        Lock lock = new Lock();
        lock.withName(name);
        LockType2.ifPresent(lock::setLockType);
        ifFail.ifPresent(lock::setIfFail);
        return lock;
    }
}

