/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.AdjustEvent;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseSchedEntityAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseFolder;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.BaseJsonObject;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.job_types.zos.BaseZosJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class BaseFolderAdapter<T>
extends BaseSchedEntityAdapter<T> {
    protected List<Object> jobs = new ArrayList<Object>();

    protected BaseFolderAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    public Optional<AdjustEvent> getAdjustCondition() {
        return Optional.ofNullable(this.schedEntity.getAttr("ADJUST_COND")).map(adjustCond -> switch (adjustCond) {
            case "Y" -> AdjustEvent.Yes;
            case "N" -> AdjustEvent.No;
            case "B" -> AdjustEvent.Bridge;
            default -> throw new RuntimeException(String.format("Illegal value of adjust event attribute: %s", adjustCond));
        });
    }

    private String getTimeZone() {
        return this.schedEntity.getAttr("TIMEZONE");
    }

    @Override
    protected BaseJsonObject buildJobProperties() {
        BaseFolder baseFolder = this.buildBaseFolder();
        baseFolder.withTimeZone(this.getTimeZone());
        this.getAdjustCondition().map(this::convertAdjustEventXmlValueToJson).ifPresent(baseFolder::setAdjustEvents);
        return baseFolder;
    }

    @Override
    public Optional<Object> toJson() {
        try {
            BaseJsonObject baseJsonObject = this.buildJobProperties();
            Optional<Object> jobPropertiesFields = baseJsonObject instanceof JobProperties ? Optional.of(this.jobPropertiesAdapter.addJobPropertiesFields((JobProperties)baseJsonObject)) : Optional.ofNullable(baseJsonObject);
            if (baseJsonObject instanceof BaseFolder) {
                this.getAdaptersForChildren().forEach(adapter -> this.addChildrenToBaseFolder(baseJsonObject, (SchedEntityAdapter<?>)adapter));
                this.addJobsToFolder((BaseFolder)baseJsonObject);
            }
            return jobPropertiesFields;
        }
        catch (Exception e) {
            throw new RuntimeException("Conversion to Json Failed for " + this.schedEntity.getJobName(), e);
        }
    }

    private void addJobsToFolder(BaseFolder baseFolder) {
        baseFolder.withJobs(this.jobs);
    }

    private void addChildrenToBaseFolder(BaseJsonObject baseFolder, SchedEntityAdapter<?> adapter) {
        adapter.toJson().ifPresent(entity -> {
            if (entity instanceof BaseJob || entity instanceof BaseZosJob) {
                this.jobs.add(entity);
            } else {
                baseFolder.setAdditionalProperty(adapter.getName(), entity);
            }
        });
    }

    protected Object convertAdjustEventXmlValueToJson(AdjustEvent adjustEvent) {
        return switch (adjustEvent) {
            case AdjustEvent.Yes -> true;
            case AdjustEvent.Bridge -> "Bridge";
            default -> false;
        };
    }

    protected abstract BaseFolder buildBaseFolder();
}

