/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.DuplicationRemoverSchedEntityDecorator;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.TopLevelAttrHolder;
import com.bmc.ctmconvert.common.draftwriter.AssistingJobUtils;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.DraftWriter;
import com.bmc.ctmconvert.common.draftwriter.SimpleFolderSchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.DataAccumulatorWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.JSONWorkspace;
import com.bmc.ctmconvert.common.draftwriter.json.writers.JacksonWriter;
import com.bmc.ctmconvert.common.draftwriter.json.writers.JsonWriter;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JSONDraftWriter
implements DraftWriter {
    private final SourceDefinitions sourceDefinitions;
    private final DataAccumulatorWrapper dataAccumulator;
    private final JSONWorkspace workspace;
    private final JsonWriter jsonWriter;

    public JSONDraftWriter(SourceDefinitions sourceDefinitions, DataAccumulator dataAccumulator) {
        this.sourceDefinitions = sourceDefinitions;
        this.dataAccumulator = new DataAccumulatorWrapper(dataAccumulator);
        this.workspace = new JSONWorkspace();
        this.jsonWriter = new JacksonWriter();
    }

    @Override
    public void writeDraft(Writer output) throws ConvertorException, IOException {
        AttrHolderList topLevel = Optional.ofNullable(this.sourceDefinitions.getTopLevelEntities()).orElseThrow(() -> new ConvertorException("No jobs found"));
        ArrayList<SchedEntity> standaloneJobs = new ArrayList<SchedEntity>();
        for (IAttrHolder entityAttribute : topLevel) {
            if (this.isSmartFolder(entityAttribute)) {
                SchedEntity smartFolder = this.sourceDefinitions.spawnJob("", entityAttribute);
                this.addEntityToWorkspace(smartFolder);
                this.dataAccumulator.update(smartFolder);
                standaloneJobs.addAll(AssistingJobUtils.getSiblingAssistingJobs(smartFolder));
                continue;
            }
            standaloneJobs.add(this.sourceDefinitions.spawnJob("StandAloneJobs", entityAttribute));
        }
        if (!standaloneJobs.isEmpty()) {
            this.writeStandaloneJobs(standaloneJobs);
        }
        this.jsonWriter.toJson(this.workspace.getData(), output);
        Optional.ofNullable(this.sourceDefinitions.getGeneralMessages()).ifPresent(this.dataAccumulator::addGeneralMessages);
        this.sourceDefinitions.postActions();
    }

    private void writeStandaloneJobs(List<SchedEntity> standaloneAndAssisting) {
        Map<String, List<SchedEntity>> saMap = this.getStandaloneAndAssistingJobs(standaloneAndAssisting, this.sourceDefinitions);
        for (String tableID : saMap.keySet()) {
            String tableName = this.getTableNameFromTableID(tableID);
            SimpleFolderSchedEntity standAloneSmartFolder = new SimpleFolderSchedEntity(tableName, saMap.get(tableID));
            this.addEntityToWorkspace(standAloneSmartFolder);
            this.dataAccumulator.update(standAloneSmartFolder);
        }
    }

    private void addEntityToWorkspace(SchedEntity entity) {
        this.workspace.addEntity(new DuplicationRemoverSchedEntityDecorator(entity));
    }

    private boolean isSmartFolder(IAttrHolder entityAttribute) {
        boolean hasChildren = this.topLevelHasChildren(entityAttribute);
        return hasChildren || this.sourceDefinitions.isContainerEntity(entityAttribute);
    }

    private boolean topLevelHasChildren(IAttrHolder entAttrs) {
        if (entAttrs instanceof TopLevelAttrHolder) {
            return this.sourceDefinitions.hasChildren(((TopLevelAttrHolder)entAttrs).getIdValue());
        }
        return this.sourceDefinitions.hasChildren(entAttrs.getAttr(this.sourceDefinitions.getIdFieldName()));
    }
}

