/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.DuplicationRemoverSchedEntityDecorator;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.VariableListArranger;
import com.bmc.ctmconvert.common.draftwriter.AdditionalAttributes;
import com.bmc.ctmconvert.common.draftwriter.AssistingJobUtils;
import com.bmc.ctmconvert.common.draftwriter.AttributeDescriptor;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.draftwriter.ElementDescriptor;
import com.bmc.ctmconvert.common.draftwriter.VersionControl;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.ondo.Capture;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class EntityWriter {
    private static DraftFormat draftFormat;
    private static int indentDepth;
    private static int entitySerial;

    public static void init(DraftFormat draftFormat) {
        EntityWriter.draftFormat = draftFormat;
        indentDepth = 0;
        entitySerial = 0;
    }

    public static void writeEntity(SchedEntity entity, SchedEntity parent, Writer output, DataAccumulator dataAccumulator) throws IOException, ConvertorCancelClickException {
        EntityWriter.writeEntity(entity, parent, output, null, dataAccumulator);
    }

    public static void writeEntity(SchedEntity entity, SchedEntity parent, Writer output, AdditionalAttributes addtionalAttrs, DataAccumulator dataAccumulator) throws IOException, ConvertorCancelClickException {
        int currentEntitySerial = ++entitySerial;
        if (!entity.isValid()) {
            dataAccumulator.update(entity, currentEntitySerial);
            return;
        }
        if (entity.type() == SchedEntity.TYPE.SMART_TABLE) {
            if (addtionalAttrs == null) {
                addtionalAttrs = new AdditionalAttributes();
            }
            String dataCenter = entity.getAttr("DATACENTER") != null ? entity.getAttr("DATACENTER") : Params.instance().getDatacenterName();
            VersionControl versionControl = new VersionControl();
            String version = versionControl.getVersionForXml();
            if (version.compareTo("900") > 0) {
                addtionalAttrs.setOverrideProperty("VERSION", version);
            }
            addtionalAttrs.setOverrideProperty("DATACENTER", dataCenter);
            addtionalAttrs.setOverrideProperty("TABLE_DSN", "<EMPTY_ATTRIBUTE_VALUE>");
            addtionalAttrs.setOverrideProperty("PLATFORM", "UNIX");
        }
        List allChildren = Optional.ofNullable(entity.getChildren()).orElse(new ArrayList());
        if (entity.type() != SchedEntity.TYPE.JOB) {
            allChildren.addAll(AssistingJobUtils.getChildrenAssistingJobs(entity));
        }
        ArrayList<SchedEntity> zosChildren = new ArrayList<SchedEntity>();
        ArrayList<SchedEntity> dsChildren = new ArrayList<SchedEntity>();
        if (!allChildren.isEmpty()) {
            for (SchedEntity childEntity : allChildren) {
                if (childEntity.isDSJob()) {
                    dsChildren.add(childEntity);
                    continue;
                }
                zosChildren.add(childEntity);
            }
        }
        ElementDescriptor entityElement = EntityWriter.getDraftFormat().getEntityElement(entity);
        if (EntityWriter.isDsEntity(entity, zosChildren, dsChildren)) {
            EntityWriter.writeDsEntities(entity, parent, output, addtionalAttrs, dataAccumulator, currentEntitySerial, dsChildren, entityElement);
        }
        if (entity.type() == SchedEntity.TYPE.SMART_TABLE && !zosChildren.isEmpty()) {
            addtionalAttrs.setOverrideProperty("DATACENTER", Params.instance().getMFDatacenterName());
            addtionalAttrs.removeOverrideProperty("TABLE_DSN");
            addtionalAttrs.setOverrideProperty("PLATFORM", "MVS");
            String mfShortFolderName = entity.getAttr("FOLDER_MF_NAME");
            if (mfShortFolderName != null) {
                entity.addAttribute("MAINFRAME_FOLDER", "");
            }
            EntityWriter.writeElement(entity, null, entityElement, output, currentEntitySerial, addtionalAttrs);
            ++indentDepth;
            for (ElementDescriptor child : entityElement.getChildElements()) {
                EntityWriter.writeElement(entity, child, output, currentEntitySerial);
            }
            for (SchedEntity childEntity : zosChildren) {
                EntityWriter.writeEntity(childEntity, entity, output, dataAccumulator);
            }
            int i = 0;
            while (i++ < indentDepth - 1) {
                output.write(9);
            }
            output.write(String.format("</%s>\n", entityElement.getDraftName()));
            dataAccumulator.update(entity, currentEntitySerial);
            --indentDepth;
        }
    }

    private static boolean isDsEntity(SchedEntity entity, ArrayList<SchedEntity> zosChildren, ArrayList<SchedEntity> dsChildren) {
        return entity.type() != SchedEntity.TYPE.SMART_TABLE || !dsChildren.isEmpty() || zosChildren.isEmpty();
    }

    private static void writeDsEntities(SchedEntity entity, SchedEntity parent, Writer output, AdditionalAttributes addtionalAttrs, DataAccumulator dataAccumulator, int currentEntitySerial, ArrayList<SchedEntity> dsChildren, ElementDescriptor entityElement) throws IOException {
        EntityWriter.writeElement(entity, parent, entityElement, output, currentEntitySerial, addtionalAttrs);
        ++indentDepth;
        for (ElementDescriptor child : entityElement.getChildElements()) {
            EntityWriter.writeElement(entity, child, output, currentEntitySerial);
        }
        if (!dsChildren.isEmpty()) {
            for (SchedEntity childEntity : dsChildren) {
                EntityWriter.writeEntity(childEntity, entity, output, dataAccumulator);
            }
        }
        int i = 0;
        while (i++ < indentDepth - 1) {
            output.write(9);
        }
        output.write(String.format("</%s>\n", entityElement.getDraftName()));
        if (!GlobalFunctions.isSmartFolder(entity)) {
            for (AssistingJob assJob : AssistingJobUtils.getSiblingAssistingJobs(entity)) {
                EntityWriter.writeEntity(assJob, null, output, dataAccumulator);
            }
        }
        dataAccumulator.update(entity, currentEntitySerial);
        --indentDepth;
    }

    private static DraftFormat getDraftFormat() {
        return draftFormat;
    }

    private static void writeElement(SchedEntity entity, ElementDescriptor elem, Writer output, int currentEntitySerial) throws IOException {
        EntityWriter.writeElement(entity, null, elem, output, currentEntitySerial, null);
    }

    private static void writeElement(SchedEntity entity, SchedEntity parent, ElementDescriptor elem, Writer output, int currentEntitySerial, AdditionalAttributes addtionalAttrs) throws IOException {
        block16: {
            String internalName;
            Object indentStr;
            block18: {
                block17: {
                    block15: {
                        indentStr = "";
                        int i = 0;
                        while (i++ < indentDepth) {
                            indentStr = "\t" + (String)indentStr;
                        }
                        if (!elem.isSchedEnt()) break block15;
                        output.write(String.format("%s<%s%n", indentStr, elem.getDraftName()));
                        for (AttributeDescriptor attr : elem.getAttrs()) {
                            String attrStr;
                            if (attr.isSkipped(entity)) continue;
                            if (attr.getDraftName().equalsIgnoreCase("INTERVAL") && EntityWriter.parentIsCyclic(parent)) {
                                output.write(String.format("%s%s", (String)indentStr + "\t", attr.toString("0000M")));
                                continue;
                            }
                            String value = EntityWriter.getValue(entity, currentEntitySerial, addtionalAttrs, attr);
                            if ("<EMPTY_ATTRIBUTE_VALUE>".equals(value) || (attrStr = attr.toString(value)).isEmpty()) continue;
                            output.write(String.format("%s%s", (String)indentStr + "\t", attrStr));
                        }
                        output.write((String)indentStr);
                        output.write(">\n");
                        break block16;
                    }
                    internalName = elem.getInternalName();
                    if (!internalName.equals("AUTOEDIT")) break block17;
                    EntityWriter.convertAutoEdits(entity, elem, output, (String)indentStr);
                    break block16;
                }
                if (!internalName.equals("ON_STMT")) break block18;
                List<Object> elementValues = new ArrayList();
                Map<Properties, List<Properties>> complexElementValue = EntityWriter.getComplexElementProperties(internalName, entity);
                if (complexElementValue == null || complexElementValue.isEmpty()) {
                    elementValues = EntityWriter.getElementProperties(internalName, entity);
                } else {
                    for (Properties properties : complexElementValue.keySet()) {
                        elementValues.add(properties);
                    }
                }
                if (elementValues == null || elementValues.isEmpty()) break block16;
                for (Properties properties : elementValues) {
                    List<Object> elementChildValues = new ArrayList<Properties>();
                    if (complexElementValue == null) {
                        elementChildValues.add(properties);
                    } else {
                        List<Properties> doList = complexElementValue.get(properties);
                        if (doList != null) {
                            elementChildValues = doList;
                        }
                    }
                    output.write((String)indentStr);
                    output.write(elem.openElementTag(properties, false, " "));
                    output.write(10);
                    for (Properties properties2 : elementChildValues) {
                        ElementDescriptor doElement = elem.getSubElementByName(properties2.getProperty("ACTION"));
                        if (doElement == null) {
                            doElement = elem.getSubElementByName("DO");
                        }
                        output.write((String)indentStr + "\t");
                        if (doElement.hasChildElements()) {
                            EntityWriter.convertDoChildElements(output, (String)indentStr, properties2, doElement);
                            continue;
                        }
                        output.write(doElement.openElementTag(properties2, true, " "));
                        output.write(10);
                    }
                    output.write((String)indentStr);
                    output.write(elem.closeElementTag());
                }
                break block16;
            }
            List<Properties> elementValues = EntityWriter.getElementProperties(internalName, entity);
            if (elementValues != null) {
                for (Properties currentValues : elementValues) {
                    output.write((String)indentStr);
                    output.write(elem.openElementTag(currentValues, true, " "));
                    output.write(10);
                }
            }
        }
    }

    private static boolean parentIsCyclic(SchedEntity parent) {
        return Optional.ofNullable(parent).map(SchedEntity::isCyclic).orElse(false);
    }

    private static String getValue(SchedEntity entity, int currentEntitySerial, AdditionalAttributes addtionalAttrs, AttributeDescriptor attr) {
        Optional<AdditionalAttributes> attrsOp = Optional.ofNullable(addtionalAttrs);
        Optional<String> overridePropertyOrDefault = attrsOp.map(attrs -> attrs.getOverrideProperty(attr.getInternalName())).or(() -> Optional.ofNullable(attr.getValue(entity, currentEntitySerial)));
        return overridePropertyOrDefault.or(() -> attrsOp.map(attrs -> attrs.getUnderrideProperty(attr.getInternalName()))).orElse(null);
    }

    private static void convertAutoEdits(SchedEntity entity, ElementDescriptor elem, Writer output, String indentStr) throws IOException {
        LinkedHashMap<String, String> allAutoedits = entity.getAutoedits();
        if (allAutoedits != null) {
            List<Properties> autoEditProps = new ArrayList<Properties>();
            ArrayList<Properties> autoEditsWithReference = new ArrayList<Properties>();
            for (Map.Entry<String, String> autoedits : allAutoedits.entrySet()) {
                Properties currAutoedit = new Properties();
                String autoEditName = autoedits.getKey();
                String autoEditValue = autoedits.getValue();
                boolean hasReference = allAutoedits.keySet().stream().anyMatch(name -> !name.equals(autoEditName) && name.contains(autoEditName));
                currAutoedit.setProperty("NAME", autoEditName);
                if (autoEditValue == null) {
                    throw new NullPointerException(autoEditName + " is null");
                }
                currAutoedit.setProperty("VALUE", autoEditValue);
                if (allAutoedits.get(autoEditName).contains("%%") && !hasReference) {
                    autoEditsWithReference.add(currAutoedit);
                    continue;
                }
                autoEditProps.add(currAutoedit);
            }
            autoEditProps.addAll(autoEditsWithReference);
            String jobType = entity.getAttr("APPL_TYPE");
            VariableListArranger listArranger = VariableListArranger.getInstance();
            autoEditProps = listArranger.arrangeList(autoEditProps, jobType);
            for (Properties autoedit : autoEditProps) {
                output.write(indentStr);
                output.write(elem.openElementTag(autoedit, true, " "));
                output.write(10);
            }
        }
    }

    private static void convertDoChildElements(Writer output, String indentStr, Properties doStatement, ElementDescriptor doElement) throws IOException {
        output.write(doElement.openElementTag(doStatement, false, " "));
        output.write(10);
        for (ElementDescriptor childElement : doElement.getChildElements()) {
            if (!childElement.getInternalName().equals("VARIABLE")) continue;
            EntityWriter.writeDoVariabels(output, indentStr, doStatement, childElement);
        }
        output.write(indentStr + "\t");
        output.write(doElement.closeElementTag());
    }

    private static void writeDoVariabels(Writer output, String indentStr, Properties doStatement, ElementDescriptor childElement) throws IOException {
        Map childProperties = Optional.ofNullable((Map)doStatement.get(childElement.getInternalName())).orElse(Collections.emptyMap());
        Properties variableProperties = new Properties();
        for (Map.Entry ent : childProperties.entrySet()) {
            variableProperties.put("NAME", ent.getKey());
            variableProperties.put("VALUE", ent.getValue());
            output.write(indentStr + "\t\t");
            output.write(childElement.openElementTag(variableProperties, true, " "));
            output.write(10);
        }
    }

    private static List<Properties> getElementProperties(String internalName, SchedEntity entity) {
        DuplicationRemoverSchedEntityDecorator entityWithoutDuplicates = new DuplicationRemoverSchedEntityDecorator(entity);
        return switch (internalName) {
            case "INCOND" -> entityWithoutDuplicates.getInConds();
            case "OUTCOND" -> entityWithoutDuplicates.getOutConds();
            case "TAG" -> entityWithoutDuplicates.getTags();
            case "QUANTITATIVE" -> entityWithoutDuplicates.getQuantResources();
            case "CONTROL" -> entityWithoutDuplicates.getCtrlResources();
            case "ON_STMT" -> entityWithoutDuplicates.getOnStmt();
            case "SHOUTS" -> entityWithoutDuplicates.getShouts();
            case "CAPTURES" -> EntityWriter.getCapture(entity);
            default -> Collections.emptyList();
        };
    }

    private static List<Properties> getCapture(SchedEntity entity) {
        if (entity.getCaptures() != null) {
            return entity.getCaptures().stream().map(Capture::toProperties).toList();
        }
        return null;
    }

    private static Map<Properties, List<Properties>> getComplexElementProperties(String internalName, SchedEntity entity) {
        LinkedHashMap<Properties, List<Properties>> toRet = null;
        if (internalName.equals("ON_STMT")) {
            toRet = entity.getOnDoStmt();
        }
        return toRet;
    }

    public static void writeStandAloneJob(SchedEntity job, Writer output, String standaloneJobsTablename, DataAccumulator dataAccumulator) throws IOException, ConvertorCancelClickException {
        AdditionalAttributes moreAttrs = new AdditionalAttributes();
        if (job.isValid()) {
            if (job.getTags() != null) {
                for (Properties rbc : job.getTags()) {
                    Enumeration<Object> em = rbc.keys();
                    while (em.hasMoreElements()) {
                        String name = String.valueOf(em.nextElement());
                        String value = rbc.getProperty(name);
                        moreAttrs.setUnderrideProperty(name, value);
                    }
                }
                job.getTags().clear();
            }
            moreAttrs.setOverrideProperty("PARENT_TABLE", standaloneJobsTablename);
        }
        ++indentDepth;
        EntityWriter.writeEntity(job, null, output, moreAttrs, dataAccumulator);
        --indentDepth;
    }

    static {
        indentDepth = 0;
        entitySerial = 0;
    }
}

