/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.ValueTransformer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributeDescriptor {
    public static final String MANDATORY = "mandatory";
    public static final String INTERNAL_NAME = "internal_name";
    public static final String TRANSFORMATION_TYPE = "transformation";
    private final String internalName;
    private String draftName;
    private String defaultValue;
    private boolean isMandatory;
    private ValueTransformer transformation = null;
    private String condition;
    private BiFunction<Integer, String, String> descriptionValueGetter = (serial, desc) -> String.format("[JOBIDFORMESSAGES=%d]%s", serial, desc);

    public AttributeDescriptor(Map<String, String> lineVals, BiFunction<Integer, String, String> descriptionValueGetter) {
        this.internalName = lineVals.get(INTERNAL_NAME);
        this.draftName = lineVals.get("draft_name");
        this.defaultValue = lineVals.get("default");
        if (this.internalName.equals("CREATION_DATE") || this.internalName.equals("CREATION_TIME")) {
            this.setDateTimeDefault();
        }
        this.isMandatory = lineVals.get(MANDATORY).equals("true");
        if (lineVals.get(TRANSFORMATION_TYPE) != null && !lineVals.get(TRANSFORMATION_TYPE).isEmpty()) {
            this.transformation = new ValueTransformer(lineVals.get(TRANSFORMATION_TYPE));
        }
        this.condition = lineVals.get("condition");
        if (null != descriptionValueGetter) {
            this.descriptionValueGetter = descriptionValueGetter;
        }
    }

    private void setDateTimeDefault() {
        if (this.internalName.equals("CREATION_DATE")) {
            this.defaultValue = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        } else if (this.internalName.equals("CREATION_TIME")) {
            this.defaultValue = new SimpleDateFormat("HHmmss").format(Calendar.getInstance().getTime());
        }
    }

    public boolean isSkipped(SchedEntity ent) {
        boolean toRet = false;
        if (this.condition != null && !this.condition.isEmpty()) {
            this.condition = this.condition.replace(" and ", " AND ").replace(" or ", " OR ");
            boolean andResult = true;
            String[] arrByAnd = this.condition.split(" AND ");
            for (int i = 0; i < arrByAnd.length && andResult; ++i) {
                boolean orResult = false;
                String[] arrByOr = arrByAnd[i].split(" OR ");
                for (int j = 0; j < arrByOr.length && !orResult; ++j) {
                    orResult = this.testCondition(arrByOr[j], ent);
                }
                andResult = orResult;
            }
            toRet = !andResult;
        }
        return toRet;
    }

    private boolean testCondition(String condition, SchedEntity ent) {
        boolean toRet = false;
        Matcher m = Pattern.compile("\\s*(\\S+)\\s*([!=][=~])\\s*(\\S+)\\s*").matcher(condition);
        if (m.matches()) {
            boolean positive;
            String entValue = this.getValue(ent, m.group(1));
            String testValue = m.group(3);
            boolean byRegex = m.group(2).charAt(1) == '~';
            boolean bl = positive = m.group(2).charAt(0) == '=';
            if (byRegex) {
                toRet = entValue != null && entValue.matches(testValue);
            } else {
                boolean bl2 = toRet = entValue != null && entValue.equals(testValue);
            }
            if (!positive) {
                toRet = !toRet;
            }
        }
        return toRet;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getDraftName() {
        return this.draftName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public String toString(String attrValue) {
        return this.toString(attrValue, "\n");
    }

    public String toString(String attrValue, String attrTerminator) {
        if (this.isMandatory && attrValue == null) {
            attrValue = this.defaultValue;
        }
        return attrValue == null ? "" : String.format("%s=\"%s\"%s", this.draftName, this.transformValue(attrValue), attrTerminator);
    }

    public String getValue(SchedEntity ent, int serial) {
        return this.getValue(ent, this.internalName, serial);
    }

    private String getValue(SchedEntity ent, String attribute) {
        return this.getValue(ent, attribute, 0);
    }

    private String getValue(SchedEntity ent, String attribute, int serial) {
        return switch (attribute) {
            case "JOBNAME" -> this.getJobName(ent);
            case "TABLE_NAME" -> this.getTableName(ent);
            case "PARENT_TABLE" -> {
                if (ent.getParentName() == null || ent.getParentName().isEmpty()) {
                    yield ent.getTableName();
                }
                yield ent.getParentName();
            }
            case "CYCLIC" -> {
                if (ent.isCyclic()) {
                    yield "1";
                }
                yield "0";
            }
            case "APPLICATION" -> ent.getApplication();
            case "GROUP" -> ent.getGroup();
            case "CREATION_USER" -> String.valueOf(serial);
            case "DESCRIPTION" -> this.getDescription(ent, attribute, serial);
            default -> ent.getAttr(attribute);
        };
    }

    private String getTableName(SchedEntity ent) {
        String mfShortFolderName = ent.getAttr("FOLDER_MF_NAME");
        boolean isMf = Optional.ofNullable(ent.getAttr("MAINFRAME_FOLDER")).isPresent();
        if (isMf && mfShortFolderName != null) {
            return mfShortFolderName;
        }
        return ent.getTableName();
    }

    private String getJobName(SchedEntity ent) {
        String mfShortFolderName = ent.getAttr("FOLDER_MF_NAME");
        boolean isMf = Optional.ofNullable(ent.getAttr("MAINFRAME_FOLDER")).isPresent();
        if (isMf && mfShortFolderName != null) {
            return mfShortFolderName;
        }
        return ent.getJobName();
    }

    private String getDescription(SchedEntity ent, String attribute, int serial) {
        String desc = ent.getAttr(attribute);
        if (desc == null) {
            desc = "";
        }
        return this.descriptionValueGetter.apply(serial, desc);
    }

    private Object transformValue(String attrValue) {
        if (attrValue.equals("EMPTY")) {
            attrValue = "";
        }
        if (this.transformation != null) {
            attrValue = this.transformation.transform(attrValue, this.defaultValue);
        }
        return GlobalFunctions.EncodeXMLString(attrValue);
    }

    public void applyOverrides(Map<String, String> overrides) {
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            switch (entry.getKey()) {
                case "draft_name": {
                    this.draftName = entry.getValue();
                    break;
                }
                case "default": {
                    this.defaultValue = entry.getValue();
                    break;
                }
                case "mandatory": {
                    this.isMandatory = entry.getValue().equals("true");
                    break;
                }
                case "condition": {
                    this.condition = overrides.get("condition");
                    break;
                }
                case "transformation": {
                    this.transformation = new ValueTransformer(overrides.get(TRANSFORMATION_TYPE));
                    break;
                }
            }
        }
    }
}

