/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.dataObject;

import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;

public class Attributes
implements Iterable<Pair<String, String>> {
    private final List<Pair<String, String>> attributes;

    public Attributes(List<Pair<String, String>> attributes) {
        this.attributes = attributes;
    }

    public List<Pair<String, String>> getPairs() {
        return new ArrayList<Pair<String, String>>(this.attributes);
    }

    @Override
    public Iterator<Pair<String, String>> iterator() {
        return this.attributes.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Pair<String, String> pair : this.attributes) {
            builder.append(pair).append("\n");
        }
        return builder.toString();
    }

    public List<String> getValuesof(String attributeName) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Pair<String, String> attriute : this.attributes) {
            if (!attriute.getKey().equals(attributeName)) continue;
            ret.add(attriute.getValue());
        }
        return ret;
    }

    public Attributes getAttributesThatValueStartWith(String prefix) {
        ArrayList<Pair<String, String>> ret = new ArrayList<Pair<String, String>>();
        for (Pair<String, String> attriute : this.attributes) {
            if (!attriute.getValue().startsWith(prefix)) continue;
            ret.add(attriute);
        }
        return new Attributes(ret);
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributes.stream().anyMatch(attribute -> ((String)attribute.getKey()).equals(attributeName));
    }

    public boolean hasAttribute(String attributeName, String attributeValue) {
        return this.attributes.stream().anyMatch(attribute -> ((String)attribute.getKey()).equals(attributeName) && ((String)attribute.getValue()).equals(attributeValue));
    }

    public boolean hasAttribute(BiPredicate<String, String> predicate) {
        return this.attributes.stream().anyMatch(attribute -> predicate.test((String)attribute.getKey(), (String)attribute.getValue()));
    }

    public Optional<String> findFirstValue(String attributeName) {
        for (Pair<String, String> attribute : this.attributes) {
            if (!attribute.getKey().equals(attributeName)) continue;
            return Optional.of(attribute.getValue());
        }
        return Optional.empty();
    }
}

