/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.conditions;

import com.bmc.ctmconvert.common.conditions.Condition;
import java.util.Optional;

public class ConditionBuilder<T extends ConditionBuilder<T>> {
    private static final MissingConditionNameException missingConditionNameException = new MissingConditionNameException();
    private Optional<String> conditionName = Optional.empty();
    private String odate = "ODAT";

    public T setOdate(String odate) {
        this.odate = odate;
        return (T)this;
    }

    public T setConditionName(String conditionName) {
        this.conditionName = Optional.ofNullable(conditionName);
        return (T)this;
    }

    public Condition build() {
        return new Condition(this.getConditionNameOrThrow(), this.odate);
    }

    private String getConditionNameOrThrow() {
        return this.conditionName.orElseThrow(() -> missingConditionNameException);
    }

    public static class MissingConditionNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

